/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.lifecycle;

import com.uber.autodispose.lifecycle.CorrespondingEventsFunction;
import com.uber.autodispose.lifecycle.LifecycleEndedException;
import com.uber.autodispose.lifecycle.LifecycleScopeProvider;
import com.uber.autodispose.lifecycle.LifecycleScopes;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.annotations.Nullable;
import io.reactivex.subjects.BehaviorSubject;

public final class TestLifecycleScopeProvider
implements LifecycleScopeProvider<TestLifecycle> {
    private final BehaviorSubject<TestLifecycle> lifecycleSubject;

    private TestLifecycleScopeProvider(@Nullable TestLifecycle initialValue) {
        this.lifecycleSubject = initialValue == null ? BehaviorSubject.create() : BehaviorSubject.createDefault((Object)((Object)initialValue));
    }

    public static TestLifecycleScopeProvider create() {
        return new TestLifecycleScopeProvider(null);
    }

    public static TestLifecycleScopeProvider createInitial(TestLifecycle initialValue) {
        return new TestLifecycleScopeProvider(initialValue);
    }

    @Override
    public Observable<TestLifecycle> lifecycle() {
        return this.lifecycleSubject.hide();
    }

    @Override
    public CorrespondingEventsFunction<TestLifecycle> correspondingEvents() {
        return new CorrespondingEventsFunction<TestLifecycle>(){

            @Override
            public TestLifecycle apply(TestLifecycle testLifecycle) {
                switch (testLifecycle) {
                    case STARTED: {
                        return TestLifecycle.STOPPED;
                    }
                    case STOPPED: {
                        throw new LifecycleEndedException();
                    }
                }
                throw new IllegalStateException("Unknown lifecycle event.");
            }
        };
    }

    @Override
    public TestLifecycle peekLifecycle() {
        return (TestLifecycle)((Object)this.lifecycleSubject.getValue());
    }

    public CompletableSource requestScope() {
        return LifecycleScopes.resolveScopeFromLifecycle(this);
    }

    public void start() {
        this.lifecycleSubject.onNext((Object)TestLifecycle.STARTED);
    }

    public void stop() {
        if (this.lifecycleSubject.getValue() != TestLifecycle.STARTED) {
            throw new IllegalStateException("Attempting to stop lifecycle before starting it.");
        }
        this.lifecycleSubject.onNext((Object)TestLifecycle.STOPPED);
    }

    public static enum TestLifecycle {
        STARTED,
        STOPPED;

    }
}

