/*
 * Decompiled with CFR 0.152.
 */
package com.dandan.jsonhandleview.library;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.dandan.jsonhandleview.library.JsonView;
import com.dandan.jsonhandleview.library.R;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonViewLayout
extends ScrollView {
    private int ITEM_KEY_COLOR = -10377423;
    private int OBJECT_KEY_COLOR = -13421773;
    private int TEXT_COLOR = -1151165;
    private int NUMBER_COLOR = -3976202;
    private int ARRAY_LENGTH_COLOR = -1;
    private int BOOLEAN_COLOR = -12543801;
    private int NULL_COLOR = -4408744;
    public static float TEXT_SIZE_DP = 18.0f;
    private int TEXT_SIZE_DP_MAX = 32;
    private int TEXT_SIZE_DP_MIN = 12;
    private int ARRAY_LENGTH_BACKGROUND = R.drawable.jsonview_select_bg;
    private Context mContext;
    private JSONObject mJSONObject;
    private JSONArray mJSONArray;
    private LinearLayout contentView;
    private HorizontalScrollView horizontalScrollView;
    int mode;
    float oldDist;

    public JsonViewLayout(Context context) {
        super(context);
        this.initView(context);
    }

    public JsonViewLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public JsonViewLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        this.contentView = new LinearLayout(this.mContext);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.contentView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.contentView.setOrientation(1);
        this.horizontalScrollView = new HorizontalScrollView(this.mContext);
        this.horizontalScrollView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.horizontalScrollView.setPadding(12, 12, 12, 0);
        this.horizontalScrollView.addView((View)this.contentView);
        this.addView((View)this.horizontalScrollView);
    }

    public void bindJson(String jsonStr) {
        if (this.canBindData()) {
            throw new IllegalArgumentException("JsonViweLayout can not bind again.");
        }
        Object object = null;
        try {
            object = new JSONTokener(jsonStr).nextValue();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (object != null && object instanceof JSONObject) {
            this.mJSONObject = (JSONObject)object;
        } else if (object != null && object instanceof JSONArray) {
            this.mJSONArray = (JSONArray)object;
        } else {
            throw new IllegalArgumentException("jsonStr is illegal.");
        }
        this.createView();
    }

    public void bindJson(JSONObject mJSONObject) {
        if (this.canBindData()) {
            throw new IllegalArgumentException("JsonViweLayout can not bind again.");
        }
        this.mJSONObject = mJSONObject;
        if (mJSONObject == null) {
            throw new IllegalArgumentException("jsonObject can not be null.");
        }
        this.createView();
    }

    public void bindJson(JSONArray mJSONArray) {
        if (this.canBindData()) {
            throw new IllegalArgumentException("JsonViweLayout can not bind again.");
        }
        this.mJSONArray = mJSONArray;
        if (mJSONArray == null) {
            throw new IllegalArgumentException("jsonArray can not be null.");
        }
        this.createView();
    }

    private boolean canBindData() {
        return null != this.mJSONObject || null != this.mJSONArray;
    }

    private void createView() {
        JsonView jsonView = new JsonView(this.mContext);
        jsonView.showIcon(true);
        jsonView.hideValue();
        SpannableStringBuilder keyBuilder = new SpannableStringBuilder();
        keyBuilder.append((CharSequence)"JSON");
        keyBuilder.setSpan((Object)new ForegroundColorSpan(this.OBJECT_KEY_COLOR), 0, keyBuilder.length(), 33);
        jsonView.showKey((CharSequence)keyBuilder);
        JSONObject value = null != this.mJSONObject ? this.mJSONObject : this.mJSONArray;
        jsonView.setIconClickListener(new JsonViewOnClickListener(value, jsonView, 0));
        this.contentView.addView((View)jsonView);
    }

    private void handleJsonObject(String key, Object value, JsonView itemView, int hierarchy) {
        SpannableStringBuilder keyBuilder = new SpannableStringBuilder();
        SpannableStringBuilder valueBuilder = new SpannableStringBuilder();
        itemView.hideIcon();
        if (value instanceof JSONObject) {
            itemView.showIcon(true);
            itemView.setIconClickListener(new JsonViewOnClickListener(value, itemView, hierarchy + 1));
            keyBuilder.append((CharSequence)key);
            keyBuilder.setSpan((Object)new ForegroundColorSpan(this.OBJECT_KEY_COLOR), 0, keyBuilder.length(), 33);
            itemView.setCommand(this.getHierarchyStr(hierarchy + 1));
        } else {
            keyBuilder.append((CharSequence)"\"").append((CharSequence)key).append((CharSequence)"\"").append((CharSequence)":");
            keyBuilder.setSpan((Object)new ForegroundColorSpan(this.ITEM_KEY_COLOR), 0, keyBuilder.length(), 33);
            if (value instanceof JSONArray) {
                itemView.showIcon(true);
                itemView.setIconClickListener(new JsonViewOnClickListener(value, itemView, hierarchy + 1));
                itemView.setCommand(this.getHierarchyStr(hierarchy));
                valueBuilder.append((CharSequence)("  " + ((JSONArray)value).length() + "  "));
                valueBuilder.setSpan((Object)new ForegroundColorSpan(this.ARRAY_LENGTH_COLOR), 0, valueBuilder.length(), 33);
                itemView.showValue((CharSequence)valueBuilder);
                itemView.showArrayLength(this.ARRAY_LENGTH_BACKGROUND);
            } else {
                itemView.hideIcon();
                valueBuilder.append((CharSequence)value.toString());
                int valueColor = value instanceof String ? this.TEXT_COLOR : (value instanceof Boolean ? this.BOOLEAN_COLOR : (value instanceof Number ? this.NUMBER_COLOR : this.NULL_COLOR));
                valueBuilder.setSpan((Object)new ForegroundColorSpan(valueColor), 0, valueBuilder.length(), 33);
                itemView.showValue((CharSequence)valueBuilder);
                itemView.setCommand(this.getHierarchyStr(hierarchy + 1));
            }
        }
        itemView.showKey((CharSequence)keyBuilder);
    }

    public void setTextSize(float sizeDP) {
        if (sizeDP < (float)this.TEXT_SIZE_DP_MIN) {
            sizeDP = this.TEXT_SIZE_DP_MIN;
        } else if (sizeDP > (float)this.TEXT_SIZE_DP_MAX) {
            sizeDP = this.TEXT_SIZE_DP_MAX;
        }
        if (TEXT_SIZE_DP != sizeDP) {
            TEXT_SIZE_DP = sizeDP;
            this.updateAll(sizeDP);
        }
    }

    public void updateAll(float textSize) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.contentView.getChildAt(i);
            this.loop(view, textSize);
        }
    }

    private void loop(View view, float textSize) {
        if (view instanceof JsonView) {
            JsonView group = (JsonView)view;
            group.setTextSize(textSize);
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view1 = group.getChildAt(i);
                this.loop(view1, textSize);
            }
        }
    }

    private void zoom(float f) {
        Log.d((String)"tanzhenxing", (String)("zoom = " + f));
        this.setTextSize(TEXT_SIZE_DP * (f / 100.0f + 1.0f));
    }

    private float spacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean intercept = false;
        switch (event.getAction() & event.getActionMasked()) {
            case 0: {
                this.mode = 1;
                break;
            }
            case 1: {
                this.mode = 0;
                break;
            }
            case 6: {
                intercept = true;
                --this.mode;
                break;
            }
            case 5: {
                intercept = false;
                this.oldDist = this.spacing(event);
                ++this.mode;
                break;
            }
            case 2: {
                float newDist;
                if (this.mode < 2 || !(Math.abs((newDist = this.spacing(event)) - this.oldDist) > 3.0f)) break;
                this.zoom(newDist - this.oldDist);
                this.oldDist = newDist;
            }
        }
        return intercept ? intercept : super.dispatchTouchEvent(event);
    }

    public void setKeyColor(int color) {
        this.ITEM_KEY_COLOR = color;
    }

    public void setObjectKeyColor(int color) {
        this.OBJECT_KEY_COLOR = color;
    }

    public void setValueTextColor(int color) {
        this.TEXT_COLOR = color;
    }

    public void setValueNumberColor(int color) {
        this.NUMBER_COLOR = color;
    }

    public void setValueBooleanColor(int color) {
        this.BOOLEAN_COLOR = color;
    }

    public void setValueNullColor(int color) {
        this.NUMBER_COLOR = color;
    }

    public void setArrayLengthColor(int color) {
        this.ARRAY_LENGTH_COLOR = color;
    }

    private String getHierarchyStr(int hierarchy) {
        StringBuilder levelStr = new StringBuilder();
        for (int levelI = 0; levelI < hierarchy; ++levelI) {
            levelStr.append("      ");
        }
        return levelStr.toString();
    }

    public void expandAll() {
        if (this.contentView != null) {
            this.clickAllView((ViewGroup)this.contentView, false);
        }
    }

    public void collapseAll() {
        if (this.contentView != null) {
            this.clickAllView((ViewGroup)this.contentView, true);
        }
    }

    private void clickAllView(ViewGroup viewGroup, boolean collapse) {
        if (viewGroup instanceof JsonView) {
            JsonView jsonView = (JsonView)viewGroup;
            this.operationJsonView(jsonView, collapse);
        }
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (viewGroup instanceof JsonView) {
                JsonView jsonView = (JsonView)viewGroup;
                this.operationJsonView(jsonView, collapse);
            }
            if (!(view instanceof ViewGroup)) continue;
            this.clickAllView((ViewGroup)view, collapse);
        }
    }

    private void operationJsonView(JsonView jsonView, boolean collapse) {
        if (jsonView != null) {
            if (collapse) {
                jsonView.expand();
            } else {
                jsonView.collapse();
            }
        }
    }

    class JsonViewOnClickListener
    implements View.OnClickListener {
        private Object value;
        private JsonView itemView;
        private int hierarchy;
        private boolean isexpand = true;
        private boolean isJsonArray;

        public JsonViewOnClickListener(Object value, JsonView itemView, int hierarchy) {
            this.value = value;
            this.itemView = itemView;
            this.hierarchy = hierarchy;
            this.isJsonArray = value != null && value instanceof JSONArray;
        }

        public void onClick(View v) {
            Object obj = v.getTag();
            if (obj != null && obj instanceof Boolean) {
                this.isexpand = (Boolean)obj;
                v.setTag(null);
            }
            if (this.itemView.getChildCount() == 1) {
                Object nameValuePairs;
                JSONArray array;
                this.isexpand = false;
                JSONArray jSONArray = array = this.isJsonArray ? (JSONArray)this.value : ((JSONObject)this.value).names();
                if (!this.isJsonArray && array.length() == 1 && "nameValuePairs".equals(array.opt(0).toString()) && null != (nameValuePairs = ((JSONObject)this.value).opt("nameValuePairs"))) {
                    this.value = nameValuePairs;
                    this.isJsonArray = this.value instanceof JSONArray;
                    array = this.isJsonArray ? (JSONArray)this.value : ((JSONObject)this.value).names();
                }
                for (int i = 0; array != null && i < array.length(); ++i) {
                    JsonView childItemView = new JsonView(this.itemView.getContext());
                    Object childValue = array.opt(i);
                    if (this.isJsonArray) {
                        JsonViewLayout.this.handleJsonObject(String.valueOf(i), childValue, childItemView, this.hierarchy);
                    } else {
                        JsonViewLayout.this.handleJsonObject((String)childValue, ((JSONObject)this.value).opt((String)childValue), childItemView, this.hierarchy);
                    }
                    this.itemView.addViewNoInvalidate((View)childItemView);
                }
                this.itemView.showIcon(this.isexpand);
                this.itemView.requestLayout();
                this.itemView.invalidate();
            } else {
                this.isexpand = !this.isexpand;
                this.itemView.showIcon(this.isexpand);
                for (int i = 1; i < this.itemView.getChildCount(); ++i) {
                    this.itemView.getChildAt(i).setVisibility(!this.isexpand ? 0 : 8);
                }
            }
        }
    }
}

