/*
 * Decompiled with CFR 0.152.
 */
package com.dandan.jsonhandleview.library;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.dandan.jsonhandleview.library.JsonViewLayout;
import com.dandan.jsonhandleview.library.R;

public class JsonView
extends LinearLayout {
    private ImageView imageview;
    private TextView keyTV;
    private TextView valueTV;
    private TextView commandTV;
    private View contentView;
    private Context mContext;

    public JsonView(Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public JsonView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    public JsonView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        this.setOrientation(1);
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_view_jsonview_layout, (ViewGroup)this, true);
        this.imageview = (ImageView)this.findViewById(R.id.icon);
        this.keyTV = (TextView)this.findViewById(R.id.key);
        this.valueTV = (TextView)this.findViewById(R.id.value);
        this.commandTV = (TextView)this.findViewById(R.id.command);
        this.contentView = this.findViewById(R.id.content);
        this.contentView.setBackgroundColor(0);
        this.imageview.setVisibility(8);
        this.keyTV.setVisibility(8);
        this.valueTV.setVisibility(8);
        this.setTextSize(JsonViewLayout.TEXT_SIZE_DP);
    }

    public void setTextSize(float textSizeDp) {
        int rightMargin;
        JsonViewLayout.TEXT_SIZE_DP = (int)textSizeDp;
        this.keyTV.setTextSize(JsonViewLayout.TEXT_SIZE_DP);
        this.valueTV.setTextSize(JsonViewLayout.TEXT_SIZE_DP);
        this.commandTV.setTextSize(JsonViewLayout.TEXT_SIZE_DP);
        int textSize = (int)TypedValue.applyDimension((int)1, (float)JsonViewLayout.TEXT_SIZE_DP, (DisplayMetrics)this.getResources().getDisplayMetrics());
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.imageview.getLayoutParams();
        layoutParams.height = textSize;
        layoutParams.width = textSize;
        layoutParams.rightMargin = rightMargin = (int)TypedValue.applyDimension((int)1, (float)(JsonViewLayout.TEXT_SIZE_DP / 4.0f), (DisplayMetrics)this.getResources().getDisplayMetrics());
        layoutParams.gravity = 16;
        this.imageview.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setCommand(CharSequence sequence) {
        this.commandTV.setText(sequence);
    }

    public void hideIcon() {
        this.imageview.setVisibility(8);
    }

    public void showIcon(boolean canExpand) {
        this.imageview.setVisibility(0);
        this.imageview.setImageResource(canExpand ? R.drawable.jsonview_item_expand : R.drawable.jsonview_item_collapse);
    }

    public void hideValue() {
        this.valueTV.setVisibility(8);
    }

    public void showValue(CharSequence s) {
        this.valueTV.setVisibility(0);
        this.valueTV.setText(s);
        this.valueTV.setBackgroundColor(0);
    }

    public void showArrayLength(int resId) {
        this.valueTV.setBackgroundResource(resId);
    }

    public void showKey(CharSequence s) {
        this.keyTV.setVisibility(0);
        this.keyTV.setText(s);
    }

    public void setIconClickListener(View.OnClickListener listener) {
        this.imageview.setOnClickListener(listener);
    }

    public void addViewNoInvalidate(View child) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null && (params = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addViewInLayout(child, -1, params);
    }
}

