/*
 * Decompiled with CFR 0.152.
 */
package com.twolight.android.permission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.twolight.android.permission.PermissionListener;
import java.util.ArrayList;
import java.util.List;

public class PermissionFragment
extends Fragment {
    private PermissionListener mPermissionListener;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.checkPermission(requestCode, permissions, grantResults);
    }

    private void checkPermission(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions.length > 0 && grantResults.length > 0) {
            boolean allGranted = true;
            for (int item : grantResults) {
                if (item == 0) continue;
                allGranted = false;
                break;
            }
            this.onPermissionResult(allGranted, requestCode);
        }
    }

    public void onPermissionResult(boolean success, int requestCode) {
        this.mPermissionListener.onPermissionResult(success, requestCode);
        this.mPermissionListener = null;
    }

    public void requestPermission(String[] permission2, int requestCode, PermissionListener permissionListener) {
        this.mPermissionListener = permissionListener;
        if (Build.VERSION.SDK_INT >= 23) {
            List<String> inDangerousPermissions = PermissionFragment.filterPermission(permission2);
            ArrayList<String> noGranted = new ArrayList<String>();
            for (String item : inDangerousPermissions) {
                int result = ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)item);
                if (result == 0) continue;
                noGranted.add(item);
            }
            if (!noGranted.isEmpty()) {
                String[] will = new String[noGranted.size()];
                noGranted.toArray(will);
                boolean needShowMessage = false;
                for (String p : will) {
                    if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)p)) continue;
                    needShowMessage = true;
                    break;
                }
                if (needShowMessage) {
                    permissionListener.onShowNotifyMessage();
                }
                this.requestPermissions(will, requestCode);
                return;
            }
        }
        permissionListener.onPermissionResult(true, requestCode);
    }

    private static List<String> filterPermission(String[] permission2) {
        ArrayList<String> inDangerousPermissions = new ArrayList<String>();
        ArrayList<String> dangerousPermissions = new ArrayList<String>();
        dangerousPermissions.add("android.permission.WRITE_CONTACTS");
        dangerousPermissions.add("android.permission.GET_ACCOUNTS");
        dangerousPermissions.add("android.permission.READ_CONTACTS");
        dangerousPermissions.add("android.permission.READ_CALL_LOG");
        dangerousPermissions.add("android.permission.READ_PHONE_STATE");
        dangerousPermissions.add("android.permission.READ_PHONE_STATE");
        dangerousPermissions.add("android.permission.CALL_PHONE");
        dangerousPermissions.add("android.permission.WRITE_CALL_LOG");
        dangerousPermissions.add("android.permission.USE_SIP");
        dangerousPermissions.add("android.permission.PROCESS_OUTGOING_CALLS");
        dangerousPermissions.add("com.android.voicemail.permission.ADD_VOICEMAIL");
        dangerousPermissions.add("android.permission.READ_CALENDAR");
        dangerousPermissions.add("android.permission.WRITE_CALENDAR");
        dangerousPermissions.add("android.permission.CAMERA");
        dangerousPermissions.add("android.permission.BODY_SENSORS");
        dangerousPermissions.add("android.permission.ACCESS_FINE_LOCATION");
        dangerousPermissions.add("android.permission.ACCESS_COARSE_LOCATION");
        dangerousPermissions.add("android.permission.READ_EXTERNAL_STORAGE");
        dangerousPermissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        dangerousPermissions.add("android.permission.RECORD_AUDIO");
        dangerousPermissions.add("android.permission.READ_SMS");
        dangerousPermissions.add("android.permission.RECEIVE_WAP_PUSH");
        dangerousPermissions.add("android.permission.RECEIVE_MMS");
        dangerousPermissions.add("android.permission.RECEIVE_SMS");
        dangerousPermissions.add("android.permission.SEND_SMS");
        for (String p : permission2) {
            if (!dangerousPermissions.contains(p)) continue;
            inDangerousPermissions.add(p);
        }
        return inDangerousPermissions;
    }
}

