package com.twolight.android.permission;

import android.app.Activity;
import android.app.FragmentManager;
import android.support.annotation.NonNull;

/**
 * Created by twolight on 17/4/18.
 */

public class PermissionUtil {
    private static final String TAG = "PermissionUtil";
    private PermissionFragment mRxPermissionsFragment;

    public static PermissionUtil with(Activity activity){
        return new PermissionUtil(activity);
    }

     PermissionUtil(@NonNull Activity activity) {
        mRxPermissionsFragment = getPermissionsFragment(activity);
    }

    private PermissionFragment getPermissionsFragment(Activity activity) {
        PermissionFragment permissionsFragment = findRxPermissionsFragment(activity);
        boolean isNewInstance = permissionsFragment == null;
        if (isNewInstance) {
            permissionsFragment = new PermissionFragment();
            FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager
                    .beginTransaction()
                    .add(permissionsFragment, TAG)
                    .commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return permissionsFragment;
    }

    private PermissionFragment findRxPermissionsFragment(Activity activity) {
        return (PermissionFragment) activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public void requestPermission(String[] permission, int requestCode, PermissionListener permissionListener){
        mRxPermissionsFragment.requestPermission(permission,requestCode,permissionListener);
    }
}
