/*
 * Decompiled with CFR 0.152.
 */
package com.twofortyfouram.assertion;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class Assertions {
    public static void assertInRangeInclusive(int actual, int minInclusive, int maxInclusive, @NonNull String name) {
        if (minInclusive > maxInclusive) {
            throw new IllegalArgumentException("maxInclusive is not >= minInclusive");
        }
        if (actual < minInclusive || actual > maxInclusive) {
            throw new AssertionError((Object)Assertions.formatMessage("%s=%d is not in the range [%d, %d]", name, actual, minInclusive, maxInclusive));
        }
    }

    public static void assertInRangeInclusive(long actual, long minInclusive, long maxInclusive, @NonNull String name) {
        if (minInclusive > maxInclusive) {
            throw new IllegalArgumentException("maxInclusive is not >= minInclusive");
        }
        if (actual < minInclusive || actual > maxInclusive) {
            throw new AssertionError((Object)Assertions.formatMessage("%s=%d is not in the range [%d, %d]", name, actual, minInclusive, maxInclusive));
        }
    }

    public static void assertInRangeInclusive(float actual, float minInclusive, float maxInclusive, @NonNull String name) {
        if (Float.compare(minInclusive, maxInclusive) > 0) {
            throw new IllegalArgumentException("maxInclusive is not >= minInclusive");
        }
        if (0 > Float.compare(actual, minInclusive) || 0 < Float.compare(actual, maxInclusive)) {
            throw new AssertionError((Object)Assertions.formatMessage("%s=%f is not in the range [%f, %f]", name, Float.valueOf(actual), Float.valueOf(minInclusive), Float.valueOf(maxInclusive)));
        }
    }

    public static void assertInRangeInclusive(double actual, double minInclusive, double maxInclusive, @NonNull String name) {
        if (Double.compare(minInclusive, maxInclusive) > 0) {
            throw new IllegalArgumentException("maxInclusive is not >= minInclusive");
        }
        if (0 > Double.compare(actual, minInclusive) || 0 < Double.compare(actual, maxInclusive)) {
            throw new AssertionError((Object)Assertions.formatMessage("%s=%f is not in the range [%f, %f]", name, actual, minInclusive, maxInclusive));
        }
    }

    public static void assertNoNullElements(@Nullable Object[] array, @Nullable String name) {
        Assertions.assertNotNull(array, name);
        for (Object o : array) {
            if (null == o) {
                throw new AssertionError((Object)Assertions.formatMessage("%s cannot contain null elements", name));
            }
        }
    }

    public static void assertNoNullElements(@Nullable Collection<?> collection, @Nullable String name) {
        Assertions.assertNotNull(collection, name);
        for (Object o : collection) {
            if (null == o) {
                throw new AssertionError((Object)Assertions.formatMessage("%s cannot contain null elements", name));
            }
        }
    }

    public static void assertNoNullElements(@Nullable Map<?, ?> map, @Nullable String name) {
        Assertions.assertNotNull(map, name);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (null == entry.getKey()) {
                throw new AssertionError((Object)Assertions.formatMessage("%s cannot contain null keys", name));
            }
            if (null == entry.getValue()) {
                throw new AssertionError((Object)Assertions.formatMessage("%s cannot contain null values", name));
            }
        }
    }

    public static void assertInSet(@Nullable Object obj, Object ... set) {
        Assertions.assertNotNull(set, "set");
        boolean isInSet = false;
        for (Object x : set) {
            if (null == x) {
                if (null != obj) continue;
                isInSet = true;
                break;
            }
            if (!x.equals(obj)) continue;
            isInSet = true;
            break;
        }
        if (!isInSet) {
            throw new AssertionError((Object)Assertions.formatMessage("%s is not in set %s", obj, set));
        }
    }

    public static void assertNotNull(@Nullable Object object, @NonNull String name) {
        if (null == object) {
            throw new AssertionError((Object)Assertions.formatMessage("%s cannot be null", name));
        }
    }

    public static void assertNotEmpty(@Nullable String string, @NonNull String name) {
        if (null == string || 0 == string.length()) {
            throw new AssertionError((Object)Assertions.formatMessage("%s cannot be null or empty", name));
        }
    }

    public static void assertNotEmpty(@Nullable Collection<?> collection, @NonNull String name) {
        Assertions.assertNotNull(collection, name);
        if (collection.isEmpty()) {
            throw new AssertionError((Object)Assertions.formatMessage("%s cannot be empty", name));
        }
    }

    public static void assertNotEmpty(@Nullable Map<?, ?> map, @NonNull String name) {
        Assertions.assertNotNull(map, name);
        if (map.isEmpty()) {
            throw new AssertionError((Object)Assertions.formatMessage("%s cannot be empty", name));
        }
    }

    public static void assertIsMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new AssertionError((Object)"Current thread is not the main thread");
        }
    }

    @NonNull
    private static String formatMessage(@NonNull String msg, Object ... args) {
        return String.format(Locale.US, msg, args);
    }

    private Assertions() {
        throw new UnsupportedOperationException("This class is non-instantiable");
    }
}

