/*
 * Decompiled with CFR 0.152.
 */
package com.twocoders.extensions.common;

import android.content.Context;
import android.util.Log;
import com.twocoders.extensions.common.ContextExtensionsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001\u001a\u001a\u0010\u000b\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"PATTERN_LOG_TO_FILE", "", "TAG", "", "getTAG", "(Ljava/lang/Object;)Ljava/lang/String;", "logToFile", "", "context", "Landroid/content/Context;", "message", "logd", "tr", "", "common_release"})
public final class LogExtensionsKt {
    private static final String PATTERN_LOG_TO_FILE = "yyyy-MM-dd HH:mm:ss.SSS";

    public static final void logd(@NotNull Object $this$logd, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$logd, (String)"$this$logd");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Log.d((String)$this$logd.getClass().getSimpleName(), (String)message);
    }

    public static final void logd(@NotNull Object $this$logd, @NotNull String message, @NotNull Throwable tr) {
        Intrinsics.checkNotNullParameter((Object)$this$logd, (String)"$this$logd");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tr, (String)"tr");
        Log.d((String)$this$logd.getClass().getSimpleName(), (String)message, (Throwable)tr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void logToFile(@NotNull Object $this$logToFile, @NotNull Context context, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$logToFile, (String)"$this$logToFile");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        File logFile = new File(ContextExtensionsKt.externalPrivateDir$default(context, null, 1, null), "log.txt");
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                LogExtensionsKt.logd($this$logToFile, "An error occurred while creating the log file :/");
            }
        }
        try {
            Closeable e = new BufferedWriter(new FileWriter(logFile, true));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)e;
                boolean bl3 = false;
                it.append(new SimpleDateFormat(PATTERN_LOG_TO_FILE, Locale.getDefault()).format(new Date(System.currentTimeMillis())) + ": " + message);
                it.newLine();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)e, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            LogExtensionsKt.logd($this$logToFile, "An error occurred while appending new line to the log file :/");
        }
    }

    @NotNull
    public static final String getTAG(@NotNull Object $this$TAG) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$TAG, (String)"$this$TAG");
        String tag = $this$TAG.getClass().getSimpleName();
        if (tag.length() <= 23) {
            String string2 = tag;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
        } else {
            String string3 = tag;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tag");
            String string4 = string3;
            int n = 0;
            int n2 = 23;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, n2);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }
}

