/*
 * Decompiled with CFR 0.152.
 */
package com.twocoders.extensions.common;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.DownloadManager;
import android.app.KeyguardManager;
import android.app.NotificationManager;
import android.app.SearchManager;
import android.app.UiModeManager;
import android.app.usage.NetworkStatsManager;
import android.content.ActivityNotFoundException;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.hardware.SensorManager;
import android.hardware.camera2.CameraManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.BatteryManager;
import android.os.HardwarePropertiesManager;
import android.os.PowerManager;
import android.os.Vibrator;
import android.os.storage.StorageManager;
import android.telephony.TelephonyManager;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.twocoders.extensions.common.CommonExtensionsKt;
import com.twocoders.extensions.common.LogExtensionsKt;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u00c2\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\n\u0010e\u001a\u00020f*\u00020\u0002\u001a\u0012\u0010g\u001a\u00020h*\u00020\u00022\u0006\u0010i\u001a\u00020f\u001a)\u0010j\u001a\u000e\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u00020h0k*\u00020\u00022\f\u0010l\u001a\b\u0012\u0004\u0012\u00020f0m\u00a2\u0006\u0002\u0010n\u001a\f\u0010o\u001a\u0004\u0018\u00010p*\u00020\u0002\u001a5\u0010q\u001a(\u0012\f\u0012\n r*\u0004\u0018\u00010p0p r*\u0014\u0012\u000e\b\u0001\u0012\n r*\u0004\u0018\u00010p0p\u0018\u00010m0m*\u00020\u0002\u00a2\u0006\u0002\u0010s\u001a\u0018\u0010t\u001a\u0004\u0018\u00010p*\u00020\u00022\n\b\u0002\u0010u\u001a\u0004\u0018\u00010f\u001aA\u0010v\u001a(\u0012\f\u0012\n r*\u0004\u0018\u00010p0p r*\u0014\u0012\u000e\b\u0001\u0012\n r*\u0004\u0018\u00010p0p\u0018\u00010m0m*\u00020\u00022\n\b\u0002\u0010u\u001a\u0004\u0018\u00010f\u00a2\u0006\u0002\u0010w\u001a\u0016\u0010x\u001a\u0004\u0018\u00010y*\u00020\u00022\b\b\u0001\u0010z\u001a\u00020\u001e\u001a\u001e\u0010{\u001a\u00020|*\u00020\u00022\b\b\u0001\u0010z\u001a\u00020\u001e2\b\b\u0003\u0010}\u001a\u00020\u001e\u001a-\u0010~\u001a\u00020\u001e*\u00020\u00022\b\b\u0001\u0010\u007f\u001a\u00020\u001e2\n\b\u0002\u0010\u0080\u0001\u001a\u00030\u0081\u00012\t\b\u0002\u0010\u0082\u0001\u001a\u00020hH\u0007\u001a)\u0010\u0083\u0001\u001a\u00020\u001e*\u00020\u00022\t\b\u0001\u0010\u0084\u0001\u001a\u00020\u001e2\u000f\b\u0002\u0010\u0085\u0001\u001a\b0\u0086\u0001R\u00030\u0087\u0001H\u0007\u001a*\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u0001*\u00020\u00022\t\b\u0001\u0010\u0084\u0001\u001a\u00020\u001e2\u000f\b\u0002\u0010\u0085\u0001\u001a\b0\u0086\u0001R\u00030\u0087\u0001\u001a+\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001*\u00020\u00022\b\b\u0001\u0010z\u001a\u00020\u001e2\u000f\b\u0002\u0010\u0085\u0001\u001a\b0\u0086\u0001R\u00030\u0087\u0001H\u0007\u001a,\u0010\u008c\u0001\u001a\u00020f*\u00020\u00022\b\b\u0001\u0010\u007f\u001a\u00020\u001e2\n\b\u0002\u0010\u0080\u0001\u001a\u00030\u0081\u00012\t\b\u0002\u0010\u0082\u0001\u001a\u00020h\u001a\u0014\u0010\u008d\u0001\u001a\u00020h*\u00020\u00022\u0007\u0010\u008e\u0001\u001a\u00020f\u001a\u001d\u0010\u008f\u0001\u001a\u0004\u0018\u00010h*\u00020\u00022\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001\u00a2\u0006\u0003\u0010\u0092\u0001\u001a\u0013\u0010\u0093\u0001\u001a\n r*\u0004\u0018\u00010p0p*\u00020\u0002\u001a\u0013\u0010\u0094\u0001\u001a\n r*\u0004\u0018\u00010p0p*\u00020\u0002\u001a\u000b\u0010\u0095\u0001\u001a\u00020h*\u00020\u0002\u001a\u000b\u0010\u0096\u0001\u001a\u00020h*\u00020\u0002\u001a\u000b\u0010\u0097\u0001\u001a\u00020h*\u00020\u0002\u001a\u000b\u0010\u0098\u0001\u001a\u00020h*\u00020\u0002\u001a\u000e\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u009a\u0001*\u00020\u0002\u001a\u001d\u0010\u009b\u0001\u001a\u0004\u0018\u00010h*\u00020\u00022\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001\u00a2\u0006\u0003\u0010\u0092\u0001\u001a!\u0010\u009c\u0001\u001a\u00030\u009d\u0001*\u00020\u00022\t\b\u0002\u0010\u009e\u0001\u001a\u00020f2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001\u001a\f\u0010\u00a1\u0001\u001a\u00030\u009d\u0001*\u00020\u0002\u001a\u0016\u0010\u00a2\u0001\u001a\u00030\u009d\u0001*\u00020\u00022\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001\u001a*\u0010\u00a3\u0001\u001a\u00030\u009d\u0001*\u00020\u00022\t\b\u0002\u0010\u00a4\u0001\u001a\u00020f2\u000b\b\u0002\u0010\u00a5\u0001\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0003\u0010\u00a6\u0001\u001a\f\u0010\u00a7\u0001\u001a\u00030\u009d\u0001*\u00020\u0002\u001a\u0014\u0010\u00a8\u0001\u001a\u0005\u0018\u00010\u009d\u0001*\u00020\u0002\u00a2\u0006\u0003\u0010\u00a9\u0001\"\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0015\u0010\u001d\u001a\u00020\u001e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0018\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0018\u0010%\u001a\u0004\u0018\u00010&*\u00020\u00028\u00c7\u0002\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0018\u0010)\u001a\u0004\u0018\u00010**\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\"\u0018\u0010-\u001a\u0004\u0018\u00010.*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0015\u00101\u001a\u000202*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\"\u0018\u00105\u001a\u0004\u0018\u000106*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u0018\u00109\u001a\u0004\u0018\u00010:*\u00020\u00028\u00c7\u0002\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\"\u0018\u0010=\u001a\u0004\u0018\u00010>*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\"\u0018\u0010A\u001a\u0004\u0018\u00010B*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\"\u0018\u0010E\u001a\u0004\u0018\u00010F*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\"\u0018\u0010I\u001a\u0004\u0018\u00010J*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\"\u0018\u0010M\u001a\u0004\u0018\u00010N*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\"\u0018\u0010Q\u001a\u0004\u0018\u00010R*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bS\u0010T\"\u0018\u0010U\u001a\u0004\u0018\u00010V*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\"\u0018\u0010Y\u001a\u0004\u0018\u00010Z*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\\"\u0018\u0010]\u001a\u0004\u0018\u00010^*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b_\u0010`\"\u0018\u0010a\u001a\u0004\u0018\u00010b*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\bc\u0010d\u00a8\u0006\u00aa\u0001"}, d2={"activityManager", "Landroid/app/ActivityManager;", "Landroid/content/Context;", "getActivityManager", "(Landroid/content/Context;)Landroid/app/ActivityManager;", "alarmManager", "Landroid/app/AlarmManager;", "getAlarmManager", "(Landroid/content/Context;)Landroid/app/AlarmManager;", "audioManager", "Landroid/media/AudioManager;", "getAudioManager", "(Landroid/content/Context;)Landroid/media/AudioManager;", "batteryManager", "Landroid/os/BatteryManager;", "getBatteryManager", "(Landroid/content/Context;)Landroid/os/BatteryManager;", "camera2Manager", "Landroid/hardware/camera2/CameraManager;", "getCamera2Manager", "(Landroid/content/Context;)Landroid/hardware/camera2/CameraManager;", "clipboardManager", "Landroid/content/ClipboardManager;", "getClipboardManager", "(Landroid/content/Context;)Landroid/content/ClipboardManager;", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectivityManager", "(Landroid/content/Context;)Landroid/net/ConnectivityManager;", "displayRotation", "", "getDisplayRotation", "(Landroid/content/Context;)I", "downloadManager", "Landroid/app/DownloadManager;", "getDownloadManager", "(Landroid/content/Context;)Landroid/app/DownloadManager;", "hardwarePropertiesManager", "Landroid/os/HardwarePropertiesManager;", "getHardwarePropertiesManager", "(Landroid/content/Context;)Landroid/os/HardwarePropertiesManager;", "inputMethodManager", "Landroid/view/inputmethod/InputMethodManager;", "getInputMethodManager", "(Landroid/content/Context;)Landroid/view/inputmethod/InputMethodManager;", "keyguardManager", "Landroid/app/KeyguardManager;", "getKeyguardManager", "(Landroid/content/Context;)Landroid/app/KeyguardManager;", "layoutInflater", "Landroid/view/LayoutInflater;", "getLayoutInflater", "(Landroid/content/Context;)Landroid/view/LayoutInflater;", "locationManager", "Landroid/location/LocationManager;", "getLocationManager", "(Landroid/content/Context;)Landroid/location/LocationManager;", "networkStatsManager", "Landroid/app/usage/NetworkStatsManager;", "getNetworkStatsManager", "(Landroid/content/Context;)Landroid/app/usage/NetworkStatsManager;", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "(Landroid/content/Context;)Landroid/app/NotificationManager;", "powerManager", "Landroid/os/PowerManager;", "getPowerManager", "(Landroid/content/Context;)Landroid/os/PowerManager;", "searchManager", "Landroid/app/SearchManager;", "getSearchManager", "(Landroid/content/Context;)Landroid/app/SearchManager;", "sensorManager", "Landroid/hardware/SensorManager;", "getSensorManager", "(Landroid/content/Context;)Landroid/hardware/SensorManager;", "storageManager", "Landroid/os/storage/StorageManager;", "getStorageManager", "(Landroid/content/Context;)Landroid/os/storage/StorageManager;", "telephonyManager", "Landroid/telephony/TelephonyManager;", "getTelephonyManager", "(Landroid/content/Context;)Landroid/telephony/TelephonyManager;", "uiModeManager", "Landroid/app/UiModeManager;", "getUiModeManager", "(Landroid/content/Context;)Landroid/app/UiModeManager;", "vibratorManager", "Landroid/os/Vibrator;", "getVibratorManager", "(Landroid/content/Context;)Landroid/os/Vibrator;", "wifiManager", "Landroid/net/wifi/WifiManager;", "getWifiManager", "(Landroid/content/Context;)Landroid/net/wifi/WifiManager;", "windowManager", "Landroid/view/WindowManager;", "getWindowManager", "(Landroid/content/Context;)Landroid/view/WindowManager;", "applicationName", "", "checkPermission", "", "permission", "checkPermissions", "", "permissions", "", "(Landroid/content/Context;[Ljava/lang/String;)Ljava/util/Map;", "externalPrivateCacheDir", "Ljava/io/File;", "externalPrivateCacheDirs", "kotlin.jvm.PlatformType", "(Landroid/content/Context;)[Ljava/io/File;", "externalPrivateDir", "subDir", "externalPrivateDirs", "(Landroid/content/Context;Ljava/lang/String;)[Ljava/io/File;", "getAnimationDrawable", "Landroid/graphics/drawable/AnimationDrawable;", "drawableResId", "getBitmapFromDrawable", "Landroid/graphics/Bitmap;", "tintColor", "getColorFromAttr", "resId", "typedValue", "Landroid/util/TypedValue;", "resolveRefs", "getColorInt", "colorResId", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "getColorStateList", "Landroid/content/res/ColorStateList;", "getDrawable", "Landroid/graphics/drawable/Drawable;", "getStringFromAttr", "hasPermissionInManifest", "permissionName", "hideKeyboard", "view", "Landroid/view/View;", "(Landroid/content/Context;Landroid/view/View;)Ljava/lang/Boolean;", "internalPrivateCacheDir", "internalPrivateDir", "isNetworkAvailable", "isNetworkUnavailable", "isNightModeEnabled", "isRtl", "scanForActivity", "Landroid/app/Activity;", "showKeyboard", "startActivity", "", "intentAction", "uri", "Landroid/net/Uri;", "startApplicationDetailsSettingsActivity", "startDialActivity", "startGooglePlayActivity", "appPackageName", "flags", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Integer;)V", "startLocationSettingsActivity", "toggleKeyboard", "(Landroid/content/Context;)Lkotlin/Unit;", "common_release"})
public final class ContextExtensionsKt {
    @Nullable
    public static final AudioManager getAudioManager(@NotNull Context $this$audioManager) {
        int $i$f$getAudioManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$audioManager, (String)"$this$audioManager");
        Object object = $this$audioManager.getApplicationContext().getSystemService("audio");
        if (!(object instanceof AudioManager)) {
            object = null;
        }
        return (AudioManager)object;
    }

    @Nullable
    public static final LocationManager getLocationManager(@NotNull Context $this$locationManager) {
        int $i$f$getLocationManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$locationManager, (String)"$this$locationManager");
        Object object = $this$locationManager.getApplicationContext().getSystemService("location");
        if (!(object instanceof LocationManager)) {
            object = null;
        }
        return (LocationManager)object;
    }

    @Nullable
    public static final ClipboardManager getClipboardManager(@NotNull Context $this$clipboardManager) {
        int $i$f$getClipboardManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$clipboardManager, (String)"$this$clipboardManager");
        Object object = $this$clipboardManager.getApplicationContext().getSystemService("clipboard");
        if (!(object instanceof ClipboardManager)) {
            object = null;
        }
        return (ClipboardManager)object;
    }

    @Nullable
    public static final InputMethodManager getInputMethodManager(@NotNull Context $this$inputMethodManager) {
        int $i$f$getInputMethodManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$inputMethodManager, (String)"$this$inputMethodManager");
        Object object = $this$inputMethodManager.getApplicationContext().getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        return (InputMethodManager)object;
    }

    @Nullable
    public static final NotificationManager getNotificationManager(@NotNull Context $this$notificationManager) {
        int $i$f$getNotificationManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$notificationManager, (String)"$this$notificationManager");
        Object object = $this$notificationManager.getApplicationContext().getSystemService("notification");
        if (!(object instanceof NotificationManager)) {
            object = null;
        }
        return (NotificationManager)object;
    }

    @Nullable
    public static final ConnectivityManager getConnectivityManager(@NotNull Context $this$connectivityManager) {
        int $i$f$getConnectivityManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$connectivityManager, (String)"$this$connectivityManager");
        Object object = $this$connectivityManager.getApplicationContext().getSystemService("connectivity");
        if (!(object instanceof ConnectivityManager)) {
            object = null;
        }
        return (ConnectivityManager)object;
    }

    @RequiresApi(api=23)
    @Nullable
    public static final NetworkStatsManager getNetworkStatsManager(@NotNull Context $this$networkStatsManager) {
        int $i$f$getNetworkStatsManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$networkStatsManager, (String)"$this$networkStatsManager");
        Object object = $this$networkStatsManager.getApplicationContext().getSystemService("netstats");
        if (!(object instanceof NetworkStatsManager)) {
            object = null;
        }
        return (NetworkStatsManager)object;
    }

    @Nullable
    public static final WifiManager getWifiManager(@NotNull Context $this$wifiManager) {
        int $i$f$getWifiManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$wifiManager, (String)"$this$wifiManager");
        Object object = $this$wifiManager.getApplicationContext().getSystemService("wifi");
        if (!(object instanceof WifiManager)) {
            object = null;
        }
        return (WifiManager)object;
    }

    @Nullable
    public static final WindowManager getWindowManager(@NotNull Context $this$windowManager) {
        int $i$f$getWindowManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$windowManager, (String)"$this$windowManager");
        Object object = $this$windowManager.getApplicationContext().getSystemService("window");
        if (!(object instanceof WindowManager)) {
            object = null;
        }
        return (WindowManager)object;
    }

    @Nullable
    public static final ActivityManager getActivityManager(@NotNull Context $this$activityManager) {
        int $i$f$getActivityManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$activityManager, (String)"$this$activityManager");
        Object object = $this$activityManager.getApplicationContext().getSystemService("activity");
        if (!(object instanceof ActivityManager)) {
            object = null;
        }
        return (ActivityManager)object;
    }

    @Nullable
    public static final CameraManager getCamera2Manager(@NotNull Context $this$camera2Manager) {
        int $i$f$getCamera2Manager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$camera2Manager, (String)"$this$camera2Manager");
        Object object = $this$camera2Manager.getApplicationContext().getSystemService("camera");
        if (!(object instanceof CameraManager)) {
            object = null;
        }
        return (CameraManager)object;
    }

    @Nullable
    public static final SensorManager getSensorManager(@NotNull Context $this$sensorManager) {
        int $i$f$getSensorManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$sensorManager, (String)"$this$sensorManager");
        Object object = $this$sensorManager.getApplicationContext().getSystemService("sensor");
        if (!(object instanceof SensorManager)) {
            object = null;
        }
        return (SensorManager)object;
    }

    @Nullable
    public static final PowerManager getPowerManager(@NotNull Context $this$powerManager) {
        int $i$f$getPowerManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$powerManager, (String)"$this$powerManager");
        Object object = $this$powerManager.getApplicationContext().getSystemService("power");
        if (!(object instanceof PowerManager)) {
            object = null;
        }
        return (PowerManager)object;
    }

    @Nullable
    public static final AlarmManager getAlarmManager(@NotNull Context $this$alarmManager) {
        int $i$f$getAlarmManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$alarmManager, (String)"$this$alarmManager");
        Object object = $this$alarmManager.getApplicationContext().getSystemService("alarm");
        if (!(object instanceof AlarmManager)) {
            object = null;
        }
        return (AlarmManager)object;
    }

    @Nullable
    public static final KeyguardManager getKeyguardManager(@NotNull Context $this$keyguardManager) {
        int $i$f$getKeyguardManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$keyguardManager, (String)"$this$keyguardManager");
        Object object = $this$keyguardManager.getApplicationContext().getSystemService("keyguard");
        if (!(object instanceof KeyguardManager)) {
            object = null;
        }
        return (KeyguardManager)object;
    }

    @Nullable
    public static final SearchManager getSearchManager(@NotNull Context $this$searchManager) {
        int $i$f$getSearchManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$searchManager, (String)"$this$searchManager");
        Object object = $this$searchManager.getApplicationContext().getSystemService("search");
        if (!(object instanceof SearchManager)) {
            object = null;
        }
        return (SearchManager)object;
    }

    @Nullable
    public static final StorageManager getStorageManager(@NotNull Context $this$storageManager) {
        int $i$f$getStorageManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$storageManager, (String)"$this$storageManager");
        Object object = $this$storageManager.getApplicationContext().getSystemService("storage");
        if (!(object instanceof StorageManager)) {
            object = null;
        }
        return (StorageManager)object;
    }

    @Nullable
    public static final Vibrator getVibratorManager(@NotNull Context $this$vibratorManager) {
        int $i$f$getVibratorManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$vibratorManager, (String)"$this$vibratorManager");
        Object object = $this$vibratorManager.getApplicationContext().getSystemService("vibrator");
        if (!(object instanceof Vibrator)) {
            object = null;
        }
        return (Vibrator)object;
    }

    @Nullable
    public static final TelephonyManager getTelephonyManager(@NotNull Context $this$telephonyManager) {
        int $i$f$getTelephonyManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$telephonyManager, (String)"$this$telephonyManager");
        Object object = $this$telephonyManager.getApplicationContext().getSystemService("phone");
        if (!(object instanceof TelephonyManager)) {
            object = null;
        }
        return (TelephonyManager)object;
    }

    @Nullable
    public static final UiModeManager getUiModeManager(@NotNull Context $this$uiModeManager) {
        int $i$f$getUiModeManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$uiModeManager, (String)"$this$uiModeManager");
        Object object = $this$uiModeManager.getApplicationContext().getSystemService("uimode");
        if (!(object instanceof UiModeManager)) {
            object = null;
        }
        return (UiModeManager)object;
    }

    @Nullable
    public static final DownloadManager getDownloadManager(@NotNull Context $this$downloadManager) {
        int $i$f$getDownloadManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$downloadManager, (String)"$this$downloadManager");
        Object object = $this$downloadManager.getApplicationContext().getSystemService("download");
        if (!(object instanceof DownloadManager)) {
            object = null;
        }
        return (DownloadManager)object;
    }

    @Nullable
    public static final BatteryManager getBatteryManager(@NotNull Context $this$batteryManager) {
        int $i$f$getBatteryManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$batteryManager, (String)"$this$batteryManager");
        Object object = $this$batteryManager.getApplicationContext().getSystemService("batterymanager");
        if (!(object instanceof BatteryManager)) {
            object = null;
        }
        return (BatteryManager)object;
    }

    @RequiresApi(api=24)
    @Nullable
    public static final HardwarePropertiesManager getHardwarePropertiesManager(@NotNull Context $this$hardwarePropertiesManager) {
        int $i$f$getHardwarePropertiesManager = 0;
        Intrinsics.checkNotNullParameter((Object)$this$hardwarePropertiesManager, (String)"$this$hardwarePropertiesManager");
        Object object = $this$hardwarePropertiesManager.getApplicationContext().getSystemService("hardware_properties");
        if (!(object instanceof HardwarePropertiesManager)) {
            object = null;
        }
        return (HardwarePropertiesManager)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNetworkAvailable(@NotNull Context $this$isNetworkAvailable) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNetworkAvailable, (String)"$this$isNetworkAvailable");
        Context $this$connectivityManager$iv = $this$isNetworkAvailable;
        boolean $i$f$getConnectivityManager = false;
        Object object = $this$connectivityManager$iv.getApplicationContext().getSystemService("connectivity");
        if (!(object instanceof ConnectivityManager)) {
            object = null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        Object object2 = connectivityManager;
        if (connectivityManager == null) return false;
        ConnectivityManager connectivityManager2 = object2;
        boolean bl2 = false;
        boolean bl3 = false;
        ConnectivityManager it = connectivityManager2;
        boolean bl4 = false;
        if (CommonExtensionsKt.isAtLeastMarshmallow()) {
            NetworkCapabilities networkCapabilities = it.getNetworkCapabilities(it.getActiveNetwork());
            if (networkCapabilities == null) return false;
            bl = networkCapabilities.hasCapability(12);
        } else {
            NetworkInfo networkInfo = it.getActiveNetworkInfo();
            if (networkInfo == null) return false;
            bl = networkInfo.isConnected();
        }
        object2 = bl;
        if (bl == null) return false;
        boolean bl5 = (Boolean)object2;
        return bl5;
    }

    public static final boolean isNetworkUnavailable(@NotNull Context $this$isNetworkUnavailable) {
        Intrinsics.checkNotNullParameter((Object)$this$isNetworkUnavailable, (String)"$this$isNetworkUnavailable");
        return !ContextExtensionsKt.isNetworkAvailable($this$isNetworkUnavailable);
    }

    @Nullable
    public static final Activity scanForActivity(@NotNull Context $this$scanForActivity) {
        Activity activity;
        Intrinsics.checkNotNullParameter((Object)$this$scanForActivity, (String)"$this$scanForActivity");
        Context context = $this$scanForActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$scanForActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$scanForActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"baseContext");
            activity = ContextExtensionsKt.scanForActivity(context2);
        } else {
            activity = null;
        }
        return activity;
    }

    @Nullable
    public static final AnimationDrawable getAnimationDrawable(@NotNull Context $this$getAnimationDrawable, @DrawableRes int drawableResId) {
        AnimationDrawable animationDrawable;
        Intrinsics.checkNotNullParameter((Object)$this$getAnimationDrawable, (String)"$this$getAnimationDrawable");
        try {
            Drawable drawable = ContextExtensionsKt.getDrawable$default($this$getAnimationDrawable, drawableResId, null, 2, null);
            if (!(drawable instanceof AnimationDrawable)) {
                drawable = null;
            }
            animationDrawable = (AnimationDrawable)drawable;
        }
        catch (OutOfMemoryError oom) {
            LogExtensionsKt.logd($this$getAnimationDrawable, "Failed to load the AnimationDrawable:", oom);
            animationDrawable = null;
        }
        return animationDrawable;
    }

    @NotNull
    public static final Bitmap getBitmapFromDrawable(@NotNull Context $this$getBitmapFromDrawable, @DrawableRes int drawableResId, @ColorRes int tintColor) {
        Bitmap bitmap;
        Drawable drawable;
        Intrinsics.checkNotNullParameter((Object)$this$getBitmapFromDrawable, (String)"$this$getBitmapFromDrawable");
        Drawable drawable2 = ContextExtensionsKt.getDrawable$default($this$getBitmapFromDrawable, drawableResId, null, 2, null);
        if (drawable2 == null) {
            throw (Throwable)new Resources.NotFoundException("The given resource Id does not exist :/");
        }
        Drawable drawable3 = drawable = drawable2;
        if (drawable3 instanceof BitmapDrawable) {
            Bitmap bitmap2 = ((BitmapDrawable)drawable).getBitmap();
            bitmap = bitmap2;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"drawable.bitmap");
        } else if (drawable3 instanceof VectorDrawable) {
            Bitmap bitmap3 = Bitmap.createBitmap((int)((VectorDrawable)drawable).getIntrinsicWidth(), (int)((VectorDrawable)drawable).getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            boolean bl = false;
            boolean bl2 = false;
            Bitmap $this$apply = bitmap3;
            boolean bl3 = false;
            Canvas canvas = new Canvas($this$apply);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            if (tintColor != 0) {
                drawable.setTint(ContextExtensionsKt.getColorInt$default($this$getBitmapFromDrawable, tintColor, null, 2, null));
            }
            drawable.draw(canvas);
            Bitmap bitmap4 = bitmap3;
            bitmap = bitmap4;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"Bitmap.createBitmap(draw\u2026raw(canvas)\n            }");
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported drawable type...");
        }
        return bitmap;
    }

    public static /* synthetic */ Bitmap getBitmapFromDrawable$default(Context context, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return ContextExtensionsKt.getBitmapFromDrawable(context, n, n2);
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    @Nullable
    public static final Drawable getDrawable(@NotNull Context $this$getDrawable, @DrawableRes int drawableResId, @NotNull Resources.Theme theme) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawable, (String)"$this$getDrawable");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        return $this$getDrawable.getResources().getDrawable(drawableResId, theme);
    }

    public static /* synthetic */ Drawable getDrawable$default(Context context, int n, Resources.Theme theme, int n2, Object object) {
        if ((n2 & 2) != 0) {
            Resources.Theme theme2 = context.getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)theme2, (String)"getTheme()");
            theme = theme2;
        }
        return ContextExtensionsKt.getDrawable(context, n, theme);
    }

    @ColorInt
    public static final int getColorInt(@NotNull Context $this$getColorInt, @ColorRes int colorResId, @NotNull Resources.Theme theme) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorInt, (String)"$this$getColorInt");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        return CommonExtensionsKt.isAtLeastMarshmallow() ? $this$getColorInt.getResources().getColor(colorResId, theme) : ContextCompat.getColor((Context)$this$getColorInt, (int)colorResId);
    }

    public static /* synthetic */ int getColorInt$default(Context context, int n, Resources.Theme theme, int n2, Object object) {
        if ((n2 & 2) != 0) {
            Resources.Theme theme2 = context.getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)theme2, (String)"getTheme()");
            theme = theme2;
        }
        return ContextExtensionsKt.getColorInt(context, n, theme);
    }

    @Nullable
    public static final ColorStateList getColorStateList(@NotNull Context $this$getColorStateList, @ColorRes int colorResId, @NotNull Resources.Theme theme) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorStateList, (String)"$this$getColorStateList");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        return CommonExtensionsKt.isAtLeastMarshmallow() ? $this$getColorStateList.getResources().getColorStateList(colorResId, theme) : ContextCompat.getColorStateList((Context)$this$getColorStateList, (int)colorResId);
    }

    public static /* synthetic */ ColorStateList getColorStateList$default(Context context, int n, Resources.Theme theme, int n2, Object object) {
        if ((n2 & 2) != 0) {
            Resources.Theme theme2 = context.getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)theme2, (String)"getTheme()");
            theme = theme2;
        }
        return ContextExtensionsKt.getColorStateList(context, n, theme);
    }

    @ColorInt
    public static final int getColorFromAttr(@NotNull Context $this$getColorFromAttr, @AttrRes int resId, @NotNull TypedValue typedValue, boolean resolveRefs) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorFromAttr, (String)"$this$getColorFromAttr");
        Intrinsics.checkNotNullParameter((Object)typedValue, (String)"typedValue");
        TypedValue typedValue2 = typedValue;
        boolean bl = false;
        boolean bl2 = false;
        TypedValue it = typedValue2;
        boolean bl3 = false;
        $this$getColorFromAttr.getTheme().resolveAttribute(resId, it, resolveRefs);
        return it.data;
    }

    public static /* synthetic */ int getColorFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtensionsKt.getColorFromAttr(context, n, typedValue, bl);
    }

    @NotNull
    public static final String getStringFromAttr(@NotNull Context $this$getStringFromAttr, @AttrRes int resId, @NotNull TypedValue typedValue, boolean resolveRefs) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringFromAttr, (String)"$this$getStringFromAttr");
        Intrinsics.checkNotNullParameter((Object)typedValue, (String)"typedValue");
        TypedValue typedValue2 = typedValue;
        boolean bl = false;
        boolean bl2 = false;
        TypedValue it = typedValue2;
        boolean bl3 = false;
        $this$getStringFromAttr.getTheme().resolveAttribute(resId, it, resolveRefs);
        if (it.type == 3 && it.string != null) {
            return ((Object)it.string).toString();
        }
        return "";
    }

    public static /* synthetic */ String getStringFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtensionsKt.getStringFromAttr(context, n, typedValue, bl);
    }

    public static final void startActivity(@NotNull Context $this$startActivity, @NotNull String intentAction, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)$this$startActivity, (String)"$this$startActivity");
        Intrinsics.checkNotNullParameter((Object)intentAction, (String)"intentAction");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        $this$startActivity.startActivity(new Intent(intentAction, uri));
    }

    public static /* synthetic */ void startActivity$default(Context context, String string, Uri uri, int n, Object object) {
        if ((n & 1) != 0) {
            string = "android.intent.action.VIEW";
        }
        ContextExtensionsKt.startActivity(context, string, uri);
    }

    /*
     * WARNING - void declaration
     */
    public static final void startGooglePlayActivity(@NotNull Context $this$startGooglePlayActivity, @NotNull String appPackageName, @Nullable Integer flags) {
        Intrinsics.checkNotNullParameter((Object)$this$startGooglePlayActivity, (String)"$this$startGooglePlayActivity");
        Intrinsics.checkNotNullParameter((Object)appPackageName, (String)"appPackageName");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName)));
            boolean bl = false;
            boolean bl2 = false;
            Intent intent2 = intent;
            Context context = $this$startGooglePlayActivity;
            boolean bl3 = false;
            Integer n = flags;
            if (n != null) {
                void $this$apply;
                Integer n2 = n;
                boolean bl4 = false;
                boolean bl5 = false;
                int it = ((Number)n2).intValue();
                boolean bl6 = false;
                $this$apply.addFlags(it);
            }
            Unit unit = Unit.INSTANCE;
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + appPackageName)));
            boolean bl = false;
            boolean bl7 = false;
            Intent bl3 = intent;
            Context context = $this$startGooglePlayActivity;
            boolean bl8 = false;
            Integer n = flags;
            if (n != null) {
                void $this$apply;
                Integer n3 = n;
                boolean bl9 = false;
                boolean bl10 = false;
                int it = ((Number)n3).intValue();
                boolean bl11 = false;
                $this$apply.addFlags(it);
            }
            Unit unit = Unit.INSTANCE;
            context.startActivity(intent);
        }
    }

    public static /* synthetic */ void startGooglePlayActivity$default(Context context, String string, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            String string2 = context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageName");
            string = string2;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        ContextExtensionsKt.startGooglePlayActivity(context, string, n);
    }

    public static final void startDialActivity(@NotNull Context $this$startDialActivity, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)$this$startDialActivity, (String)"$this$startDialActivity");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        ContextExtensionsKt.startActivity($this$startDialActivity, "android.intent.action.DIAL", uri);
    }

    /*
     * WARNING - void declaration
     */
    public static final void startApplicationDetailsSettingsActivity(@NotNull Context $this$startApplicationDetailsSettingsActivity) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)$this$startApplicationDetailsSettingsActivity, (String)"$this$startApplicationDetailsSettingsActivity");
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        boolean bl = false;
        boolean bl2 = false;
        Intent intent2 = intent;
        Context context = $this$startApplicationDetailsSettingsActivity;
        boolean bl3 = false;
        $this$apply.setData(Uri.fromParts((String)"package", (String)$this$startApplicationDetailsSettingsActivity.getPackageName(), null));
        $this$apply.addCategory("android.intent.category.DEFAULT");
        $this$apply.addFlags(0x10000000);
        Unit unit = Unit.INSTANCE;
        context.startActivity(intent);
    }

    /*
     * WARNING - void declaration
     */
    public static final void startLocationSettingsActivity(@NotNull Context $this$startLocationSettingsActivity) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)$this$startLocationSettingsActivity, (String)"$this$startLocationSettingsActivity");
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        boolean bl = false;
        boolean bl2 = false;
        Intent intent2 = intent;
        Context context = $this$startLocationSettingsActivity;
        boolean bl3 = false;
        $this$apply.addCategory("android.intent.category.DEFAULT");
        $this$apply.addFlags(0x10000000);
        Unit unit = Unit.INSTANCE;
        context.startActivity(intent);
    }

    public static final boolean isRtl(@NotNull Context $this$isRtl) {
        Intrinsics.checkNotNullParameter((Object)$this$isRtl, (String)"$this$isRtl");
        Resources resources = $this$isRtl.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"this.resources");
        Configuration configuration = resources.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"this.resources.configuration");
        return configuration.getLayoutDirection() == 1;
    }

    public static final boolean isNightModeEnabled(@NotNull Context $this$isNightModeEnabled) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNightModeEnabled, (String)"$this$isNightModeEnabled");
        Resources resources = $this$isNightModeEnabled.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        switch (resources.getConfiguration().uiMode & 0x30) {
            case 32: {
                bl = true;
                break;
            }
            case 0: 
            case 16: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final int getDisplayRotation(@NotNull Context $this$displayRotation) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$displayRotation, (String)"$this$displayRotation");
        if (CommonExtensionsKt.isAtLeastR()) {
            object = $this$displayRotation.getDisplay();
        } else {
            Context $this$windowManager$iv = $this$displayRotation;
            boolean $i$f$getWindowManager = false;
            Object object2 = $this$windowManager$iv.getApplicationContext().getSystemService("window");
            if (!(object2 instanceof WindowManager)) {
                object2 = null;
            }
            WindowManager windowManager = (WindowManager)object2;
            object = windowManager != null ? windowManager.getDefaultDisplay() : null;
        }
        return object != null ? object.getRotation() : 0;
    }

    @NotNull
    public static final LayoutInflater getLayoutInflater(@NotNull Context $this$layoutInflater) {
        Intrinsics.checkNotNullParameter((Object)$this$layoutInflater, (String)"$this$layoutInflater");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$layoutInflater);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"LayoutInflater.from(this)");
        return layoutInflater;
    }

    public static final boolean checkPermission(@NotNull Context $this$checkPermission, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)$this$checkPermission, (String)"$this$checkPermission");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)$this$checkPermission, (String)permission) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Boolean> checkPermissions(@NotNull Context $this$checkPermissions, @NotNull String[] permissions) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$checkPermissions, (String)"$this$checkPermissions");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        String[] $this$associateBy$iv = permissions;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        String[] stringArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        void var8_8 = $this$associateByTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var12_12 = element$iv$iv = var8_8[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            void var15_15 = it;
            it = element$iv$iv;
            boolean bl2 = false;
            Boolean bl3 = ContextExtensionsKt.checkPermission($this$checkPermissions, (String)it);
            map.put(var15_15, bl3);
        }
        return destination$iv$iv;
    }

    public static final boolean hasPermissionInManifest(@NotNull Context $this$hasPermissionInManifest, @NotNull String permissionName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasPermissionInManifest, (String)"$this$hasPermissionInManifest");
        Intrinsics.checkNotNullParameter((Object)permissionName, (String)"permissionName");
        try {
            boolean bl2;
            if ($this$hasPermissionInManifest.getPackageManager().getPackageInfo((String)$this$hasPermissionInManifest.getPackageName(), (int)4096).requestedPermissions != null) {
                bl2 = ArraysKt.contains((Object[])$this$hasPermissionInManifest.getPackageManager().getPackageInfo((String)$this$hasPermissionInManifest.getPackageName(), (int)4096).requestedPermissions, (Object)permissionName);
            } else {
                String[] cfr_ignored_0 = $this$hasPermissionInManifest.getPackageManager().getPackageInfo((String)$this$hasPermissionInManifest.getPackageName(), (int)4096).requestedPermissions;
                bl2 = false;
            }
            bl = bl2;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public static final File internalPrivateDir(@NotNull Context $this$internalPrivateDir) {
        Intrinsics.checkNotNullParameter((Object)$this$internalPrivateDir, (String)"$this$internalPrivateDir");
        return $this$internalPrivateDir.getFilesDir();
    }

    public static final File internalPrivateCacheDir(@NotNull Context $this$internalPrivateCacheDir) {
        Intrinsics.checkNotNullParameter((Object)$this$internalPrivateCacheDir, (String)"$this$internalPrivateCacheDir");
        return $this$internalPrivateCacheDir.getCacheDir();
    }

    @Nullable
    public static final File externalPrivateDir(@NotNull Context $this$externalPrivateDir, @Nullable String subDir) {
        Intrinsics.checkNotNullParameter((Object)$this$externalPrivateDir, (String)"$this$externalPrivateDir");
        return $this$externalPrivateDir.getExternalFilesDir(subDir);
    }

    public static /* synthetic */ File externalPrivateDir$default(Context context, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ContextExtensionsKt.externalPrivateDir(context, string);
    }

    @Nullable
    public static final File externalPrivateCacheDir(@NotNull Context $this$externalPrivateCacheDir) {
        Intrinsics.checkNotNullParameter((Object)$this$externalPrivateCacheDir, (String)"$this$externalPrivateCacheDir");
        return $this$externalPrivateCacheDir.getExternalCacheDir();
    }

    public static final File[] externalPrivateDirs(@NotNull Context $this$externalPrivateDirs, @Nullable String subDir) {
        Intrinsics.checkNotNullParameter((Object)$this$externalPrivateDirs, (String)"$this$externalPrivateDirs");
        return $this$externalPrivateDirs.getExternalFilesDirs(subDir);
    }

    public static /* synthetic */ File[] externalPrivateDirs$default(Context context, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ContextExtensionsKt.externalPrivateDirs(context, string);
    }

    public static final File[] externalPrivateCacheDirs(@NotNull Context $this$externalPrivateCacheDirs) {
        Intrinsics.checkNotNullParameter((Object)$this$externalPrivateCacheDirs, (String)"$this$externalPrivateCacheDirs");
        return $this$externalPrivateCacheDirs.getExternalCacheDirs();
    }

    @Nullable
    public static final Boolean showKeyboard(@NotNull Context $this$showKeyboard, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)$this$showKeyboard, (String)"$this$showKeyboard");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context $this$inputMethodManager$iv = $this$showKeyboard;
        boolean $i$f$getInputMethodManager = false;
        Object object = $this$inputMethodManager$iv.getApplicationContext().getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        return inputMethodManager != null ? Boolean.valueOf(inputMethodManager.showSoftInput(view, 1)) : null;
    }

    @Nullable
    public static final Unit toggleKeyboard(@NotNull Context $this$toggleKeyboard) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)$this$toggleKeyboard, (String)"$this$toggleKeyboard");
        Context $this$inputMethodManager$iv = $this$toggleKeyboard;
        boolean $i$f$getInputMethodManager = false;
        Object object = $this$inputMethodManager$iv.getApplicationContext().getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        if (inputMethodManager != null) {
            inputMethodManager.toggleSoftInput(1, 0);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public static final Boolean hideKeyboard(@NotNull Context $this$hideKeyboard, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)$this$hideKeyboard, (String)"$this$hideKeyboard");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context $this$inputMethodManager$iv = $this$hideKeyboard;
        boolean $i$f$getInputMethodManager = false;
        Object object = $this$inputMethodManager$iv.getApplicationContext().getSystemService("input_method");
        if (!(object instanceof InputMethodManager)) {
            object = null;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        return inputMethodManager != null ? Boolean.valueOf(inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2)) : null;
    }

    @NotNull
    public static final String applicationName(@NotNull Context $this$applicationName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$applicationName, (String)"$this$applicationName");
        int stringId = $this$applicationName.getApplicationInfo().labelRes;
        if (stringId == 0) {
            string = ((Object)$this$applicationName.getApplicationInfo().nonLocalizedLabel).toString();
        } else {
            String string2 = $this$applicationName.getString(stringId);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(stringId)");
        }
        return string;
    }
}

