/*
 * Decompiled with CFR 0.152.
 */
package com.twocoders.extensions.common;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import com.twocoders.extensions.common.ContextExtensionsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0016\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a)\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0006*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0002\u001a\u001b\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0001\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u001a\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00022\b\b\u0001\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u00020\u00022\b\b\u0001\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010&\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006'"}, d2={"checkPermission", "", "Landroid/app/Application;", "permission", "", "checkPermissions", "", "permissions", "", "(Landroid/app/Application;[Ljava/lang/String;)Ljava/util/Map;", "getMetaData", "Landroid/os/Bundle;", "getMetaDataBooleanValue", "id", "", "(Landroid/app/Application;I)Ljava/lang/Boolean;", "getMetaDataFloatValue", "", "(Landroid/app/Application;I)Ljava/lang/Float;", "getMetaDataStringValue", "hasAccelerometer", "hasBarometer", "hasBluetooth", "hasCamera", "hasCameraFlash", "hasCompass", "hasFingerprint", "hasGps", "hasGyroscope", "hasHeartRate", "hasLightSensor", "hasMicrophone", "hasNfc", "hasProximitySensor", "hasStepCounter", "hasStepDetector", "hasTouchScreen", "hasUsbHost", "hasWifi", "common_release"})
public final class ApplicationExtensionsKt {
    public static final boolean hasCamera(@NotNull Application $this$hasCamera) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCamera, (String)"$this$hasCamera");
        return $this$hasCamera.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static final boolean hasCameraFlash(@NotNull Application $this$hasCameraFlash) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCameraFlash, (String)"$this$hasCameraFlash");
        return $this$hasCameraFlash.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    public static final boolean hasBluetooth(@NotNull Application $this$hasBluetooth) {
        Intrinsics.checkNotNullParameter((Object)$this$hasBluetooth, (String)"$this$hasBluetooth");
        return $this$hasBluetooth.getPackageManager().hasSystemFeature("android.hardware.bluetooth");
    }

    public static final boolean hasGps(@NotNull Application $this$hasGps) {
        Intrinsics.checkNotNullParameter((Object)$this$hasGps, (String)"$this$hasGps");
        return $this$hasGps.getPackageManager().hasSystemFeature("android.hardware.location.gps");
    }

    public static final boolean hasMicrophone(@NotNull Application $this$hasMicrophone) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMicrophone, (String)"$this$hasMicrophone");
        return $this$hasMicrophone.getPackageManager().hasSystemFeature("android.hardware.microphone");
    }

    public static final boolean hasNfc(@NotNull Application $this$hasNfc) {
        Intrinsics.checkNotNullParameter((Object)$this$hasNfc, (String)"$this$hasNfc");
        return $this$hasNfc.getPackageManager().hasSystemFeature("android.hardware.nfc");
    }

    public static final boolean hasAccelerometer(@NotNull Application $this$hasAccelerometer) {
        Intrinsics.checkNotNullParameter((Object)$this$hasAccelerometer, (String)"$this$hasAccelerometer");
        return $this$hasAccelerometer.getPackageManager().hasSystemFeature("android.hardware.sensor.accelerometer");
    }

    public static final boolean hasGyroscope(@NotNull Application $this$hasGyroscope) {
        Intrinsics.checkNotNullParameter((Object)$this$hasGyroscope, (String)"$this$hasGyroscope");
        return $this$hasGyroscope.getPackageManager().hasSystemFeature("android.hardware.sensor.gyroscope");
    }

    public static final boolean hasStepCounter(@NotNull Application $this$hasStepCounter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasStepCounter, (String)"$this$hasStepCounter");
        return $this$hasStepCounter.getPackageManager().hasSystemFeature("android.hardware.sensor.stepcounter");
    }

    public static final boolean hasStepDetector(@NotNull Application $this$hasStepDetector) {
        Intrinsics.checkNotNullParameter((Object)$this$hasStepDetector, (String)"$this$hasStepDetector");
        return $this$hasStepDetector.getPackageManager().hasSystemFeature("android.hardware.sensor.stepdetector");
    }

    public static final boolean hasCompass(@NotNull Application $this$hasCompass) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCompass, (String)"$this$hasCompass");
        return $this$hasCompass.getPackageManager().hasSystemFeature("android.hardware.sensor.compass");
    }

    public static final boolean hasBarometer(@NotNull Application $this$hasBarometer) {
        Intrinsics.checkNotNullParameter((Object)$this$hasBarometer, (String)"$this$hasBarometer");
        return $this$hasBarometer.getPackageManager().hasSystemFeature("android.hardware.sensor.barometer");
    }

    public static final boolean hasHeartRate(@NotNull Application $this$hasHeartRate) {
        Intrinsics.checkNotNullParameter((Object)$this$hasHeartRate, (String)"$this$hasHeartRate");
        return $this$hasHeartRate.getPackageManager().hasSystemFeature("android.hardware.sensor.heartrate");
    }

    public static final boolean hasLightSensor(@NotNull Application $this$hasLightSensor) {
        Intrinsics.checkNotNullParameter((Object)$this$hasLightSensor, (String)"$this$hasLightSensor");
        return $this$hasLightSensor.getPackageManager().hasSystemFeature("android.hardware.sensor.light");
    }

    public static final boolean hasProximitySensor(@NotNull Application $this$hasProximitySensor) {
        Intrinsics.checkNotNullParameter((Object)$this$hasProximitySensor, (String)"$this$hasProximitySensor");
        return $this$hasProximitySensor.getPackageManager().hasSystemFeature("android.hardware.sensor.proximity");
    }

    @RequiresApi(api=23)
    public static final boolean hasFingerprint(@NotNull Application $this$hasFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFingerprint, (String)"$this$hasFingerprint");
        return $this$hasFingerprint.getPackageManager().hasSystemFeature("android.hardware.fingerprint");
    }

    public static final boolean hasTouchScreen(@NotNull Application $this$hasTouchScreen) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTouchScreen, (String)"$this$hasTouchScreen");
        return $this$hasTouchScreen.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
    }

    public static final boolean hasUsbHost(@NotNull Application $this$hasUsbHost) {
        Intrinsics.checkNotNullParameter((Object)$this$hasUsbHost, (String)"$this$hasUsbHost");
        return $this$hasUsbHost.getPackageManager().hasSystemFeature("android.hardware.usb.host");
    }

    public static final boolean hasWifi(@NotNull Application $this$hasWifi) {
        Intrinsics.checkNotNullParameter((Object)$this$hasWifi, (String)"$this$hasWifi");
        return $this$hasWifi.getPackageManager().hasSystemFeature("android.hardware.wifi");
    }

    public static final boolean checkPermission(@NotNull Application $this$checkPermission, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)$this$checkPermission, (String)"$this$checkPermission");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Context context = $this$checkPermission.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        return ContextExtensionsKt.checkPermission(context, permission);
    }

    @NotNull
    public static final Map<String, Boolean> checkPermissions(@NotNull Application $this$checkPermissions, @NotNull String[] permissions) {
        Intrinsics.checkNotNullParameter((Object)$this$checkPermissions, (String)"$this$checkPermissions");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Context context = $this$checkPermissions.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        return ContextExtensionsKt.checkPermissions(context, permissions);
    }

    @Nullable
    public static final Bundle getMetaData(@NotNull Application $this$getMetaData) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)$this$getMetaData, (String)"$this$getMetaData");
        try {
            bundle = $this$getMetaData.getPackageManager().getApplicationInfo((String)$this$getMetaData.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            bundle = null;
        }
        return bundle;
    }

    @Nullable
    public static final String getMetaDataStringValue(@NotNull Application $this$getMetaDataStringValue, @StringRes int id) {
        Intrinsics.checkNotNullParameter((Object)$this$getMetaDataStringValue, (String)"$this$getMetaDataStringValue");
        Bundle bundle = ApplicationExtensionsKt.getMetaData($this$getMetaDataStringValue);
        return bundle != null ? bundle.getString($this$getMetaDataStringValue.getString(id)) : null;
    }

    @Nullable
    public static final Float getMetaDataFloatValue(@NotNull Application $this$getMetaDataFloatValue, @StringRes int id) {
        Intrinsics.checkNotNullParameter((Object)$this$getMetaDataFloatValue, (String)"$this$getMetaDataFloatValue");
        Bundle bundle = ApplicationExtensionsKt.getMetaData($this$getMetaDataFloatValue);
        return bundle != null ? Float.valueOf(bundle.getFloat($this$getMetaDataFloatValue.getString(id))) : null;
    }

    @Nullable
    public static final Boolean getMetaDataBooleanValue(@NotNull Application $this$getMetaDataBooleanValue, @StringRes int id) {
        Intrinsics.checkNotNullParameter((Object)$this$getMetaDataBooleanValue, (String)"$this$getMetaDataBooleanValue");
        Bundle bundle = ApplicationExtensionsKt.getMetaData($this$getMetaDataBooleanValue);
        return bundle != null ? Boolean.valueOf(bundle.getBoolean($this$getMetaDataBooleanValue.getString(id))) : null;
    }
}

