/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.PemBytes;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import scala.Function1;
import scala.collection.immutable.Seq;

public final class X509CertificateDeserializer$ {
    public static final X509CertificateDeserializer$ MODULE$ = new X509CertificateDeserializer$();
    private static final String MessageType = "CERTIFICATE";
    private static final Function1<byte[], X509Certificate> deserializeX509 = (Function1 & Serializable)certBytes -> {
        void var2_2;
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream((byte[])certBytes));
        certificate.checkValidity();
        return var2_2;
    };

    public Try<X509Certificate> deserializeCertificate(String rawPem, String name) {
        PemBytes pemBytes = new PemBytes(rawPem, name);
        Try<byte[]> message = pemBytes.readMessage(MessageType);
        return message.map(deserializeX509);
    }

    public Try<Seq<X509Certificate>> deserializeCertificates(String rawPem, String name) {
        PemBytes pemBytes = new PemBytes(rawPem, name);
        Try<Seq<byte[]>> messages = pemBytes.readMessages(MessageType);
        return messages.map((Function1 & Serializable)x$1 -> (Seq)x$1.map(deserializeX509));
    }

    private X509CertificateDeserializer$() {
    }
}

