/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.X509CertificateFile;
import com.twitter.util.security.X509TrustManagerFactory$;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\b\u0010\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0007[\u0001\u0001K\u0011\u0002\u0018\t\r\u0001\u0003\u0001\u0015\"\u0003B\u0011\u0019\t\u0006\u0001)C\u0005%\"1\u0001\f\u0001Q\u0005\neCa!\u001a\u0001!\n\u00131\u0007\"\u00028\u0001\t\u0003yw!\u0002;\u0010\u0011\u0013)h!\u0002\b\u0010\u0011\u00131\b\"\u0002\u0015\u000b\t\u00039\bb\u0002=\u000b\u0005\u0004%I!\u001f\u0005\b\u0003\u0003Q\u0001\u0015!\u0003{\u0005]AV\u0007M\u001dUeV\u001cH/T1oC\u001e,'OR1di>\u0014\u0018P\u0003\u0002\u0011#\u0005A1/Z2ve&$\u0018P\u0003\u0002\u0013'\u0005!Q\u000f^5m\u0015\t!R#A\u0004uo&$H/\u001a:\u000b\u0003Y\t1aY8n\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003%\u0019WM\u001d;t\r&dW\r\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005\u0011\u0011n\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0003GS2,\u0017A\u0002\u001fj]&$h\b\u0006\u0002+YA\u00111\u0006A\u0007\u0002\u001f!)qD\u0001a\u0001A\u0005aAn\\4Fq\u000e,\u0007\u000f^5p]R\u0011qF\r\t\u00035AJ!!M\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006g\r\u0001\r\u0001N\u0001\u0003Kb\u0004\"!N\u001f\u000f\u0005YZdBA\u001c;\u001b\u0005A$BA\u001d\u0018\u0003\u0019a$o\\8u}%\tA$\u0003\u0002=7\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005%!\u0006N]8xC\ndWM\u0003\u0002=7\u0005\u00192/\u001a;DKJ$\u0018NZ5dCR,WI\u001c;ssR\u0011!i\u0013\u000b\u0003_\rCQ\u0001\u0012\u0003A\u0002\u0015\u000bAaY3siB\u0011a)S\u0007\u0002\u000f*\u0011A\t\u0013\u0006\u0003!\u0011J!AS$\u0003\u001fa+\u0004'O\"feRLg-[2bi\u0016DQ\u0001\u0014\u0003A\u00025\u000b!a[:\u0011\u00059{U\"\u0001%\n\u0005AC%\u0001C&fsN#xN]3\u0002\u001f\r,'\u000f^:U_.+\u0017p\u0015;pe\u0016$\"!T*\t\u000bQ+\u0001\u0019A+\u0002\u000b\r,'\u000f^:\u0011\u0007U2V)\u0003\u0002X\u007f\t\u00191+Z9\u0002\u001b-,\u0017p\u0015;pe\u0016$v\u000eV7g)\tQF\r\u0005\u0002\\E6\tAL\u0003\u0002^=\u0006\u00191o\u001d7\u000b\u0005}\u0003\u0017a\u00018fi*\t\u0011-A\u0003kCZ\f\u00070\u0003\u0002d9\n\u0019BK];ti6\u000bg.Y4fe\u001a\u000b7\r^8ss\")AJ\u0002a\u0001\u001b\u0006!2-\u001a:ugR{GK];ti6\u000bg.Y4feN$\"aZ7\u0011\u0007iA'.\u0003\u0002j7\t)\u0011I\u001d:bsB\u00111l[\u0005\u0003Yr\u0013A\u0002\u0016:vgRl\u0015M\\1hKJDQ\u0001V\u0004A\u0002U\u000b\u0001cZ3u)J,8\u000f^'b]\u0006<WM]:\u0015\u0003A\u00042!\u001d:h\u001b\u0005\t\u0012BA:\u0012\u0005\r!&/_\u0001\u00181V\u0002\u0014\b\u0016:vgRl\u0015M\\1hKJ4\u0015m\u0019;pef\u0004\"a\u000b\u0006\u0014\u0005)IB#A;\u0002\u00071|w-F\u0001{!\tYh0D\u0001}\u0015\ti8#A\u0004m_\u001e<\u0017N\\4\n\u0005}d(A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0003")
public class X509TrustManagerFactory {
    private final File certsFile;

    private void logException(Throwable ex) {
        X509TrustManagerFactory$.MODULE$.com$twitter$util$security$X509TrustManagerFactory$$log().warning(new StringBuilder(60).append("X509TrustManagerFactory (").append(this.certsFile.getName()).append(") ").append("failed to create trust manager: ").append(ex.getMessage()).append(".").toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private void setCertificateEntry(KeyStore ks, X509Certificate cert) {
        String alias = UUID.randomUUID().toString();
        ks.setCertificateEntry(alias, cert);
    }

    /*
     * WARNING - void declaration
     */
    private KeyStore certsToKeyStore(Seq<X509Certificate> certs) {
        void var2_2;
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        certs.foreach((Function1 & java.io.Serializable & Serializable)cert -> {
            this.setCertificateEntry(ks, cert);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private TrustManagerFactory keyStoreToTmf(KeyStore ks) {
        void var2_2;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        return var2_2;
    }

    private TrustManager[] certsToTrustManagers(Seq<X509Certificate> certs) {
        KeyStore ks = this.certsToKeyStore(certs);
        TrustManagerFactory tmf = this.keyStoreToTmf(ks);
        return tmf.getTrustManagers();
    }

    public Try<TrustManager[]> getTrustManagers() {
        Try<Seq<X509Certificate>> tryCerts = new X509CertificateFile(this.certsFile).readX509Certificates();
        return tryCerts.map((Function1 & java.io.Serializable & Serializable)certs -> this.certsToTrustManagers((Seq<X509Certificate>)certs)).onFailure((Function1 & java.io.Serializable & Serializable)ex -> {
            this.logException(ex);
            return BoxedUnit.UNIT;
        });
    }

    public X509TrustManagerFactory(File certsFile) {
        this.certsFile = certsFile;
    }
}

