/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.Pkcs8EncodedKeySpecFile;
import com.twitter.util.security.Pkcs8KeyManagerFactory$;
import com.twitter.util.security.X509CertificateFile;
import java.io.File;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001-\u0011a\u0003U6dgbZU-_'b]\u0006<WM\u001d$bGR|'/\u001f\u0006\u0003\u0007\u0011\t\u0001b]3dkJLG/\u001f\u0006\u0003\u000b\u0019\tA!\u001e;jY*\u0011q\u0001C\u0001\bi^LG\u000f^3s\u0015\u0005I\u0011aA2p[\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001B\u0001B\u0003%A#A\u0005dKJ$8OR5mKB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0003S>T\u0011!G\u0001\u0005U\u00064\u0018-\u0003\u0002\u001c-\t!a)\u001b7f\u0011!i\u0002A!A!\u0002\u0013!\u0012aB6fs\u001aKG.\u001a\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u001aC\u0005\u0005\u0002#\u00015\t!\u0001C\u0003\u0014=\u0001\u0007A\u0003C\u0003\u001e=\u0001\u0007A\u0003\u0003\u0004'\u0001\u0001&IaJ\u0001\rY><W\t_2faRLwN\u001c\u000b\u0003Q-\u0002\"!D\u0015\n\u0005)r!\u0001B+oSRDQ\u0001L\u0013A\u00025\n!!\u001a=\u0011\u000592dBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u0011$\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QGD\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004HA\u0005UQJ|w/\u00192mK*\u0011QG\u0004\u0005\u0007u\u0001\u0001K\u0011B\u001e\u0002'-,\u0017p\u00159fGR{\u0007K]5wCR,7*Z=\u0015\u0005q\n\u0005CA\u001f@\u001b\u0005q$BA\u0002\u0019\u0013\t\u0001eH\u0001\u0006Qe&4\u0018\r^3LKfDQAQ\u001dA\u0002\r\u000bqa[3z'B,7\r\u0005\u0002E\u000f6\tQI\u0003\u0002G}\u0005!1\u000f]3d\u0013\tAUIA\nQ\u0017\u000e\u001b\u0006(\u00128d_\u0012,GmS3z'B,7\r\u0003\u0004K\u0001\u0001&IaS\u0001\u000fGJ,\u0017\r^3LKf\u001cFo\u001c:f)\rauJ\u0017\t\u0003{5K!A\u0014 \u0003\u0011-+\u0017p\u0015;pe\u0016DQ\u0001U%A\u0002E\u000bQaY3siN\u00042A\f*U\u0013\t\u0019\u0006HA\u0002TKF\u0004\"!\u0016-\u000e\u0003YS!a\u0016 \u0002\t\r,'\u000f^\u0005\u00033Z\u0013q\u0002W\u001b1s\r+'\u000f^5gS\u000e\fG/\u001a\u0005\u00067&\u0003\r\u0001P\u0001\u000baJLg/\u0019;f\u0017\u0016L\bBB/\u0001A\u0013%a,A\u000blKf\u001cFo\u001c:f)>\\U-_'b]\u0006<WM]:\u0015\u0005}c\u0007cA\u0007aE&\u0011\u0011M\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003G*l\u0011\u0001\u001a\u0006\u0003K\u001a\f1a]:m\u0015\t9\u0007.A\u0002oKRT\u0011![\u0001\u0006U\u00064\u0018\r_\u0005\u0003W\u0012\u0014!bS3z\u001b\u0006t\u0017mZ3s\u0011\u0015iG\f1\u0001M\u0003!YW-_*u_J,\u0007\"B8\u0001\t\u0003\u0001\u0018AD4fi.+\u00170T1oC\u001e,'o\u001d\u000b\u0002cB\u0019!o]0\u000e\u0003\u0011I!\u0001\u001e\u0003\u0003\u0007Q\u0013\u0018pB\u0003w\u0005!%q/\u0001\fQW\u000e\u001c\bhS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z!\t\u0011\u0003PB\u0003\u0002\u0005!%\u0011p\u0005\u0002y\u0019!)q\u0004\u001fC\u0001wR\tq\u000fC\u0004~q\n\u0007I\u0011\u0002@\u0002\u00071|w-F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003\r\u00059An\\4hS:<\u0017\u0002BA\u0005\u0003\u0007\u0011a\u0001T8hO\u0016\u0014\bbBA\u0007q\u0002\u0006Ia`\u0001\u0005Y><\u0007\u0005C\u0004\u0002\u0012a$I!a\u0005\u0002\t)|\u0017N\\\u000b\u0007\u0003+\t\u0019#a\u000e\u0015\r\u0005]\u00111HA!!\u0011\u00118/!\u0007\u0011\u000f5\tY\"a\b\u00026%\u0019\u0011Q\u0004\b\u0003\rQ+\b\u000f\\33!\u0011\t\t#a\t\r\u0001\u0011A\u0011QEA\b\u0005\u0004\t9CA\u0001B#\u0011\tI#a\f\u0011\u00075\tY#C\u0002\u0002.9\u0011qAT8uQ&tw\rE\u0002\u000e\u0003cI1!a\r\u000f\u0005\r\te.\u001f\t\u0005\u0003C\t9\u0004\u0002\u0005\u0002:\u0005=!\u0019AA\u0014\u0005\u0005\u0011\u0005\u0002CA\u001f\u0003\u001f\u0001\r!a\u0010\u0002\tQ\u0014\u00180\u0011\t\u0005eN\fy\u0002\u0003\u0005\u0002D\u0005=\u0001\u0019AA#\u0003\u0011!(/\u001f\"\u0011\tI\u001c\u0018Q\u0007")
public class Pkcs8KeyManagerFactory {
    private final File certsFile;
    private final File keyFile;

    public void com$twitter$util$security$Pkcs8KeyManagerFactory$$logException(Throwable ex) {
        Pkcs8KeyManagerFactory$.MODULE$.com$twitter$util$security$Pkcs8KeyManagerFactory$$log().warning(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pkcs8KeyManagerFactory (", ", ", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.certsFile.getName(), this.keyFile.getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to create key manager: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex.getMessage()}))).toString(), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public PrivateKey com$twitter$util$security$Pkcs8KeyManagerFactory$$keySpecToPrivateKey(PKCS8EncodedKeySpec keySpec) {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }

    public KeyStore com$twitter$util$security$Pkcs8KeyManagerFactory$$createKeyStore(Seq<X509Certificate> certs, PrivateKey privateKey) {
        String alias = UUID.randomUUID().toString();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        ks.setKeyEntry(alias, privateKey, "".toCharArray(), (Certificate[])certs.toArray(ClassTag$.MODULE$.apply(Certificate.class)));
        return ks;
    }

    public KeyManager[] com$twitter$util$security$Pkcs8KeyManagerFactory$$keyStoreToKeyManagers(KeyStore keyStore) {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, "".toCharArray());
        return kmf.getKeyManagers();
    }

    public Try<KeyManager[]> getKeyManagers() {
        Try<Seq<X509Certificate>> tryCerts = new X509CertificateFile(this.certsFile).readX509Certificates();
        Try<PKCS8EncodedKeySpec> tryKeySpec = new Pkcs8EncodedKeySpecFile(this.keyFile).readPkcs8EncodedKeySpec();
        Try tryPrivateKey = tryKeySpec.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Pkcs8KeyManagerFactory $outer;

            public final PrivateKey apply(PKCS8EncodedKeySpec keySpec) {
                return this.$outer.com$twitter$util$security$Pkcs8KeyManagerFactory$$keySpecToPrivateKey(keySpec);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Try tryCertsKey = Pkcs8KeyManagerFactory$.MODULE$.com$twitter$util$security$Pkcs8KeyManagerFactory$$join(tryCerts, tryPrivateKey);
        Try tryKeyStore = tryCertsKey.map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Pkcs8KeyManagerFactory $outer;

            public final KeyStore apply(Seq<X509Certificate> certs, PrivateKey privateKey) {
                return this.$outer.com$twitter$util$security$Pkcs8KeyManagerFactory$$createKeyStore(certs, privateKey);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.tupled());
        return tryKeyStore.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Pkcs8KeyManagerFactory $outer;

            public final KeyManager[] apply(KeyStore keyStore) {
                return this.$outer.com$twitter$util$security$Pkcs8KeyManagerFactory$$keyStoreToKeyManagers(keyStore);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).onFailure((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Pkcs8KeyManagerFactory $outer;

            public final void apply(Throwable ex) {
                this.$outer.com$twitter$util$security$Pkcs8KeyManagerFactory$$logException(ex);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Pkcs8KeyManagerFactory(File certsFile, File keyFile) {
        this.certsFile = certsFile;
        this.keyFile = keyFile;
    }
}

