/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.concurrent.AsyncQueue;
import com.twitter.logging.Handler;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.logging.ProxyHandler;
import com.twitter.logging.QueueingHandler$;
import com.twitter.logging.QueueingHandler$QueueClosedException$;
import com.twitter.logging.QueueingHandler$RecordWithLocals$;
import com.twitter.util.Future;
import com.twitter.util.Local;
import com.twitter.util.Local$;
import com.twitter.util.Return;
import com.twitter.util.Return$;
import com.twitter.util.Throw;
import com.twitter.util.Throw$;
import com.twitter.util.Time$;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogRecord;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class QueueingHandler
extends ProxyHandler {
    private final int maxQueueSize;
    private final boolean inferClassNames;
    private final String dropLogNode;
    private final Logger log;
    private final AsyncQueue<RecordWithLocals> queue;
    private final AtomicBoolean closed;

    public static <H extends Handler> Function0<QueueingHandler> apply(Function0<H> function0) {
        return QueueingHandler$.MODULE$.apply(function0);
    }

    public static Function0<QueueingHandler> apply(Function0<Handler> function0, int n) {
        return QueueingHandler$.MODULE$.apply(function0, n);
    }

    public static <H extends Handler> Function0<QueueingHandler> apply(Function0<H> function0, int n, boolean bl) {
        return QueueingHandler$.MODULE$.apply(function0, n, bl);
    }

    public static <H extends Handler> int apply$default$2() {
        return QueueingHandler$.MODULE$.apply$default$2();
    }

    public static <H extends Handler> boolean apply$default$3() {
        return QueueingHandler$.MODULE$.apply$default$3();
    }

    public QueueingHandler(Handler handler, int maxQueueSize, boolean inferClassNames) {
        this.maxQueueSize = maxQueueSize;
        this.inferClassNames = inferClassNames;
        super(handler);
        this.dropLogNode = "";
        this.log = Logger$.MODULE$.apply(this.dropLogNode());
        this.queue = new AsyncQueue(maxQueueSize);
        this.closed = new AtomicBoolean(false);
        QueueingHandler$.com$twitter$logging$QueueingHandler$$$DefaultFuturePool.apply(this::$init$$$anonfun$1);
    }

    private Handler handler$accessor() {
        return super.handler();
    }

    public int maxQueueSize() {
        return this.maxQueueSize;
    }

    public QueueingHandler(Handler handler, int maxQueueSize) {
        this(handler, maxQueueSize, false);
    }

    public QueueingHandler(Handler handler) {
        this(handler, Integer.MAX_VALUE);
    }

    public String dropLogNode() {
        return this.dropLogNode;
    }

    public Logger log() {
        return this.log;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.inferClassNames) {
            record.getSourceClassName();
        }
        QueueingHandler$.com$twitter$logging$QueueingHandler$$$DefaultFuturePool.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.publish$$anonfun$1(record)));
    }

    private void doPublish(RecordWithLocals record) {
        Local$.MODULE$.let(record.locals(), (Function0)((JFunction0.mcV.sp & Serializable)() -> this.doPublish$$anonfun$1(record)));
    }

    private Future<BoxedUnit> loop() {
        return this.queue.poll().map((Function1)(JProcedure1 & Serializable)record -> this.doPublish((RecordWithLocals)record)).respond((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Return) {
                Return return_ = Return$.MODULE$.unapply((Return)try_);
                BoxedUnit boxedUnit = (BoxedUnit)return_._1();
                this.loop();
            } else if (try_ instanceof Throw) {
                Throw throw_ = Throw$.MODULE$.unapply((Throw)try_);
                Throwable throwable = throw_._1();
                if (!QueueingHandler$QueueClosedException$.MODULE$.equals(throwable)) {
                    Throwable e = throwable;
                    e.printStackTrace();
                    this.loop();
                }
            } else {
                throw new MatchError((Object)try_);
            }
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.queue.fail((Throwable)QueueingHandler$QueueClosedException$.MODULE$, true);
            super.close();
        }
    }

    @Override
    public void flush() {
        this.queue.drain().map((Function1)(JProcedure1 & Serializable)records -> records.foreach((Function1)(JProcedure1 & Serializable)record -> this.doPublish((RecordWithLocals)record)));
        super.flush();
    }

    public void onOverflow(LogRecord record) {
        Console$.MODULE$.err().println(String.format("[%s] log queue overflow - record dropped", Time$.MODULE$.now().toString()));
    }

    private final Future $init$$$anonfun$1() {
        return this.loop();
    }

    private final void publish$$anonfun$1(LogRecord record$1) {
        if (!this.queue.offer((Object)QueueingHandler$RecordWithLocals$.MODULE$.apply(record$1, Local$.MODULE$.save()))) {
            this.onOverflow(record$1);
        }
    }

    private final void doPublish$$anonfun$1(RecordWithLocals record$2) {
        super.publish(record$2.record());
    }

    private static class RecordWithLocals
    implements Product,
    Serializable {
        private final LogRecord record;
        private final Local.Context locals;

        public static RecordWithLocals apply(LogRecord logRecord, Local.Context context) {
            return QueueingHandler$RecordWithLocals$.MODULE$.apply(logRecord, context);
        }

        public static RecordWithLocals fromProduct(Product product) {
            return QueueingHandler$RecordWithLocals$.MODULE$.fromProduct(product);
        }

        public static RecordWithLocals unapply(RecordWithLocals recordWithLocals) {
            return QueueingHandler$RecordWithLocals$.MODULE$.unapply(recordWithLocals);
        }

        public RecordWithLocals(LogRecord record, Local.Context locals) {
            this.record = record;
            this.locals = locals;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RecordWithLocals)) return false;
            RecordWithLocals recordWithLocals = (RecordWithLocals)object;
            LogRecord logRecord = this.record();
            LogRecord logRecord2 = recordWithLocals.record();
            if (logRecord == null) {
                if (logRecord2 != null) {
                    return false;
                }
            } else if (!logRecord.equals(logRecord2)) return false;
            Local.Context context = this.locals();
            Local.Context context2 = recordWithLocals.locals();
            if (context == null) {
                if (context2 != null) {
                    return false;
                }
            } else if (!context.equals(context2)) return false;
            if (!recordWithLocals.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RecordWithLocals;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RecordWithLocals";
        }

        public Object productElement(int n) {
            LogRecord logRecord;
            int n2 = n;
            if (0 == n2) {
                logRecord = this._1();
            } else if (1 == n2) {
                logRecord = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return logRecord;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "record";
            } else if (1 == n2) {
                string = "locals";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public LogRecord record() {
            return this.record;
        }

        public Local.Context locals() {
            return this.locals;
        }

        public RecordWithLocals copy(LogRecord record, Local.Context locals) {
            return new RecordWithLocals(record, locals);
        }

        public LogRecord copy$default$1() {
            return this.record();
        }

        public Local.Context copy$default$2() {
            return this.locals();
        }

        public LogRecord _1() {
            return this.record();
        }

        public Local.Context _2() {
            return this.locals();
        }
    }
}

