/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Handler;
import com.twitter.logging.LazyLogRecordUnformatted;
import com.twitter.logging.ProxyHandler;
import com.twitter.logging.ThrottledHandler$;
import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ThrottledHandler
extends ProxyHandler {
    private final Duration duration;
    private final int maxToDisplay;
    private final AtomicReference<Time> lastFlushCheck;
    private final ConcurrentHashMap<String, Throttle> throttleMap;

    public static Function0<ThrottledHandler> apply(Function0<Handler> function0, Duration duration, int n) {
        return ThrottledHandler$.MODULE$.apply(function0, duration, n);
    }

    public static Duration apply$default$2() {
        return ThrottledHandler$.MODULE$.apply$default$2();
    }

    public static int apply$default$3() {
        return ThrottledHandler$.MODULE$.apply$default$3();
    }

    public ThrottledHandler(Handler handler, Duration duration, int maxToDisplay) {
        this.duration = duration;
        this.maxToDisplay = maxToDisplay;
        super(handler);
        this.lastFlushCheck = new AtomicReference<Time>(Time$.MODULE$.epoch());
        this.throttleMap = new ConcurrentHashMap();
    }

    private Handler handler$accessor() {
        return super.handler();
    }

    public Duration duration() {
        return this.duration;
    }

    public int maxToDisplay() {
        return this.maxToDisplay;
    }

    public void reset() {
        this.flushThrottled();
    }

    public void flushThrottled() {
        Time now = Time$.MODULE$.now();
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.throttleMap).asScala().retain((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
            } else {
                throw new MatchError((Object)tuple2);
            }
            Throttle throttle = (Throttle)tuple2._2();
            return !throttle.removeIfExpired(now);
        });
    }

    @Override
    public void publish(LogRecord record) {
        String string;
        LogRecord logRecord;
        Time last;
        Time now = Time$.MODULE$.now();
        if (now.$minus(last = this.lastFlushCheck.get()).$greater((Object)ThrottledHandler$.com$twitter$logging$ThrottledHandler$$$OneSecond) && this.lastFlushCheck.compareAndSet(last, now)) {
            this.flushThrottled();
        }
        if ((logRecord = record) instanceof LazyLogRecordUnformatted) {
            LazyLogRecordUnformatted r = (LazyLogRecordUnformatted)logRecord;
            string = r.preformatted();
        } else {
            string = record.getMessage();
        }
        String key = string;
        this.tryPublish$1(record, now, key);
    }

    public void com$twitter$logging$ThrottledHandler$$doPublish(LogRecord record) {
        super.publish(record);
    }

    private final void tryPublish$1(LogRecord record$1, Time now$2, String key$1) {
        Throttle throttle;
        while (!(throttle = this.throttleMap.computeIfAbsent(key$1, new Function<String, Throttle>(record$1, now$2, this){
            private final LogRecord record$1;
            private final Time now$1;
            private final ThrottledHandler $outer;
            {
                this.record$1 = record$3;
                this.now$1 = now$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Throttle apply(String key) {
                return new Throttle(this.$outer, this.now$1, this.record$1.getLoggerName(), this.record$1.getLevel());
            }
        })).add(record$1, now$2)) {
        }
    }

    private class Throttle {
        private final Time startTime;
        private final String name;
        private final Level level;
        private volatile boolean expired;
        private final AtomicInteger count;
        private final ThrottledHandler $outer;

        public Throttle(ThrottledHandler $outer, Time startTime, String name, Level level) {
            this.startTime = startTime;
            this.name = name;
            this.level = level;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.expired = false;
            this.count = new AtomicInteger(0);
        }

        public String toString() {
            return "Throttle: startTime=" + this.startTime + " count=" + this.count.get();
        }

        public final boolean add(LogRecord record, Time now) {
            boolean bl;
            if (!this.expired) {
                if (this.count.incrementAndGet() <= this.$outer.maxToDisplay()) {
                    this.$outer.com$twitter$logging$ThrottledHandler$$doPublish(record);
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean removeIfExpired(Time now) {
            void var2_2;
            boolean didExpire;
            this.expired = didExpire = now.$minus(this.startTime).$greater$eq((Object)this.$outer.duration());
            if (didExpire && this.count.get() > this.$outer.maxToDisplay()) {
                this.publishSwallowed();
            }
            return (boolean)var2_2;
        }

        private void publishSwallowed() {
            LogRecord throttledRecord = new LogRecord(this.level, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("(swallowed %d repeating messages)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.count.get() - this.$outer.maxToDisplay()))})));
            throttledRecord.setLoggerName(this.name);
            this.$outer.com$twitter$logging$ThrottledHandler$$doPublish(throttledRecord);
        }

        public final ThrottledHandler com$twitter$logging$ThrottledHandler$Throttle$$$outer() {
            return this.$outer;
        }
    }
}

