/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.ConsoleHandler;
import com.twitter.logging.Formatter;
import com.twitter.logging.Formatter$;
import com.twitter.logging.Level;
import com.twitter.logging.Level$;
import com.twitter.logging.Level$ALL$;
import com.twitter.logging.Level$CRITICAL$;
import com.twitter.logging.Level$DEBUG$;
import com.twitter.logging.Level$ERROR$;
import com.twitter.logging.Level$FATAL$;
import com.twitter.logging.Level$INFO$;
import com.twitter.logging.Level$OFF$;
import com.twitter.logging.Level$TRACE$;
import com.twitter.logging.Level$WARNING$;
import com.twitter.logging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Logger$
implements Iterable<Logger> {
    private static final Map<String, Level> levelNamesMap;
    private static final Map<Object, Level> levelsMap;
    private static final ConcurrentHashMap<String, Logger> loggersCache;
    private static volatile List<Function0<Logger>> loggerFactoryCache;
    private static final Logger root;
    public static final Logger$ MODULE$;

    private Logger$() {
    }

    static {
        MODULE$ = new Logger$();
        IterableOnce.$init$((IterableOnce)MODULE$);
        IterableOnceOps.$init$((IterableOnceOps)MODULE$);
        IterableOps.$init$((IterableOps)MODULE$);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)MODULE$);
        Iterable.$init$((Iterable)MODULE$);
        levelNamesMap = ((IterableOnceOps)Level$.MODULE$.AllLevels().map((Function1 & Serializable)level -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)level.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, level);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        levelsMap = ((IterableOnceOps)Level$.MODULE$.AllLevels().map((Function1 & Serializable)level -> {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)level.value()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, level);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        loggersCache = new ConcurrentHashMap(128, 0.75f, 2);
        loggerFactoryCache = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[0]));
        root = MODULE$.get("");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logger$.class);
    }

    public Logger root() {
        return root;
    }

    public Level$OFF$ OFF() {
        return Level$OFF$.MODULE$;
    }

    public Level$FATAL$ FATAL() {
        return Level$FATAL$.MODULE$;
    }

    public Level$CRITICAL$ CRITICAL() {
        return Level$CRITICAL$.MODULE$;
    }

    public Level$ERROR$ ERROR() {
        return Level$ERROR$.MODULE$;
    }

    public Level$WARNING$ WARNING() {
        return Level$WARNING$.MODULE$;
    }

    public Level$INFO$ INFO() {
        return Level$INFO$.MODULE$;
    }

    public Level$DEBUG$ DEBUG() {
        return Level$DEBUG$.MODULE$;
    }

    public Level$TRACE$ TRACE() {
        return Level$TRACE$.MODULE$;
    }

    public Level$ALL$ ALL() {
        return Level$ALL$.MODULE$;
    }

    public Map<Object, Level> levels() {
        return levelsMap;
    }

    public Map<String, Level> levelNames() {
        return levelNamesMap;
    }

    public void reset() {
        this.clearHandlers();
        loggersCache.clear();
        this.root().addHandler(new ConsoleHandler(new Formatter(Formatter$.MODULE$.$lessinit$greater$default$1(), Formatter$.MODULE$.$lessinit$greater$default$2(), Formatter$.MODULE$.$lessinit$greater$default$3(), Formatter$.MODULE$.$lessinit$greater$default$4(), Formatter$.MODULE$.$lessinit$greater$default$5()), (Option<Level>)None$.MODULE$));
    }

    public void clearHandlers() {
        this.foreach((Function1)(JProcedure1 & Serializable)logger -> {
            logger.clearHandlers();
            logger.setLevel(null);
        });
    }

    public void withLoggers(List<Function0<Logger>> loggerFactories, Function0<BoxedUnit> f) {
        this.withLazyLoggers((Function0<List<Logger>>)((Function0 & Serializable)() -> this.withLoggers$$anonfun$1(loggerFactories)), f);
    }

    public void withLazyLoggers(Function0<List<Logger>> loggers, Function0<BoxedUnit> f) {
        List<Function0<Logger>> localLoggerFactoryCache = loggerFactoryCache;
        this.clearHandlers();
        loggers.apply();
        f.apply$mcV$sp();
        this.reset();
        loggerFactoryCache = localLoggerFactoryCache;
        loggerFactoryCache.foreach((Function1 & Serializable)_$2 -> (Logger)_$2.apply());
    }

    public Logger get(String name) {
        Logger logger;
        Logger logger2 = loggersCache.get(name);
        if (logger2 != null) {
            Logger logger3;
            logger = logger3 = logger2;
        } else if (logger2 == null) {
            Logger logger4 = new Logger(name, java.util.logging.Logger.getLogger(name));
            Logger oldLogger = loggersCache.putIfAbsent(name, logger4);
            logger = oldLogger != null ? oldLogger : logger4;
        } else {
            throw new MatchError((Object)logger2);
        }
        return logger;
    }

    public Logger apply(String name) {
        return this.get(name);
    }

    private Logger get(int depth) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        return st.length >= depth ? this.getForClassName(st[depth].getClassName()) : this.getForClassName("stackTraceIsAbsent");
    }

    public Logger get() {
        return this.get(2);
    }

    public Logger apply() {
        return this.get(2);
    }

    private Logger getForClassName(String className) {
        return className.endsWith("$") ? this.get(className.substring(0, className.length() - 1)) : this.get(className);
    }

    public Logger get(Class<?> cls) {
        return this.getForClassName(cls.getName());
    }

    public Logger apply(Class<?> cls) {
        return this.get(cls);
    }

    public Iterator<Logger> iterator() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(loggersCache.values().iterator()).asScala();
    }

    public void configure(List<Function0<Logger>> loggerFactories) {
        loggerFactoryCache = loggerFactories;
        this.clearHandlers();
        loggerFactories.foreach((Function1 & Serializable)_$3 -> (Logger)_$3.apply());
    }

    private final List withLoggers$$anonfun$1(List loggerFactories$1) {
        return loggerFactories$1.map((Function1 & Serializable)_$1 -> (Logger)_$1.apply());
    }
}

