/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.conversions.time$;
import com.twitter.logging.Handler;
import com.twitter.logging.LazyLogRecordUnformatted;
import com.twitter.logging.ThrottledHandler$;
import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rv!B\u0001\u0003\u0011\u000bI\u0011\u0001\u0005+ie>$H\u000f\\3e\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u00151\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u000f\u0005\u00191m\\7\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0003\u001b\t\u0001B\u000b\u001b:piRdW\r\u001a%b]\u0012dWM]\n\u0004\u001791\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006;-!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%AQ\u0001I\u0006\u0005\u0002\u0005\nQ!\u00199qYf$rAIA7\u0003{\ny\bE\u0002\u0018G\u0015J!\u0001\n\r\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u0006'\r\u0011a!\u0001A\u0014\u0014\u0007\u0019Bc\u0003\u0005\u0002\u000bS%\u0011!F\u0001\u0002\b\u0011\u0006tG\r\\3s\u0011!acE!b\u0001\n\u0003i\u0013a\u00025b]\u0012dWM]\u000b\u0002Q!AqF\nB\u0001B\u0003%\u0001&\u0001\u0005iC:$G.\u001a:!\u0011!\tdE!b\u0001\n\u0003\u0011\u0014\u0001\u00033ve\u0006$\u0018n\u001c8\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003qU\u0012\u0001\u0002R;sCRLwN\u001c\u0005\tu\u0019\u0012\t\u0011)A\u0005g\u0005IA-\u001e:bi&|g\u000e\t\u0005\ty\u0019\u0012)\u0019!C\u0001{\u0005aQ.\u0019=U_\u0012K7\u000f\u001d7bsV\ta\b\u0005\u0002\u0018\u007f%\u0011\u0001\t\u0007\u0002\u0004\u0013:$\b\u0002\u0003\"'\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u001b5\f\u0007\u0010V8ESN\u0004H.Y=!\u0011\u0015ib\u0005\"\u0001E)\u0011)SIR$\t\u000b1\u001a\u0005\u0019\u0001\u0015\t\u000bE\u001a\u0005\u0019A\u001a\t\u000bq\u001a\u0005\u0019\u0001 \u0007\t%3CA\u0013\u0002\t)\"\u0014x\u000e\u001e;mKN\u0019\u0001J\u0004\f\t\u00111C%\u0011!Q\u0001\n5\u000b\u0011b\u001d;beR$\u0016.\\3\u0011\u0005Qr\u0015BA(6\u0005\u0011!\u0016.\\3\t\u0011EC%\u0011!Q\u0001\nI\u000bAA\\1nKB\u00111K\u0016\b\u0003/QK!!\u0016\r\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+bA\u0001B\u0017%\u0003\u0002\u0003\u0006IaW\u0001\u0006Y\u00164X\r\u001c\t\u00039~k\u0011!\u0018\u0006\u0003\u0007yS!A\u000e\n\n\u0005\u0001l&!\u0002'fm\u0016d\u0007\"B\u000fI\t\u0003\u0011G\u0003B2fM\u001e\u0004\"\u0001\u001a%\u000e\u0003\u0019BQ\u0001T1A\u00025CQ!U1A\u0002ICQAW1A\u0002mCa!\u001b%!B\u0013Q\u0017aB3ya&\u0014X\r\u001a\t\u0003/-L!\u0001\u001c\r\u0003\u000f\t{w\u000e\\3b]\"1a\u000e\u0013Q!\ny\nQaY8v]RDQ\u0001\u001d%\u0005BE\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002eB\u0011qb]\u0005\u0003/BAQ!\u001e%\u0005\u0006Y\f1!\u00193e)\rQw\u000f \u0005\u0006qR\u0004\r!_\u0001\u0007e\u0016\u001cwN\u001d3\u0011\u0005qS\u0018BA>^\u0005%aun\u001a*fG>\u0014H\rC\u0003~i\u0002\u0007Q*A\u0002o_^Daa %\u0005\u0006\u0005\u0005\u0011a\u0004:f[>4X-\u00134FqBL'/\u001a3\u0015\u0007)\f\u0019\u0001C\u0003~}\u0002\u0007Q\n\u0003\u0005\u0002\b!\u0003K\u0011BA\u0005\u0003A\u0001XO\u00197jg\"\u001cv/\u00197m_^,G\r\u0006\u0002\u0002\fA\u0019q#!\u0004\n\u0007\u0005=\u0001D\u0001\u0003V]&$\b\"CA\nM\t\u0007I\u0011BA\u000b\u00039a\u0017m\u001d;GYV\u001c\bn\u00115fG.,\"!a\u0006\u0011\u000b\u0005e\u00111E'\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\ta!\u0019;p[&\u001c'bAA\u0011=\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0015\u00121\u0004\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dK\"A\u0011\u0011\u0006\u0014!\u0002\u0013\t9\"A\bmCN$h\t\\;tQ\u000eCWmY6!\u0011%\tiC\nb\u0001\n\u0013\ty#A\u0006uQJ|G\u000f\u001e7f\u001b\u0006\u0004XCAA\u0019!\u0019\t\u0019$!\u0010SG6\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0004nkR\f'\r\\3\u000b\u0007\u0005m\u0002$\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u00026\t9\u0001*Y:i\u001b\u0006\u0004\b\u0002CA\"M\u0001\u0006I!!\r\u0002\u0019QD'o\u001c;uY\u0016l\u0015\r\u001d\u0011\t\u000f\u0005\u001dc\u0005\"\u0001\u0002\n\u0005)1\r\\8tK\"9\u00111\n\u0014\u0005\u0002\u0005%\u0011!\u00024mkND\u0007bBA(M\u0011\u0005\u0011\u0011B\u0001\u0006e\u0016\u001cX\r\u001e\u0015\t\u0003\u001b\n\u0019&!\u0017\u0002^A\u0019q#!\u0016\n\u0007\u0005]\u0003D\u0001\u0006eKB\u0014XmY1uK\u0012\f#!a\u0017\u00029U\u001bX\r\t4mkNDG\u000b\u001b:piRdW\r\u001a\u0015*A%t7\u000f^3bI\u0006\u0012\u0011qL\u0001\u0007k9\u001ad&M\u001a\t\u000f\u0005\rd\u0005\"\u0001\u0002\n\u0005qa\r\\;tQRC'o\u001c;uY\u0016$\u0007bBA4M\u0011\u0005\u0011\u0011N\u0001\baV\u0014G.[:i)\u0011\tY!a\u001b\t\ra\f)\u00071\u0001z\u0011\u0019as\u00041\u0001\u0002pA!\u0011\u0011OA<\u001d\rQ\u00111O\u0005\u0004\u0003k\u0012\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003s\nYH\u0001\bIC:$G.\u001a:GC\u000e$xN]=\u000b\u0007\u0005U$\u0001C\u00042?A\u0005\t\u0019A\u001a\t\u000fqz\u0002\u0013!a\u0001}!I\u00111Q\u0006\u0012\u0002\u0013\u0005\u0011QQ\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0011\u0016\u0004g\u0005%5FAAF!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0005$\u0001\u0006b]:|G/\u0019;j_:LA!!'\u0002\u0010\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005u5\"%A\u0005\u0002\u0005}\u0015aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005&f\u0001 \u0002\n\u0002")
public class ThrottledHandler
extends Handler
implements ScalaObject {
    private final Handler handler;
    private final Duration duration;
    private final int maxToDisplay;
    private final AtomicReference<Time> lastFlushCheck;
    private final HashMap<String, Throttle> throttleMap;

    public static final int apply$default$3() {
        return ThrottledHandler$.MODULE$.apply$default$3();
    }

    public static final Duration apply$default$2() {
        return ThrottledHandler$.MODULE$.apply$default$2();
    }

    public static final Function0<ThrottledHandler> apply(Function0<Handler> function0, Duration duration, int n) {
        return ThrottledHandler$.MODULE$.apply(function0, duration, n);
    }

    public Handler handler() {
        return this.handler;
    }

    public Duration duration() {
        return this.duration;
    }

    public int maxToDisplay() {
        return this.maxToDisplay;
    }

    private AtomicReference<Time> lastFlushCheck() {
        return this.lastFlushCheck;
    }

    private HashMap<String, Throttle> throttleMap() {
        return this.throttleMap;
    }

    @Override
    public void close() {
        this.handler().close();
    }

    @Override
    public void flush() {
        this.handler().flush();
    }

    public void reset() {
        this.flushThrottled();
    }

    public void flushThrottled() {
        ThrottledHandler throttledHandler = this;
        synchronized (throttledHandler) {
            Time now$1 = Time$.MODULE$.now();
            this.throttleMap().retain((Function2)new Serializable(this, now$1){
                public static final long serialVersionUID;
                private final Time now$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(String string, Throttle throttle) {
                    Tuple2 tuple2 = new Tuple2((Object)string, (Object)throttle);
                    if (tuple2 != null) {
                        return !((Throttle)tuple2._2()).removeIfExpired(this.now$1);
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.now$1 = time2;
                }
            });
            return;
        }
    }

    @Override
    public void publish(LogRecord record$1) {
        LogRecord logRecord;
        Time last;
        Time now$2 = Time$.MODULE$.now();
        if (now$2.$minus(last = this.lastFlushCheck().get()).$greater((Object)time$.MODULE$.intToTimeableNumber(1).second()) && this.lastFlushCheck().compareAndSet(last, now$2)) {
            this.flushThrottled();
        }
        String key$1 = (logRecord = record$1) instanceof LazyLogRecordUnformatted ? ((LazyLogRecordUnformatted)logRecord).preformatted() : record$1.getMessage();
        this.tryPublish$1(record$1, now$2, key$1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void tryPublish$1(LogRecord logRecord, Time time2, String string) {
        Object object;
        Throttle throttle;
        do {
            ThrottledHandler throttledHandler = this;
            synchronized (throttledHandler) {
                object = this.throttleMap().getOrElseUpdate((Object)string, (Function0)new Serializable(this, logRecord, time2){
                    public static final long serialVersionUID;
                    private final ThrottledHandler $outer;
                    private final LogRecord record$1;
                    private final Time now$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throttle apply() {
                        return new Throttle(this.$outer, this.now$2, this.record$1.getLoggerName(), this.record$1.getLevel());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.record$1 = logRecord;
                        this.now$2 = time2;
                    }
                });
            }
        } while (!(throttle = (Throttle)object).add(logRecord, time2));
    }

    public ThrottledHandler(Handler handler, Duration duration, int maxToDisplay) {
        this.handler = handler;
        this.duration = duration;
        this.maxToDisplay = maxToDisplay;
        super(handler.formatter(), handler.level());
        this.lastFlushCheck = new AtomicReference<Time>(Time$.MODULE$.epoch());
        this.throttleMap = new HashMap();
    }

    public class Throttle
    implements ScalaObject {
        private final Time startTime;
        private final String name;
        private final Level level;
        private boolean expired;
        private int count;
        public final ThrottledHandler $outer;

        public String toString() {
            return new StringBuilder().append((Object)"Throttle: startTime=").append((Object)this.startTime).append((Object)" count=").append((Object)BoxesRunTime.boxToInteger((int)this.count)).toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final boolean add(LogRecord record, Time now) {
            Tuple2 tuple2;
            block6: {
                Throttle throttle = this;
                synchronized (throttle) {
                    Tuple2 tuple22;
                    if (this.expired) {
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    } else {
                        ++this.count;
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((this.count <= this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay() ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    Tuple2 tuple23 = tuple22;
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : throttle
                    tuple2 = tuple23;
                    if (tuple2 == null) break block6;
                }
                Tuple2 tuple24 = new Tuple2(tuple2._1(), tuple2._2());
                boolean shouldPublish = BoxesRunTime.unboxToBoolean((Object)tuple24._1());
                boolean added = BoxesRunTime.unboxToBoolean((Object)tuple24._2());
                if (shouldPublish) {
                    this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().handler().publish(record);
                }
                return added;
            }
            throw new MatchError((Object)tuple2);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final boolean removeIfExpired(Time now) {
            void var2_4;
            Boolean bl;
            Throttle throttle = this;
            synchronized (throttle) {
                this.expired = now.$minus(this.startTime).$greater$eq((Object)this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().duration());
                bl = BoxesRunTime.boxToBoolean((boolean)this.expired);
            }
            boolean didExpire = BoxesRunTime.unboxToBoolean((Object)bl);
            if (didExpire && this.count > this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()) {
                this.publishSwallowed();
            }
            return (boolean)var2_4;
        }

        private void publishSwallowed() {
            LogRecord throttledRecord = new LogRecord(this.level, Predef$.MODULE$.augmentString("(swallowed %d repeating messages)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.count - this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()))})));
            throttledRecord.setLoggerName(this.name);
            this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().handler().publish(throttledRecord);
        }

        public ThrottledHandler com$twitter$logging$ThrottledHandler$Throttle$$$outer() {
            return this.$outer;
        }

        public Throttle(ThrottledHandler $outer, Time startTime, String name, Level level) {
            this.startTime = startTime;
            this.name = name;
            this.level = level;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.expired = false;
            this.count = 0;
        }
    }
}

