/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.ConsoleHandler;
import com.twitter.logging.Formatter;
import com.twitter.logging.Formatter$;
import com.twitter.logging.Level;
import com.twitter.logging.Level$;
import com.twitter.logging.Level$ALL$;
import com.twitter.logging.Level$CRITICAL$;
import com.twitter.logging.Level$DEBUG$;
import com.twitter.logging.Level$ERROR$;
import com.twitter.logging.Level$FATAL$;
import com.twitter.logging.Level$INFO$;
import com.twitter.logging.Level$OFF$;
import com.twitter.logging.Level$TRACE$;
import com.twitter.logging.Level$WARNING$;
import com.twitter.logging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LazyZip2;
import scala.collection.Map;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class Logger$
implements Iterable<Logger> {
    public static final Logger$ MODULE$ = new Logger$();
    private static final Map<String, Level> levelNamesMap;
    private static final Map<Object, Level> levelsMap;
    private static final ConcurrentHashMap<String, Logger> loggersCache;
    private static volatile List<Function0<Logger>> loggerFactoryCache;
    private static final Logger root;

    static {
        IterableOnce.$init$((IterableOnce)MODULE$);
        IterableOnceOps.$init$((IterableOnceOps)MODULE$);
        IterableOps.$init$((IterableOps)MODULE$);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)MODULE$);
        Iterable.$init$((Iterable)MODULE$);
        levelNamesMap = ((IterableOnceOps)Level$.MODULE$.AllLevels().map((Function1 & Serializable)level -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)level.name()), level))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        levelsMap = ((IterableOnceOps)Level$.MODULE$.AllLevels().map((Function1 & Serializable)level -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)level.value())), level))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        loggersCache = new ConcurrentHashMap(128, 0.75f, 2);
        loggerFactoryCache = Nil$.MODULE$;
        root = MODULE$.get("");
    }

    public final Iterable<Logger> toIterable() {
        return Iterable.toIterable$((Iterable)this);
    }

    public final Iterable<Logger> coll() {
        return Iterable.coll$((Iterable)this);
    }

    public IterableFactory<Iterable> iterableFactory() {
        return Iterable.iterableFactory$((Iterable)this);
    }

    public Iterable<Logger> seq() {
        return Iterable.seq$((Iterable)this);
    }

    public String className() {
        return Iterable.className$((Iterable)this);
    }

    public final String collectionClassName() {
        return Iterable.collectionClassName$((Iterable)this);
    }

    public String stringPrefix() {
        return Iterable.stringPrefix$((Iterable)this);
    }

    public String toString() {
        return Iterable.toString$((Iterable)this);
    }

    public <B> LazyZip2<Logger, B, Iterable> lazyZip(Iterable<B> that) {
        return Iterable.lazyZip$((Iterable)this, that);
    }

    public IterableOps fromSpecific(IterableOnce coll) {
        return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
    }

    public Builder<Logger, Iterable<Logger>> newSpecificBuilder() {
        return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
    }

    public IterableOps empty() {
        return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
    }

    public final Iterable<Logger> toTraversable() {
        return IterableOps.toTraversable$((IterableOps)this);
    }

    public boolean isTraversableAgain() {
        return IterableOps.isTraversableAgain$((IterableOps)this);
    }

    public final Object repr() {
        return IterableOps.repr$((IterableOps)this);
    }

    public IterableFactory<Iterable> companion() {
        return IterableOps.companion$((IterableOps)this);
    }

    public Object head() {
        return IterableOps.head$((IterableOps)this);
    }

    public Option<Logger> headOption() {
        return IterableOps.headOption$((IterableOps)this);
    }

    public Object last() {
        return IterableOps.last$((IterableOps)this);
    }

    public Option<Logger> lastOption() {
        return IterableOps.lastOption$((IterableOps)this);
    }

    public View<Logger> view() {
        return IterableOps.view$((IterableOps)this);
    }

    public int sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public final IterableOps sizeIs() {
        return IterableOps.sizeIs$((IterableOps)this);
    }

    public int sizeCompare(Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    public View<Logger> view(int from, int until) {
        return IterableOps.view$((IterableOps)this, (int)from, (int)until);
    }

    public Object transpose(Function1 asIterable) {
        return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
    }

    public Object filter(Function1 pred) {
        return IterableOps.filter$((IterableOps)this, (Function1)pred);
    }

    public Object filterNot(Function1 pred) {
        return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
    }

    public WithFilter<Logger, Iterable> withFilter(Function1<Logger, Object> p) {
        return IterableOps.withFilter$((IterableOps)this, p);
    }

    public Tuple2<Iterable<Logger>, Iterable<Logger>> partition(Function1<Logger, Object> p) {
        return IterableOps.partition$((IterableOps)this, p);
    }

    public Tuple2<Iterable<Logger>, Iterable<Logger>> splitAt(int n) {
        return IterableOps.splitAt$((IterableOps)this, (int)n);
    }

    public Object take(int n) {
        return IterableOps.take$((IterableOps)this, (int)n);
    }

    public Object takeRight(int n) {
        return IterableOps.takeRight$((IterableOps)this, (int)n);
    }

    public Object takeWhile(Function1 p) {
        return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
    }

    public Tuple2<Iterable<Logger>, Iterable<Logger>> span(Function1<Logger, Object> p) {
        return IterableOps.span$((IterableOps)this, p);
    }

    public Object drop(int n) {
        return IterableOps.drop$((IterableOps)this, (int)n);
    }

    public Object dropRight(int n) {
        return IterableOps.dropRight$((IterableOps)this, (int)n);
    }

    public Object dropWhile(Function1 p) {
        return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
    }

    public Iterator<Iterable<Logger>> grouped(int size) {
        return IterableOps.grouped$((IterableOps)this, (int)size);
    }

    public Iterator<Iterable<Logger>> sliding(int size) {
        return IterableOps.sliding$((IterableOps)this, (int)size);
    }

    public Iterator<Iterable<Logger>> sliding(int size, int step) {
        return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
    }

    public Object tail() {
        return IterableOps.tail$((IterableOps)this);
    }

    public Object init() {
        return IterableOps.init$((IterableOps)this);
    }

    public Object slice(int from, int until) {
        return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
    }

    public <K> scala.collection.immutable.Map<K, Iterable<Logger>> groupBy(Function1<Logger, K> f) {
        return IterableOps.groupBy$((IterableOps)this, f);
    }

    public <K, B> scala.collection.immutable.Map<K, Iterable<B>> groupMap(Function1<Logger, K> key, Function1<Logger, B> f) {
        return IterableOps.groupMap$((IterableOps)this, key, f);
    }

    public <K, B> scala.collection.immutable.Map<K, B> groupMapReduce(Function1<Logger, K> key, Function1<Logger, B> f, Function2<B, B, B> reduce) {
        return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
    }

    public Object scan(Object z, Function2 op) {
        return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
    }

    public Object scanLeft(Object z, Function2 op) {
        return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
    }

    public Object scanRight(Object z, Function2 op) {
        return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
    }

    public Object map(Function1 f) {
        return IterableOps.map$((IterableOps)this, (Function1)f);
    }

    public Object flatMap(Function1 f) {
        return IterableOps.flatMap$((IterableOps)this, (Function1)f);
    }

    public Object flatten(Function1 asIterable) {
        return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
    }

    public Object collect(PartialFunction pf) {
        return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
    }

    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<Logger, Either<A1, A2>> f) {
        return IterableOps.partitionMap$((IterableOps)this, f);
    }

    public Object concat(IterableOnce suffix) {
        return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
    }

    public final Object $plus$plus(IterableOnce suffix) {
        return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
    }

    public Object zip(IterableOnce that) {
        return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
    }

    public Object zipWithIndex() {
        return IterableOps.zipWithIndex$((IterableOps)this);
    }

    public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
        return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
    }

    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Logger, Tuple2<A1, A2>> asPair) {
        return IterableOps.unzip$((IterableOps)this, asPair);
    }

    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Logger, Tuple3<A1, A2, A3>> asTriple) {
        return IterableOps.unzip3$((IterableOps)this, asTriple);
    }

    public Iterator<Iterable<Logger>> tails() {
        return IterableOps.tails$((IterableOps)this);
    }

    public Iterator<Iterable<Logger>> inits() {
        return IterableOps.inits$((IterableOps)this);
    }

    public Object tapEach(Function1 f) {
        return IterableOps.tapEach$((IterableOps)this, (Function1)f);
    }

    public Object $plus$plus$colon(IterableOnce that) {
        return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
    }

    public boolean hasDefiniteSize() {
        return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
    }

    public <U> void foreach(Function1<Logger, U> f) {
        IterableOnceOps.foreach$((IterableOnceOps)this, f);
    }

    public boolean forall(Function1<Logger, Object> p) {
        return IterableOnceOps.forall$((IterableOnceOps)this, p);
    }

    public boolean exists(Function1<Logger, Object> p) {
        return IterableOnceOps.exists$((IterableOnceOps)this, p);
    }

    public int count(Function1<Logger, Object> p) {
        return IterableOnceOps.count$((IterableOnceOps)this, p);
    }

    public Option<Logger> find(Function1<Logger, Object> p) {
        return IterableOnceOps.find$((IterableOnceOps)this, p);
    }

    public <B> B foldLeft(B z, Function2<B, Logger, B> op) {
        return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
    }

    public <B> B foldRight(B z, Function2<Logger, B, B> op) {
        return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
    }

    public final <B> B $div$colon(B z, Function2<B, Logger, B> op) {
        return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
    }

    public final <B> B $colon$bslash(B z, Function2<Logger, B, B> op) {
        return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
    }

    public <B> B reduce(Function2<B, B, B> op) {
        return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
        return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
    }

    public <B> B reduceLeft(Function2<B, Logger, B> op) {
        return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
    }

    public <B> B reduceRight(Function2<Logger, B, B> op) {
        return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, Logger, B> op) {
        return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<Logger, B, B> op) {
        return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
    }

    public boolean isEmpty() {
        return IterableOnceOps.isEmpty$((IterableOnceOps)this);
    }

    public boolean nonEmpty() {
        return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
    }

    public int size() {
        return IterableOnceOps.size$((IterableOnceOps)this);
    }

    public final <B> void copyToBuffer(Buffer<B> dest) {
        IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
    }

    public <B> int copyToArray(Object xs) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
    }

    public <B> int copyToArray(Object xs, int start) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
    }

    public <B> int copyToArray(Object xs, int start, int len) {
        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
    }

    public Object min(Ordering ord) {
        return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
    }

    public <B> Option<Logger> minOption(Ordering<B> ord) {
        return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
    }

    public Object max(Ordering ord) {
        return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
    }

    public <B> Option<Logger> maxOption(Ordering<B> ord) {
        return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
    }

    public <B> Option<Logger> maxByOption(Function1<Logger, B> f, Ordering<B> cmp) {
        return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
    }

    public <B> Option<Logger> minByOption(Function1<Logger, B> f, Ordering<B> cmp) {
        return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
    }

    public <B> Option<B> collectFirst(PartialFunction<Logger, B> pf) {
        return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, Logger, B> seqop, Function2<B, B, B> combop) {
        return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
    }

    public <B> boolean corresponds(IterableOnce<B> that, Function2<Logger, B, Object> p) {
        return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
    }

    public final String mkString(String start, String sep, String end) {
        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
    }

    public final String mkString(String sep) {
        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
    }

    public final String mkString() {
        return IterableOnceOps.mkString$((IterableOnceOps)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public final StringBuilder addString(StringBuilder b, String sep) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
    }

    public final StringBuilder addString(StringBuilder b) {
        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
    }

    public <C1> C1 to(Factory<Logger, C1> factory) {
        return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
    }

    public final Iterator<Logger> toIterator() {
        return IterableOnceOps.toIterator$((IterableOnceOps)this);
    }

    public List<Logger> toList() {
        return IterableOnceOps.toList$((IterableOnceOps)this);
    }

    public Vector<Logger> toVector() {
        return IterableOnceOps.toVector$((IterableOnceOps)this);
    }

    public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<Logger, Tuple2<K, V>> ev) {
        return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
    }

    public <B> Set<B> toSet() {
        return IterableOnceOps.toSet$((IterableOnceOps)this);
    }

    public Seq<Logger> toSeq() {
        return IterableOnceOps.toSeq$((IterableOnceOps)this);
    }

    public IndexedSeq<Logger> toIndexedSeq() {
        return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
    }

    public final Stream<Logger> toStream() {
        return IterableOnceOps.toStream$((IterableOnceOps)this);
    }

    public final <B> Buffer<B> toBuffer() {
        return IterableOnceOps.toBuffer$((IterableOnceOps)this);
    }

    public <B> Object toArray(ClassTag<B> evidence$2) {
        return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
    }

    public Iterable<Logger> reversed() {
        return IterableOnceOps.reversed$((IterableOnceOps)this);
    }

    public <S extends Stepper<?>> S stepper(StepperShape<Logger, S> shape) {
        return (S)IterableOnce.stepper$((IterableOnce)this, shape);
    }

    public int knownSize() {
        return IterableOnce.knownSize$((IterableOnce)this);
    }

    public Logger root() {
        return root;
    }

    public Level$OFF$ OFF() {
        return Level$OFF$.MODULE$;
    }

    public Level$FATAL$ FATAL() {
        return Level$FATAL$.MODULE$;
    }

    public Level$CRITICAL$ CRITICAL() {
        return Level$CRITICAL$.MODULE$;
    }

    public Level$ERROR$ ERROR() {
        return Level$ERROR$.MODULE$;
    }

    public Level$WARNING$ WARNING() {
        return Level$WARNING$.MODULE$;
    }

    public Level$INFO$ INFO() {
        return Level$INFO$.MODULE$;
    }

    public Level$DEBUG$ DEBUG() {
        return Level$DEBUG$.MODULE$;
    }

    public Level$TRACE$ TRACE() {
        return Level$TRACE$.MODULE$;
    }

    public Level$ALL$ ALL() {
        return Level$ALL$.MODULE$;
    }

    public Map<Object, Level> levels() {
        return levelsMap;
    }

    public Map<String, Level> levelNames() {
        return levelNamesMap;
    }

    public void reset() {
        this.clearHandlers();
        loggersCache.clear();
        this.root().addHandler(new ConsoleHandler(new Formatter(Formatter$.MODULE$.$lessinit$greater$default$1(), Formatter$.MODULE$.$lessinit$greater$default$2(), Formatter$.MODULE$.$lessinit$greater$default$3(), Formatter$.MODULE$.$lessinit$greater$default$4(), Formatter$.MODULE$.$lessinit$greater$default$5()), (Option<Level>)None$.MODULE$));
    }

    public void clearHandlers() {
        this.foreach((Function1 & Serializable)logger -> {
            Logger$.$anonfun$clearHandlers$2(logger);
            return BoxedUnit.UNIT;
        });
    }

    public void withLoggers(List<Function0<Logger>> loggerFactories, Function0<BoxedUnit> f) {
        this.withLazyLoggers((Function0<List<Logger>>)(Function0 & Serializable)() -> loggerFactories.map((Function1 & Serializable)x$3 -> (Logger)x$3.apply()), f);
    }

    public void withLazyLoggers(Function0<List<Logger>> loggers, Function0<BoxedUnit> f) {
        List<Function0<Logger>> localLoggerFactoryCache = loggerFactoryCache;
        this.clearHandlers();
        loggers.apply();
        f.apply$mcV$sp();
        this.reset();
        loggerFactoryCache = localLoggerFactoryCache;
        loggerFactoryCache.foreach((Function1 & Serializable)x$4 -> (Logger)x$4.apply());
    }

    public Logger get(String name) {
        Logger logger;
        Logger logger2 = loggersCache.get(name);
        if (logger2 != null) {
            Logger logger3;
            logger = logger3 = logger2;
        } else if (logger2 == null) {
            Logger logger4 = new Logger(name, java.util.logging.Logger.getLogger(name));
            Logger oldLogger = loggersCache.putIfAbsent(name, logger4);
            logger = oldLogger != null ? oldLogger : logger4;
        } else {
            throw new MatchError((Object)logger2);
        }
        return logger;
    }

    public Logger apply(String name) {
        return this.get(name);
    }

    private Logger get(int depth) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        return st.length >= depth ? this.getForClassName(st[depth].getClassName()) : this.getForClassName("stackTraceIsAbsent");
    }

    public Logger get() {
        return this.get(2);
    }

    public Logger apply() {
        return this.get(2);
    }

    private Logger getForClassName(String className) {
        return className.endsWith("$") ? this.get(className.substring(0, className.length() - 1)) : this.get(className);
    }

    public Logger get(Class<?> cls) {
        return this.getForClassName(cls.getName());
    }

    public Logger apply(Class<?> cls) {
        return this.get(cls);
    }

    public Iterator<Logger> iterator() {
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(loggersCache.values().iterator()).asScala();
    }

    public void configure(List<Function0<Logger>> loggerFactories) {
        loggerFactoryCache = loggerFactories;
        this.clearHandlers();
        loggerFactories.foreach((Function1 & Serializable)x$5 -> (Logger)x$5.apply());
    }

    public static final /* synthetic */ void $anonfun$clearHandlers$2(Logger logger) {
        logger.clearHandlers();
        logger.setLevel(null);
    }

    private Logger$() {
    }
}

