/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.sun.management.UnixOperatingSystemMXBean;
import com.twitter.conversions.StringOps;
import com.twitter.conversions.StringOps$;
import com.twitter.finagle.stats.Bytes$;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.MetricBuilder;
import com.twitter.finagle.stats.MetricUnit;
import com.twitter.finagle.stats.Milliseconds$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.exp.Expression$;
import com.twitter.finagle.stats.exp.ExpressionSchema$;
import com.twitter.jvm.Allocations;
import com.twitter.jvm.Jvm;
import com.twitter.jvm.Jvm$;
import java.io.Serializable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class JvmStats$
implements Serializable {
    private static final Set<Object> gauges;
    private static volatile Allocations allocations;
    public static final JvmStats$ MODULE$;

    private JvmStats$() {
    }

    static {
        MODULE$ = new JvmStats$();
        gauges = (Set)Set$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JvmStats$.class);
    }

    public void register(StatsReceiver statsReceiver) {
        Object object;
        BoxedUnit boxedUnit;
        StatsReceiver stats = statsReceiver.scope("jvm");
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        StatsReceiver heapStats = stats.scope("heap");
        Gauge heapUsedGauge = heapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), () -> this.$anonfun$1(mem));
        gauges.add((Object)heapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"committed"}), () -> this.register$$anonfun$1(mem)));
        gauges.add((Object)heapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max"}), () -> this.register$$anonfun$2(mem)));
        gauges.add((Object)heapUsedGauge);
        StatsReceiver nonHeapStats = stats.scope("nonheap");
        gauges.add((Object)nonHeapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"committed"}), () -> this.register$$anonfun$3(mem)));
        gauges.add((Object)nonHeapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max"}), () -> this.register$$anonfun$4(mem)));
        gauges.add((Object)nonHeapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), () -> this.register$$anonfun$5(mem)));
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        StatsReceiver threadStats = stats.scope("thread");
        gauges.add((Object)threadStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"daemon_count"}), () -> this.register$$anonfun$6(threads)));
        gauges.add((Object)threadStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"count"}), () -> this.register$$anonfun$7(threads)));
        gauges.add((Object)threadStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"peak_count"}), () -> this.register$$anonfun$8(threads)));
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        Gauge uptime = stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"uptime"}), () -> this.$anonfun$2(runtime));
        gauges.add((Object)uptime);
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"start_time"}), () -> this.register$$anonfun$9(runtime)));
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spec_version"}), () -> this.register$$anonfun$10(runtime)));
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"num_cpus"}), () -> this.register$$anonfun$11(os)));
        OperatingSystemMXBean operatingSystemMXBean = os;
        if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)operatingSystemMXBean;
            Gauge fileDescriptorCountGauge = stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fd_count"}), () -> this.$anonfun$3(unix));
            gauges.add((Object)fileDescriptorCountGauge);
            gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fd_limit"}), () -> this.register$$anonfun$12(unix)));
            boxedUnit = ExpressionSchema$.MODULE$.apply("file_descriptors", Expression$.MODULE$.apply(fileDescriptorCountGauge.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withDescription("Total file descriptors used by the service. If it continuously increasing over time, then potentially files or connections aren't being closed").build();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        StatsReceiver compilerStats = stats.scope("compiler");
        gauges.add((Object)compilerStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"graal"}), this::register$$anonfun$13));
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            object = BoxedUnit.UNIT;
        } else {
            CompilationMXBean compilation = compilationMXBean;
            StatsReceiver compilationStats = stats.scope("compilation");
            object = BoxesRunTime.boxToBoolean((boolean)gauges.add((Object)compilationStats.addGauge(compilationStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time_msec"})), () -> this.register$$anonfun$14(compilation))));
        }
        ClassLoadingMXBean classes = ManagementFactory.getClassLoadingMXBean();
        StatsReceiver classLoadingStats = stats.scope("classes");
        gauges.add((Object)classLoadingStats.addGauge(classLoadingStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total_loaded"})), () -> this.register$$anonfun$15(classes)));
        gauges.add((Object)classLoadingStats.addGauge(classLoadingStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total_unloaded"})), () -> this.register$$anonfun$16(classes)));
        gauges.add((Object)classLoadingStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"current_loaded"}), () -> this.register$$anonfun$17(classes)));
        Buffer memPool = CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getMemoryPoolMXBeans()).asScala();
        StatsReceiver memStats = stats.scope("mem");
        StatsReceiver currentMem = memStats.scope("current");
        StatsReceiver postGCStats = memStats.scope("postGC");
        memPool.foreach((Function1)(JProcedure1 & Serializable)pool -> {
            String name = StringOps.RichString$.MODULE$.regexSub$extension(StringOps$.MODULE$.RichString(pool.getName()), scala.collection.StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^\\w]")), (Function1 & Serializable)m -> "_");
            if (pool.getCollectionUsage() != null) {
                gauges.add((Object)postGCStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), () -> this.register$$anonfun$30$$anonfun$1(pool)));
            }
            if (pool.getUsage() != null) {
                Gauge usageGauge = currentMem.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), () -> this.$anonfun$7(pool));
                gauges.add((Object)usageGauge);
                gauges.add((Object)currentMem.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "max"}), () -> this.register$$anonfun$31$$anonfun$2(pool)));
                ExpressionSchema$.MODULE$.apply("memory_pool", Expression$.MODULE$.apply(usageGauge.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withLabel("kind", name).withUnit((MetricUnit)Bytes$.MODULE$).withDescription("The current estimate of the amount of space within the " + name + " memory pool holding allocated objects in bytes").build();
            }
        });
        gauges.add((Object)postGCStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), () -> this.register$$anonfun$19(memPool)));
        gauges.add((Object)currentMem.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), () -> this.register$$anonfun$20(memPool)));
        Jvm jvm = Jvm$.MODULE$.apply();
        jvm.metaspaceUsage().foreach((Function1 & Serializable)usage -> gauges.add((Object)memStats.scope("metaspace").addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max_capacity"}), () -> this.register$$anonfun$36$$anonfun$1(usage))));
        StatsReceiver spStats = stats.scope("safepoint");
        gauges.add((Object)spStats.addGauge(spStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sync_time_millis"})), () -> this.register$$anonfun$22(jvm)));
        gauges.add((Object)spStats.addGauge(spStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total_time_millis"})), () -> this.register$$anonfun$23(jvm)));
        gauges.add((Object)spStats.addGauge(spStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"count"})), () -> this.register$$anonfun$24(jvm)));
        List<BufferPoolMXBean> list = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        if (list != null) {
            List<BufferPoolMXBean> jBufferPool = list;
            StatsReceiver bufferPoolStats = memStats.scope("buffer");
            CollectionConverters$.MODULE$.ListHasAsScala(jBufferPool).asScala().foreach((Function1 & Serializable)bp -> {
                String name = bp.getName();
                gauges.add((Object)bufferPoolStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "count"}), () -> this.register$$anonfun$37$$anonfun$1(bp)));
                gauges.add((Object)bufferPoolStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), () -> this.register$$anonfun$38$$anonfun$2(bp)));
                return gauges.add((Object)bufferPoolStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "max"}), () -> this.register$$anonfun$39$$anonfun$3(bp)));
            });
        }
        Buffer gcPool = CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        StatsReceiver gcStats = stats.scope("gc");
        gcPool.foreach((Function1 & Serializable)gc -> {
            String name = StringOps.RichString$.MODULE$.regexSub$extension(StringOps$.MODULE$.RichString(gc.getName()), scala.collection.StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^\\w]")), (Function1 & Serializable)m -> "_");
            Gauge poolCycles = gcStats.addGauge(gcStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "cycles"})), () -> this.$anonfun$9(gc));
            Gauge poolMsec = gcStats.addGauge(gcStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "msec"})), () -> this.$anonfun$10(gc));
            ExpressionSchema$.MODULE$.apply("gc_cycles", Expression$.MODULE$.apply(poolCycles.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withLabel("gc_pool", name).withDescription("The total number of collections that have occurred for the " + name + " gc pool").build();
            ExpressionSchema$.MODULE$.apply("gc_latency", Expression$.MODULE$.apply(poolMsec.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withLabel("gc_pool", name).withUnit((MetricUnit)Milliseconds$.MODULE$).withDescription("The total elapsed time spent doing collections for the " + name + " gc pool in milliseconds").build();
            gauges.add((Object)poolCycles);
            return gauges.add((Object)poolMsec);
        });
        Gauge cycles = gcStats.addGauge(gcStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cycles"})), () -> this.$anonfun$4(gcPool));
        Gauge msec = gcStats.addGauge(gcStats.metricBuilder((MetricBuilder.MetricType)MetricBuilder.GaugeType$.MODULE$).withCounterishGauge().withName((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"msec"})), () -> this.$anonfun$5(gcPool));
        gauges.add((Object)cycles);
        gauges.add((Object)msec);
        allocations = new Allocations(gcStats);
        allocations.start();
        if (allocations.trackingEden()) {
            StatsReceiver allocationStats = memStats.scope("allocations");
            StatsReceiver eden = allocationStats.scope("eden");
            gauges.add((Object)eden.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bytes"}), this::register$$anonfun$27));
        }
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application_time_millis"}), () -> this.register$$anonfun$28(jvm)));
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tenuring_threshold"}), () -> this.register$$anonfun$29(jvm)));
        ExpressionSchema$.MODULE$.apply("jvm_uptime", Expression$.MODULE$.apply(uptime.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withUnit((MetricUnit)Milliseconds$.MODULE$).withDescription("The uptime of the JVM in milliseconds").build();
        ExpressionSchema$.MODULE$.apply("gc_cycles", Expression$.MODULE$.apply(cycles.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withDescription("The total number of collections that have occurred").build();
        ExpressionSchema$.MODULE$.apply("gc_latency", Expression$.MODULE$.apply(msec.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withUnit((MetricUnit)Milliseconds$.MODULE$).withDescription("The total elapsed time spent doing collections in milliseconds").build();
        ExpressionSchema$.MODULE$.apply("memory_pool", Expression$.MODULE$.apply(heapUsedGauge.metadata(), Expression$.MODULE$.apply$default$2())).withLabel(ExpressionSchema$.MODULE$.Role(), "jvm").withLabel("kind", "Heap").withUnit((MetricUnit)Bytes$.MODULE$).withDescription("Heap in use in bytes").build();
    }

    private final MemoryUsage heap$1(MemoryMXBean mem$1) {
        return mem$1.getHeapMemoryUsage();
    }

    private final float $anonfun$1(MemoryMXBean mem$3) {
        return this.heap$1(mem$3).getUsed();
    }

    private final float register$$anonfun$1(MemoryMXBean mem$4) {
        return this.heap$1(mem$4).getCommitted();
    }

    private final float register$$anonfun$2(MemoryMXBean mem$5) {
        return this.heap$1(mem$5).getMax();
    }

    private final MemoryUsage nonHeap$1(MemoryMXBean mem$2) {
        return mem$2.getNonHeapMemoryUsage();
    }

    private final float register$$anonfun$3(MemoryMXBean mem$6) {
        return this.nonHeap$1(mem$6).getCommitted();
    }

    private final float register$$anonfun$4(MemoryMXBean mem$7) {
        return this.nonHeap$1(mem$7).getMax();
    }

    private final float register$$anonfun$5(MemoryMXBean mem$8) {
        return this.nonHeap$1(mem$8).getUsed();
    }

    private final float register$$anonfun$6(ThreadMXBean threads$1) {
        return threads$1.getDaemonThreadCount();
    }

    private final float register$$anonfun$7(ThreadMXBean threads$2) {
        return threads$2.getThreadCount();
    }

    private final float register$$anonfun$8(ThreadMXBean threads$3) {
        return threads$3.getPeakThreadCount();
    }

    private final float $anonfun$2(RuntimeMXBean runtime$1) {
        return runtime$1.getUptime();
    }

    private final float register$$anonfun$9(RuntimeMXBean runtime$2) {
        return runtime$2.getStartTime();
    }

    private final float register$$anonfun$10(RuntimeMXBean runtime$3) {
        return scala.collection.StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(runtime$3.getSpecVersion()));
    }

    private final float register$$anonfun$11(OperatingSystemMXBean os$1) {
        return os$1.getAvailableProcessors();
    }

    private final float $anonfun$3(UnixOperatingSystemMXBean unix$1) {
        return unix$1.getOpenFileDescriptorCount();
    }

    private final float register$$anonfun$12(UnixOperatingSystemMXBean unix$2) {
        return unix$2.getMaxFileDescriptorCount();
    }

    private final float register$$anonfun$13() {
        String string = System.getProperty("jvmci.Compiler");
        return "graal".equals(string) ? 1.0f : 0.0f;
    }

    private final float register$$anonfun$14(CompilationMXBean compilation$1) {
        return compilation$1.getTotalCompilationTime();
    }

    private final float register$$anonfun$15(ClassLoadingMXBean classes$1) {
        return classes$1.getTotalLoadedClassCount();
    }

    private final float register$$anonfun$16(ClassLoadingMXBean classes$2) {
        return classes$2.getUnloadedClassCount();
    }

    private final float register$$anonfun$17(ClassLoadingMXBean classes$3) {
        return classes$3.getLoadedClassCount();
    }

    private final MemoryUsage usage$1(MemoryPoolMXBean pool$1) {
        return pool$1.getCollectionUsage();
    }

    private final float register$$anonfun$30$$anonfun$1(MemoryPoolMXBean pool$3) {
        return this.usage$1(pool$3).getUsed();
    }

    private final MemoryUsage usage$2(MemoryPoolMXBean pool$2) {
        return pool$2.getUsage();
    }

    private final float $anonfun$7(MemoryPoolMXBean pool$4) {
        return this.usage$2(pool$4).getUsed();
    }

    private final float register$$anonfun$31$$anonfun$2(MemoryPoolMXBean pool$5) {
        return this.usage$2(pool$5).getMax();
    }

    private final float register$$anonfun$19(Buffer memPool$1) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)memPool$1.flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)p.getCollectionUsage()))).map((Function1 & Serializable)_$2 -> _$2.getUsed())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private final float register$$anonfun$20(Buffer memPool$2) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)memPool$2.flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)p.getUsage()))).map((Function1 & Serializable)_$3 -> _$3.getUsed())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private final float register$$anonfun$36$$anonfun$1(Jvm.MetaspaceUsage usage$1) {
        return usage$1.maxCapacity().inBytes();
    }

    private final float register$$anonfun$22(Jvm jvm$1) {
        return jvm$1.safepoint().syncTimeMillis();
    }

    private final float register$$anonfun$23(Jvm jvm$2) {
        return jvm$2.safepoint().totalTimeMillis();
    }

    private final float register$$anonfun$24(Jvm jvm$3) {
        return jvm$3.safepoint().count();
    }

    private final float register$$anonfun$37$$anonfun$1(BufferPoolMXBean bp$1) {
        return bp$1.getCount();
    }

    private final float register$$anonfun$38$$anonfun$2(BufferPoolMXBean bp$2) {
        return bp$2.getMemoryUsed();
    }

    private final float register$$anonfun$39$$anonfun$3(BufferPoolMXBean bp$3) {
        return bp$3.getTotalCapacity();
    }

    private final float $anonfun$9(GarbageCollectorMXBean gc$1) {
        return gc$1.getCollectionCount();
    }

    private final float $anonfun$10(GarbageCollectorMXBean gc$2) {
        return gc$2.getCollectionTime();
    }

    private final float $anonfun$4(Buffer gcPool$1) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)gcPool$1.map((Function1 & Serializable)_$4 -> _$4.getCollectionCount())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)_$5 -> _$5 > 0L)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private final float $anonfun$5(Buffer gcPool$2) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)gcPool$2.map((Function1 & Serializable)_$6 -> _$6.getCollectionTime())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)_$7 -> _$7 > 0L)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private final float register$$anonfun$27() {
        return allocations.eden();
    }

    private final float register$$anonfun$28(Jvm jvm$4) {
        return (float)jvm$4.applicationTime() / (float)1000000;
    }

    private final float register$$anonfun$29(Jvm jvm$5) {
        return jvm$5.tenuringThreshold();
    }
}

