/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.conversions.DurationOps;
import com.twitter.conversions.DurationOps$;
import com.twitter.jvm.Estimator;
import com.twitter.jvm.Pool;
import com.twitter.jvm.PoolState;
import com.twitter.jvm.PoolState$;
import com.twitter.util.Duration;
import com.twitter.util.StorageUnit;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.Timer;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public class GcPredictor {
    private final Pool pool;
    private final Duration period;
    private final Timer timer;
    private final Estimator<Object> estimator;

    public GcPredictor(Pool pool, Duration period, Timer timer, Estimator<Object> estimator) {
        this.pool = pool;
        this.period = period;
        this.timer = timer;
        this.estimator = estimator;
        this.loop();
    }

    private void loop() {
        this.pool.estimateAllocRate(this.period, this.timer).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)bps -> {
            GcPredictor gcPredictor = this;
            synchronized (gcPredictor) {
                this.estimator.measure(BoxesRunTime.boxToDouble((double)bps));
            }
            this.loop();
        });
    }

    public Time nextGcEstimate() {
        Time time;
        double d;
        GcPredictor gcPredictor = this;
        synchronized (gcPredictor) {
            d = BoxesRunTime.unboxToDouble((Object)this.estimator.estimate());
        }
        long e = (long)d;
        if (e == 0L) {
            time = Time$.MODULE$.Top();
        } else {
            PoolState poolState = this.pool.state();
            if (poolState == null) {
                throw new MatchError((Object)poolState);
            }
            PoolState poolState2 = PoolState$.MODULE$.unapply(poolState);
            long l = poolState2._1();
            StorageUnit storageUnit = poolState2._2();
            StorageUnit storageUnit2 = poolState2._3();
            StorageUnit capacity = storageUnit;
            StorageUnit used = storageUnit2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)capacity, (Object)used);
            StorageUnit capacity2 = (StorageUnit)tuple2._1();
            StorageUnit used2 = (StorageUnit)tuple2._2();
            long r = capacity2.$minus(used2).inBytes();
            time = (Time)Time$.MODULE$.now().$plus(DurationOps.RichDuration$.MODULE$.milliseconds$extension(DurationOps$.MODULE$.RichDuration(1000L * r / e)));
        }
        return time;
    }
}

