/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.jvm.Heapster$;
import com.twitter.util.Duration;
import java.lang.reflect.Method;
import scala.Option;
import scala.Predef$;

public class Heapster {
    private final Method startM;
    private final Method stopM;
    private final Method dumpProfileM;
    private final Method clearProfileM;
    private final Method setSamplingPeriodM;

    public static Option<Heapster> instance() {
        return Heapster$.MODULE$.instance();
    }

    public Heapster(Class<?> klass) {
        this.startM = klass.getDeclaredMethod("start", new Class[0]);
        this.stopM = klass.getDeclaredMethod("stop", new Class[0]);
        this.dumpProfileM = klass.getDeclaredMethod("dumpProfile", Boolean.class);
        this.clearProfileM = klass.getDeclaredMethod("clearProfile", new Class[0]);
        this.setSamplingPeriodM = klass.getDeclaredMethod("setSamplingPeriod", Integer.class);
    }

    public void start() {
        this.startM.invoke(null, new Object[0]);
    }

    public void shutdown() {
        this.stopM.invoke(null, new Object[0]);
    }

    public void setSamplingPeriod(Integer period) {
        this.setSamplingPeriodM.invoke(null, period);
    }

    public void clearProfile() {
        this.clearProfileM.invoke(null, new Object[0]);
    }

    public byte[] dumpProfile(Boolean forceGC) {
        return (byte[])this.dumpProfileM.invoke(null, forceGC);
    }

    public byte[] profile(Duration howlong, int samplingPeriod, boolean forceGC) {
        this.clearProfile();
        this.setSamplingPeriod(Predef$.MODULE$.int2Integer(samplingPeriod));
        this.start();
        Thread.sleep(howlong.inMilliseconds());
        this.shutdown();
        return this.dumpProfile(Predef$.MODULE$.boolean2Boolean(forceGC));
    }

    public int profile$default$2() {
        return 0x500000;
    }

    public boolean profile$default$3() {
        return true;
    }
}

