/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.jvm.Allocations$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class Allocations {
    private final Option<MemoryPoolMXBean> edenPool = CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getMemoryPoolMXBeans()).asScala().find((Function1 & Serializable)bean -> {
        String string = bean.getName();
        String string2 = "Par Eden Space";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = bean.getName();
        String string4 = "PS Eden Space";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    });
    public final AtomicLong com$twitter$jvm$Allocations$$edenSizeAfterLastGc = new AtomicLong();
    public final AtomicLong com$twitter$jvm$Allocations$$edenAllocated = new AtomicLong();
    private final LinkedBlockingQueue<Tuple2<NotificationEmitter, NotificationListener>> beanAndListeners = new LinkedBlockingQueue();
    public final Stat com$twitter$jvm$Allocations$$edenGcPauses;

    public static long Unknown() {
        return Allocations$.MODULE$.Unknown();
    }

    public Allocations(StatsReceiver statsReceiver) {
        this.com$twitter$jvm$Allocations$$edenGcPauses = statsReceiver.scope("eden").stat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pause_msec"}));
    }

    public void start() {
        this.edenPool.flatMap((Function1 & Serializable)bean -> Option$.MODULE$.apply((Object)bean.getUsage())).foreach((Function1)(JProcedure1 & Serializable)_$1 -> CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getGarbageCollectorMXBeans()).asScala().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            block1: {
                GarbageCollectorMXBean garbageCollectorMXBean = x$1;
                if (!(garbageCollectorMXBean instanceof NotificationEmitter)) break block1;
                GarbageCollectorMXBean bean = (GarbageCollectorMXBean)((Object)((NotificationEmitter)((Object)garbageCollectorMXBean)));
                String string = bean.getName();
                String string2 = "ConcurrentMarkSweep";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    NotificationListener listener = this.newEdenGcListener();
                    this.beanAndListeners.add((Tuple2<NotificationEmitter, NotificationListener>)Tuple2$.MODULE$.apply((Object)bean, (Object)listener));
                    ((NotificationBroadcaster)((Object)bean)).addNotificationListener(listener, null, null);
                }
            }
        }));
    }

    public void stop() {
        while (!this.beanAndListeners.isEmpty()) {
            Option$.MODULE$.apply(this.beanAndListeners.poll()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                NotificationEmitter bean = (NotificationEmitter)tuple2._1();
                NotificationListener listener = (NotificationListener)tuple2._2();
                Allocations.liftedTree1$1(bean, listener);
            });
        }
    }

    public boolean trackingEden() {
        return !this.beanAndListeners.isEmpty();
    }

    public long eden() {
        long l;
        if (!this.trackingEden()) {
            return Allocations$.MODULE$.Unknown();
        }
        Option<MemoryPoolMXBean> option = this.edenPool;
        if (None$.MODULE$.equals(option)) {
            l = Allocations$.MODULE$.Unknown();
        } else if (option instanceof Some) {
            MemoryPoolMXBean pool = (MemoryPoolMXBean)((Some)option).value();
            MemoryUsage usage = pool.getUsage();
            if (usage == null) {
                l = Allocations$.MODULE$.Unknown();
            } else {
                long usedSinceLastGc = package$.MODULE$.max(0L, usage.getUsed() - this.com$twitter$jvm$Allocations$$edenSizeAfterLastGc.get());
                l = usedSinceLastGc + this.com$twitter$jvm$Allocations$$edenAllocated.get();
            }
        } else {
            throw new MatchError(option);
        }
        return l;
    }

    private NotificationListener newEdenGcListener() {
        return new NotificationListener(this){
            private final Allocations $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Option edenMemoryUsageFrom(Object any) {
                if (!(any instanceof TabularData)) {
                    return None$.MODULE$;
                }
                TabularData tabData = (TabularData)any;
                Set edenKeys = (Set)CollectionConverters$.MODULE$.SetHasAsScala(tabData.keySet()).asScala().collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Object x) {
                        List ks;
                        Object object = x;
                        return object instanceof List && CollectionConverters$.MODULE$.ListHasAsScala(ks = (List)object).asScala().headOption().exists(Allocations::com$twitter$jvm$Allocations$$anon$2$$_$isDefinedAt$$anonfun$1);
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        List ks;
                        Object object = x;
                        return object instanceof List && CollectionConverters$.MODULE$.ListHasAsScala(ks = (List)object).asScala().headOption().exists(Allocations::com$twitter$jvm$Allocations$$anon$2$$_$applyOrElse$$anonfun$1) ? ks : function1.apply(x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$twitter$jvm$Allocations$$anon$2$$_$isDefinedAt$$anonfun$1(java.lang.Object ), com$twitter$jvm$Allocations$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.Object )}, serializedLambda);
                    }
                });
                Set memoryUsages = (Set)edenKeys.flatMap(arg_0 -> Allocations.com$twitter$jvm$Allocations$$anon$1$$_$_$$anonfun$1(tabData, arg_0));
                return memoryUsages.headOption();
            }

            public void handleNotification(Notification notification, Object handback) {
                Object object;
                CompositeData cd;
                Object object2 = notification.getUserData();
                if (!(object2 instanceof CompositeData) || !(cd = (CompositeData)object2).containsKey("gcInfo")) {
                    return;
                }
                CompositeData userData = cd;
                Object object3 = userData.get("gcInfo");
                if (!(object3 instanceof CompositeData)) {
                    return;
                }
                CompositeData cd2 = (CompositeData)object3;
                CompositeData gcInfo = cd2;
                if (gcInfo.containsKey("duration") && (object = gcInfo.get("duration")) instanceof Long) {
                    Long duration = (Long)object;
                    this.$outer.com$twitter$jvm$Allocations$$edenGcPauses.add(duration.floatValue());
                }
                if (!gcInfo.containsKey("memoryUsageBeforeGc") || !gcInfo.containsKey("memoryUsageAfterGc")) {
                    return;
                }
                this.edenMemoryUsageFrom(gcInfo.get("memoryUsageBeforeGc")).map(Allocations::com$twitter$jvm$Allocations$$anon$1$$_$handleNotification$$anonfun$1).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)beforeGc -> this.edenMemoryUsageFrom(gcInfo.get("memoryUsageAfterGc")).map(Allocations::com$twitter$jvm$Allocations$$anon$1$$_$handleNotification$$anonfun$2$$anonfun$1).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)afterGc -> {
                    this.$outer.com$twitter$jvm$Allocations$$edenAllocated.addAndGet(beforeGc - afterGc);
                    this.$outer.com$twitter$jvm$Allocations$$edenSizeAfterLastGc.set(afterGc);
                }));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$twitter$jvm$Allocations$$anon$1$$_$_$$anonfun$1(javax.management.openmbean.TabularData java.util.List ), com$twitter$jvm$Allocations$$anon$1$$_$handleNotification$$anonfun$1(java.lang.management.MemoryUsage ), handleNotification$$anonfun$1(javax.management.openmbean.CompositeData long ), com$twitter$jvm$Allocations$$anon$1$$_$handleNotification$$anonfun$2$$anonfun$1(java.lang.management.MemoryUsage ), handleNotification$$anonfun$2$$anonfun$1(long long )}, serializedLambda);
            }
        };
    }

    private static final void liftedTree1$1(NotificationEmitter bean$1, NotificationListener listener$1) {
        try {
            bean$1.removeNotificationListener(listener$1);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {}
    }

    public static final /* synthetic */ boolean com$twitter$jvm$Allocations$$anon$2$$_$isDefinedAt$$anonfun$1(Object x$1) {
        boolean bl;
        Object object = x$1;
        if (object instanceof String) {
            String s = (String)object;
            bl = s.contains("Eden");
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean com$twitter$jvm$Allocations$$anon$2$$_$applyOrElse$$anonfun$1(Object x$1) {
        boolean bl;
        Object object = x$1;
        if (object instanceof String) {
            String s = (String)object;
            bl = s.contains("Eden");
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ IterableOnce com$twitter$jvm$Allocations$$anon$1$$_$_$$anonfun$1(TabularData tabData$1, List k) {
        None$ none$;
        CompositeData cd;
        CompositeData compositeData = tabData$1.get(k.toArray());
        if (compositeData != null && (cd = compositeData).containsKey("value")) {
            Object object = cd.get("value");
            if (object instanceof CompositeData) {
                CompositeData vcd = (CompositeData)object;
                none$ = Some$.MODULE$.apply((Object)MemoryUsage.from(vcd));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ long com$twitter$jvm$Allocations$$anon$1$$_$handleNotification$$anonfun$1(MemoryUsage _$2) {
        return _$2.getUsed();
    }

    public static final /* synthetic */ long com$twitter$jvm$Allocations$$anon$1$$_$handleNotification$$anonfun$2$$anonfun$1(MemoryUsage _$3) {
        return _$3.getUsed();
    }
}

