/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.twitter.conversions.DurationOps;
import com.twitter.conversions.DurationOps$;
import com.twitter.jvm.CpuProfile;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class CpuProfile$
implements Serializable {
    public static final CpuProfile$ MODULE$ = new CpuProfile$();
    private static final Set<Tuple2<String, String>> IdleClassAndMethod = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"sun.nio.ch.EPollArrayWrapper", (Object)"epollWait"), new Tuple2((Object)"sun.nio.ch.KQueueArrayWrapper", (Object)"kevent0"), new Tuple2((Object)"java.net.SocketInputStream", (Object)"socketRead0"), new Tuple2((Object)"java.net.SocketOutputStream", (Object)"socketWrite0"), new Tuple2((Object)"java.net.PlainSocketImpl", (Object)"socketAvailable"), new Tuple2((Object)"java.net.PlainSocketImpl", (Object)"socketAccept")}));

    public boolean isRunnable(StackTraceElement stackElem) {
        return !IdleClassAndMethod.contains((Object)new Tuple2((Object)stackElem.getClassName(), (Object)stackElem.getMethodName()));
    }

    public CpuProfile record(Duration howlong, int frequency, Thread.State state) {
        Predef$.MODULE$.require(frequency < 1000);
        HashMap counts = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        Function0 elapsed = Stopwatch$.MODULE$.start();
        Time end = howlong.fromNow();
        Duration period = DurationOps.RichDuration$.MODULE$.microseconds$extension(DurationOps$.MODULE$.RichDuration(1000000L / (long)frequency));
        long myId = Thread.currentThread().getId();
        Time next = Time$.MODULE$.now();
        int n = 0;
        int nmissed = 0;
        while (Time$.MODULE$.now().$less((Object)end)) {
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])bean.dumpAllThreads(false, false)), (Function1 & Serializable)thread -> BoxesRunTime.boxToBoolean((boolean)CpuProfile$.$anonfun$record$1(state, myId, thread))).foreach((Function1 & Serializable)thread -> {
                CpuProfile$.$anonfun$record$2(state, counts, thread);
                return BoxedUnit.UNIT;
            });
            ++n;
            next = (Time)next.$plus(period);
            while (next.$less((Object)Time$.MODULE$.now()) && next.$less((Object)end)) {
                ++nmissed;
                next = (Time)next.$plus(period);
            }
            long sleep = package$.MODULE$.max(next.$minus(Time$.MODULE$.now()).inMilliseconds(), 0L);
            Thread.sleep(sleep);
        }
        return new CpuProfile((Map<Seq<StackTraceElement>, Object>)counts.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Duration)elapsed.apply(), n, nmissed);
    }

    public CpuProfile record(Duration howlong, int frequency) {
        return this.record(howlong, frequency, Thread.State.RUNNABLE);
    }

    public Future<CpuProfile> recordInThread(Duration howlong, int frequency, Thread.State state) {
        Promise p = new Promise();
        Thread thr = new Thread(p, howlong, frequency, state){
            private final Promise p$1;
            private final Duration howlong$1;
            private final int frequency$1;
            private final Thread.State state$2;

            public void run() {
                this.p$1.setValue((Object)CpuProfile$.MODULE$.record(this.howlong$1, this.frequency$1, this.state$2));
            }
            {
                this.p$1 = p$1;
                this.howlong$1 = howlong$1;
                this.frequency$1 = frequency$1;
                this.state$2 = state$2;
                super("CpuProfile");
            }
        };
        thr.start();
        return p;
    }

    public Future<CpuProfile> recordInThread(Duration howlong, int frequency) {
        return this.recordInThread(howlong, frequency, Thread.State.RUNNABLE);
    }

    public CpuProfile apply(Map<Seq<StackTraceElement>, Object> counts, Duration duration, int count, int missed) {
        return new CpuProfile(counts, duration, count, missed);
    }

    public Option<Tuple4<Map<Seq<StackTraceElement>, Object>, Duration, Object, Object>> unapply(CpuProfile x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4(x$0.counts(), (Object)x$0.duration(), (Object)BoxesRunTime.boxToInteger((int)x$0.count()), (Object)BoxesRunTime.boxToInteger((int)x$0.missed())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CpuProfile$.class);
    }

    public static final /* synthetic */ boolean $anonfun$record$1(Thread.State state$1, long myId$1, ThreadInfo thread) {
        Thread.State state = thread.getThreadState();
        Thread.State state2 = state$1;
        return !(state != null ? !((Object)((Object)state)).equals((Object)state2) : state2 != null) && thread.getThreadId() != myId$1;
    }

    public static final /* synthetic */ void $anonfun$record$2(Thread.State state$1, HashMap counts$1, ThreadInfo thread) {
        block1: {
            boolean include;
            Seq s = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])thread.getStackTrace()));
            if (!s.nonEmpty()) break block1;
            Thread.State state = state$1;
            Thread.State state2 = Thread.State.RUNNABLE;
            boolean bl = (state != null ? !((Object)((Object)state)).equals((Object)state2) : state2 != null) || MODULE$.isRunnable((StackTraceElement)s.head()) ? true : (include = false);
            if (include) {
                counts$1.update((Object)s, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)counts$1.getOrElse((Object)s, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) + 1L)));
            }
        }
    }

    private CpuProfile$() {
    }
}

