/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.jvm;

import com.sun.management.UnixOperatingSystemMXBean;
import com.twitter.conversions.StringOps;
import com.twitter.conversions.StringOps$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.jvm.Allocations;
import com.twitter.jvm.Jvm;
import com.twitter.jvm.Jvm$;
import java.io.Serializable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class JvmStats$ {
    public static final JvmStats$ MODULE$ = new JvmStats$();
    private static final Set<Object> gauges = (Set)Set$.MODULE$.empty();
    private static volatile Allocations allocations;

    public void register(StatsReceiver statsReceiver) {
        Object object;
        Object object2;
        Object object3;
        StatsReceiver stats = statsReceiver.scope("jvm");
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        StatsReceiver heapStats = stats.scope("heap");
        gauges.add((Object)heapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"committed"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.heap$1(mem).getCommitted()));
        gauges.add((Object)heapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.heap$1(mem).getMax()));
        gauges.add((Object)heapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.heap$1(mem).getUsed()));
        StatsReceiver nonHeapStats = stats.scope("nonheap");
        gauges.add((Object)nonHeapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"committed"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.nonHeap$1(mem).getCommitted()));
        gauges.add((Object)nonHeapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.nonHeap$1(mem).getMax()));
        gauges.add((Object)nonHeapStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.nonHeap$1(mem).getUsed()));
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        StatsReceiver threadStats = stats.scope("thread");
        gauges.add((Object)threadStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"daemon_count"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> threads.getDaemonThreadCount()));
        gauges.add((Object)threadStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"count"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> threads.getThreadCount()));
        gauges.add((Object)threadStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"peak_count"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> threads.getPeakThreadCount()));
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"start_time"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> runtime.getStartTime()));
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"uptime"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> runtime.getUptime()));
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"num_cpus"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> os.getAvailableProcessors()));
        OperatingSystemMXBean operatingSystemMXBean = os;
        if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixOperatingSystemMXBean = (UnixOperatingSystemMXBean)operatingSystemMXBean;
            gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fd_count"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> unixOperatingSystemMXBean.getOpenFileDescriptorCount()));
            object3 = BoxesRunTime.boxToBoolean((boolean)gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fd_limit"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> unixOperatingSystemMXBean.getMaxFileDescriptorCount())));
        } else {
            object3 = BoxedUnit.UNIT;
        }
        StatsReceiver compilerStats = stats.scope("compiler");
        gauges.add((Object)compilerStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"graal"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> {
            String string = System.getProperty("jvmci.Compiler");
            float f = "graal".equals(string) ? 1.0f : 0.0f;
            return f;
        }));
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            object2 = BoxedUnit.UNIT;
        } else {
            StatsReceiver compilationStats = stats.scope("compilation");
            object2 = BoxesRunTime.boxToBoolean((boolean)gauges.add((Object)compilationStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time_msec"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> compilationMXBean.getTotalCompilationTime())));
        }
        ClassLoadingMXBean classes = ManagementFactory.getClassLoadingMXBean();
        StatsReceiver classLoadingStats = stats.scope("classes");
        gauges.add((Object)classLoadingStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total_loaded"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> classes.getTotalLoadedClassCount()));
        gauges.add((Object)classLoadingStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total_unloaded"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> classes.getUnloadedClassCount()));
        gauges.add((Object)classLoadingStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"current_loaded"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> classes.getLoadedClassCount()));
        Buffer memPool = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getMemoryPoolMXBeans()).asScala();
        StatsReceiver memStats = stats.scope("mem");
        StatsReceiver currentMem = memStats.scope("current");
        StatsReceiver postGCStats = memStats.scope("postGC");
        memPool.foreach((Function1 & Serializable)pool -> {
            Object object;
            String name = StringOps.RichString$.MODULE$.regexSub$extension(StringOps$.MODULE$.RichString(pool.getName()), scala.collection.StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^\\w]")), (Function1 & Serializable)m -> "_");
            Object object2 = pool.getCollectionUsage() != null ? BoxesRunTime.boxToBoolean((boolean)gauges.add((Object)postGCStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.usage$1(pool).getUsed()))) : BoxedUnit.UNIT;
            if (pool.getUsage() != null) {
                gauges.add((Object)currentMem.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.usage$2(pool).getUsed()));
                object = BoxesRunTime.boxToBoolean((boolean)gauges.add((Object)currentMem.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "max"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> JvmStats$.usage$2(pool).getMax())));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        gauges.add((Object)postGCStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)memPool.flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)p.getCollectionUsage()))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getUsed()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        gauges.add((Object)currentMem.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"used"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)memPool.flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)p.getUsage()))).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getUsed()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        Jvm jvm = Jvm$.MODULE$.apply();
        jvm.metaspaceUsage().foreach((Function1 & Serializable)usage -> BoxesRunTime.boxToBoolean((boolean)JvmStats$.gauges.add((Object)memStats.scope("metaspace").addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max_capacity"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> usage.maxCapacity().inBytes()))));
        StatsReceiver spStats = stats.scope("safepoint");
        gauges.add((Object)spStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sync_time_millis"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> jvm.safepoint().syncTimeMillis()));
        gauges.add((Object)spStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total_time_millis"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> jvm.safepoint().totalTimeMillis()));
        gauges.add((Object)spStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"count"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> jvm.safepoint().count()));
        List<BufferPoolMXBean> list = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        if (list == null) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            StatsReceiver bufferPoolStats = memStats.scope("buffer");
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable)bp -> BoxesRunTime.boxToBoolean((boolean)JvmStats$.$anonfun$register$36(bufferPoolStats, bp)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Buffer gcPool = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        StatsReceiver gcStats = stats.scope("gc");
        gcPool.foreach((Function1 & Serializable)gc -> BoxesRunTime.boxToBoolean((boolean)JvmStats$.$anonfun$register$40(gcStats, gc)));
        gauges.add((Object)gcStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cycles"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)gcPool.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getCollectionCount()))).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$4 -> x$4 > 0L)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        gauges.add((Object)gcStats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"msec"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)gcPool.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getCollectionTime()))).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 > 0L)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
        allocations = new Allocations(gcStats);
        allocations.start();
        if (allocations.trackingEden()) {
            StatsReceiver allocationStats = memStats.scope("allocations");
            StatsReceiver eden = allocationStats.scope("eden");
            object = BoxesRunTime.boxToBoolean((boolean)gauges.add((Object)eden.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bytes"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> allocations.eden())));
        } else {
            object = BoxedUnit.UNIT;
        }
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application_time_millis"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> (float)jvm.applicationTime() / (float)1000000));
        gauges.add((Object)stats.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tenuring_threshold"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> jvm.tenuringThreshold()));
    }

    private static final MemoryUsage heap$1(MemoryMXBean mem$1) {
        return mem$1.getHeapMemoryUsage();
    }

    private static final MemoryUsage nonHeap$1(MemoryMXBean mem$1) {
        return mem$1.getNonHeapMemoryUsage();
    }

    private static final MemoryUsage usage$1(MemoryPoolMXBean pool$1) {
        return pool$1.getCollectionUsage();
    }

    private static final MemoryUsage usage$2(MemoryPoolMXBean pool$1) {
        return pool$1.getUsage();
    }

    public static final /* synthetic */ boolean $anonfun$register$36(StatsReceiver bufferPoolStats$1, BufferPoolMXBean bp) {
        String name = bp.getName();
        gauges.add((Object)bufferPoolStats$1.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "count"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> bp.getCount()));
        gauges.add((Object)bufferPoolStats$1.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "used"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> bp.getMemoryUsed()));
        return gauges.add((Object)bufferPoolStats$1.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "max"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> bp.getTotalCapacity()));
    }

    public static final /* synthetic */ boolean $anonfun$register$40(StatsReceiver gcStats$1, GarbageCollectorMXBean gc) {
        String name = StringOps.RichString$.MODULE$.regexSub$extension(StringOps$.MODULE$.RichString(gc.getName()), scala.collection.StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^\\w]")), (Function1 & Serializable)m -> "_");
        gauges.add((Object)gcStats$1.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "cycles"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> gc.getCollectionCount()));
        return gauges.add((Object)gcStats$1.addGauge((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name, "msec"}), (Function0)(JFunction0.mcF.sp & Serializable)() -> gc.getCollectionTime()));
    }

    private JvmStats$() {
    }
}

