/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hashing;

import com.twitter.hashing.ConsistentHashingDistributor$;
import com.twitter.hashing.Distributor;
import com.twitter.hashing.HashNode;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001%\u0011AdQ8og&\u001cH/\u001a8u\u0011\u0006\u001c\b.\u001b8h\t&\u001cHO]5ckR|'O\u0003\u0002\u0004\t\u00059\u0001.Y:iS:<'BA\u0003\u0007\u0003\u001d!x/\u001b;uKJT\u0011aB\u0001\u0004G>l7\u0001A\u000b\u0003\u0015]\u00192\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0019!cE\u000b\u000e\u0003\tI!\u0001\u0006\u0002\u0003\u0017\u0011K7\u000f\u001e:jEV$xN\u001d\t\u0003-]a\u0001\u0001B\u0003\u0019\u0001\t\u0007\u0011DA\u0001B#\tQR\u0004\u0005\u0002\r7%\u0011A$\u0004\u0002\b\u001d>$\b.\u001b8h!\taa$\u0003\u0002 \u001b\t\u0019\u0011I\\=\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n\u0011\u0002[1tQ:{G-Z:\u0011\u0007\rZcF\u0004\u0002%S9\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005C\u0001\u0007yI|w\u000e\u001e \n\u00039I!AK\u0007\u0002\u000fA\f7m[1hK&\u0011A&\f\u0002\u0004'\u0016\f(B\u0001\u0016\u000e!\r\u0011r&F\u0005\u0003a\t\u0011\u0001\u0002S1tQ:{G-\u001a\u0005\te\u0001\u0011\t\u0011)A\u0005g\u00059a.^7SKB\u001c\bC\u0001\u00075\u0013\t)TBA\u0002J]RD\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001%_2$G*\u001b2NK6\u001c\u0017m\u00195fIZ+'o]5p]\u000e{W\u000e\u001d7jC:\u001cW-T8eKB\u0011A\"O\u0005\u0003u5\u0011qAQ8pY\u0016\fg\u000eC\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0005}}\u0002\u0015\tE\u0002\u0013\u0001UAQ!I\u001eA\u0002\tBQAM\u001eA\u0002MBqaN\u001e\u0011\u0002\u0003\u0007\u0001\b\u0003\u0004D\u0001\u0011\u0005!\u0001R\u0001\u000eEf$X-\u0011:sCf$v\u000eT#\u0015\u0007M*U\nC\u0003G\u0005\u0002\u0007q)A\u0003csR,7\u000fE\u0002\r\u0011*K!!S\u0007\u0003\u000b\u0005\u0013(/Y=\u0011\u00051Y\u0015B\u0001'\u000e\u0005\u0011\u0011\u0015\u0010^3\t\u000b9\u0013\u0005\u0019A\u001a\u0002\r=4gm]3uQ\t\u0011\u0005\u000b\u0005\u0002\r#&\u0011!+\u0004\u0002\u0007S:d\u0017N\\3\t\rQ\u0003A\u0011\u0001\u0002V\u0003\u001dA\u0017m\u001d5J]R$2AV-\\!\taq+\u0003\u0002Y\u001b\t!QK\\5u\u0011\u0015Q6\u000b1\u00014\u0003\u0005I\u0007\"\u0002/T\u0001\u0004i\u0016AA7e!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\u001b5+7o]1hK\u0012Kw-Z:uQ\t\u0019\u0006\u000b\u0003\u0004h\u0001\u0001\u0006I\u0001[\u0001\nG>tG/\u001b8vk6\u0004B!\u001b7o]5\t!N\u0003\u0002lC\u0006!Q\u000f^5m\u0013\ti'NA\u0004Ue\u0016,W*\u00199\u0011\u00051y\u0017B\u00019\u000e\u0005\u0011auN\\4\t\u000bI\u0004A\u0011A:\u0002\u000b9|G-Z:\u0016\u0003Q\u00042aI\u0016\u0016\u0011\u00151\b\u0001\"\u0001x\u0003%qw\u000eZ3D_VtG/F\u00014\u0011\u0019I\b\u0001)C\u0005u\u0006aAO];oG\u0006$X\rS1tQR\u0011an\u001f\u0005\u0006yb\u0004\rA\\\u0001\u0005Q\u0006\u001c\b\u000eC\u0003\u007f\u0001\u0011%q0A\bnCB,e\u000e\u001e:z\r>\u0014\b*Y:i)\u0011\t\t!a\u0006\u0011\r\u0005\r\u0011\u0011\u00038/\u001d\u0011\t)!!\u0004\u000f\t\u0005\u001d\u00111\u0002\b\u0004K\u0005%\u0011\"\u00012\n\u0005-\f\u0017bAA\bU\u0006\u0019Q*\u00199\n\t\u0005M\u0011Q\u0003\u0002\u0006\u000b:$(/\u001f\u0006\u0004\u0003\u001fQ\u0007\"\u0002?~\u0001\u0004q\u0007bBA\u000e\u0001\u0011\u0005\u0011QD\u0001\u0013a\u0006\u0014H/\u001b;j_:LEMR8s\u0011\u0006\u001c\b\u000eF\u0002o\u0003?Aa\u0001`A\r\u0001\u0004q\u0007bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\rK:$(/\u001f$pe\"\u000b7\u000f\u001b\u000b\u0005\u0003O\ti\u0003E\u0003\r\u0003SqW#C\u0002\u0002,5\u0011a\u0001V;qY\u0016\u0014\u0004B\u0002?\u0002\"\u0001\u0007a\u000eC\u0004\u00022\u0001!\t!a\r\u0002\u00179|G-\u001a$pe\"\u000b7\u000f\u001b\u000b\u0004+\u0005U\u0002B\u0002?\u00020\u0001\u0007anB\u0005\u0002:\t\t\t\u0011#\u0001\u0002<\u0005a2i\u001c8tSN$XM\u001c;ICND\u0017N\\4ESN$(/\u001b2vi>\u0014\bc\u0001\n\u0002>\u0019A\u0011AAA\u0001\u0012\u0003\tydE\u0002\u0002>-Aq\u0001PA\u001f\t\u0003\t\u0019\u0005\u0006\u0002\u0002<!Q\u0011qIA\u001f#\u0003%\t!!\u0013\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\tY%!\u0019\u0016\u0005\u00055#f\u0001\u001d\u0002P-\u0012\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)hn\u00195fG.,GMC\u0002\u0002\\5\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty&!\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004\u0019\u0003\u000b\u0012\r!\u0007")
public class ConsistentHashingDistributor<A>
implements Distributor<A> {
    private final Seq<HashNode<A>> hashNodes;
    private final TreeMap<Object, HashNode<A>> continuum;

    public static <A> boolean $lessinit$greater$default$3() {
        return ConsistentHashingDistributor$.MODULE$.$lessinit$greater$default$3();
    }

    public int byteArrayToLE(byte[] bytes, int offset) {
        return bytes[3 + offset] << 24 | (bytes[2 + offset] & 0xFF) << 16 | (bytes[1 + offset] & 0xFF) << 8 | bytes[0 + offset] & 0xFF;
    }

    public void hashInt(int i, MessageDigest md) {
        int j = i;
        for (int div = (int)Math.pow(10.0, (int)Math.log10(i)); j > 9 || div >= 10; div /= 10) {
            int d = j / div;
            if (d != 0) {
                md.update((byte)(48 + d));
                j %= div;
                continue;
            }
            if (j == i) continue;
            md.update((byte)48);
        }
        md.update((byte)(48 + j));
    }

    @Override
    public Seq<A> nodes() {
        return (Seq)this.hashNodes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final A apply(HashNode<A> x$3) {
                return x$3.handle();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public int nodeCount() {
        return this.hashNodes.size();
    }

    private long truncateHash(long hash) {
        return hash & 0xFFFFFFFFL;
    }

    private Map.Entry<Object, HashNode<A>> mapEntryForHash(long hash) {
        long truncatedHash = this.truncateHash(hash);
        Map.Entry<Object, HashNode<A>> entry = this.continuum.ceilingEntry(BoxesRunTime.boxToLong((long)truncatedHash));
        return entry == null ? this.continuum.firstEntry() : entry;
    }

    @Override
    public long partitionIdForHash(long hash) {
        return BoxesRunTime.unboxToLong((Object)this.mapEntryForHash(hash).getKey());
    }

    @Override
    public Tuple2<Object, A> entryForHash(long hash) {
        Map.Entry<Object, HashNode<A>> entry = this.mapEntryForHash(hash);
        return new Tuple2(entry.getKey(), entry.getValue().handle());
    }

    @Override
    public A nodeForHash(long hash) {
        return this.mapEntryForHash(hash).getValue().handle();
    }

    public ConsistentHashingDistributor(Seq<HashNode<A>> hashNodes, int numReps, boolean oldLibMemcachedVersionComplianceMode) {
        this.hashNodes = hashNodes;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        TreeMap<Long, HashNode> underlying = new TreeMap<Long, HashNode>();
        byte dash = (byte)45;
        int nodeCount = hashNodes.size();
        int totalWeight = BoxesRunTime.unboxToInt((Object)hashNodes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, HashNode<A> x$2) {
                return x$1 + x$2.weight();
            }
        }));
        for (HashNode node : hashNodes) {
            int n;
            if (oldLibMemcachedVersionComplianceMode) {
                float percent = (float)node.weight() / (float)totalWeight;
                n = (int)((double)(percent * (float)numReps / (float)4 * (float)nodeCount) + 1.0E-10);
            } else {
                double percent = (double)node.weight() / (double)totalWeight;
                n = (int)(percent * (double)nodeCount * (double)(numReps / 4) + 1.0E-10);
            }
            int pointsOnRing = n;
            byte[] prefix = node.identifier().getBytes("UTF-8");
            for (int i = 0; i < pointsOnRing; ++i) {
                md5.update(prefix);
                md5.update(dash);
                this.hashInt(i, md5);
                byte[] buffer = md5.digest();
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 0) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 4) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 8) & 0xFFFFFFFFL)), node);
                underlying.put(BoxesRunTime.boxToLong((long)((long)this.byteArrayToLE(buffer, 12) & 0xFFFFFFFFL)), node);
            }
        }
        if (!oldLibMemcachedVersionComplianceMode) {
            Predef$.MODULE$.assert(underlying.size() <= numReps * nodeCount);
            Predef$.MODULE$.assert(underlying.size() >= numReps * (nodeCount - 1));
        }
        this.continuum = underlying;
    }
}

