/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.app;

import com.twitter.app.ClassPath;
import com.twitter.app.LoadService;
import com.twitter.app.LoadServiceClassPath;
import com.twitter.finagle.util.loadServiceDenied$;
import com.twitter.util.registry.GlobalRegistry$;
import java.io.Serializable;
import java.util.ServiceConfigurationError;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class LoadService$ {
    public static final LoadService$ MODULE$ = new LoadService$();
    private static final Logger log = Logger.getLogger("com.twitter.app.LoadService");
    private static final ConcurrentHashMap<ClassLoader, Seq<ClassPath.LoadServiceInfo>> cache = new ConcurrentHashMap();
    private static final Map<Class<?>, Seq<?>> binds = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private static final Map<Class<?>, BoxedUnit> loaded = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private static final ConcurrentHashMap<Class<?>, BoxedUnit> bindDupes = new ConcurrentHashMap();

    public void bind(LoadService.Binding<?> binding) {
        Option option;
        Map<Class<?>, Seq<?>> map = binds;
        synchronized (map) {
            if (loaded.contains(binding.iface())) {
                throw new IllegalStateException(new StringBuilder(47).append("LoadService.apply has already been called for ").append(binding.iface().getName()).append(".").toString());
            }
            option = binds.put(binding.iface(), binding.implementations());
        }
        Option prevs = option;
        prevs.foreach((Function1 & Serializable)ps -> {
            LoadService$.$anonfun$bind$1(binding, ps);
            return BoxedUnit.UNIT;
        });
    }

    public Set<Class<?>> duplicateBindings() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(bindDupes.keySet()).asScala()).toSet();
    }

    private void addToRegistry(String ifaceName, Seq<String> implClassNames) {
        GlobalRegistry$.MODULE$.get().put((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"loadservice", ifaceName})), implClassNames.mkString(","));
    }

    public <T> Seq<T> apply(Class<T> iface) {
        Seq<T> seq;
        Option allowed;
        Option option;
        String ifaceName = iface.getName();
        Map<Class<?>, Seq<?>> map = binds;
        synchronized (map) {
            loaded.put(iface, (Object)BoxedUnit.UNIT);
            option = binds.get(iface);
        }
        Option option2 = allowed = option;
        if (option2 instanceof Some) {
            Seq<T> as;
            Some some = (Some)option2;
            seq = as = (Seq<T>)some.value();
        } else if (None$.MODULE$.equals(option2)) {
            seq = this.loadImpls(iface, ifaceName);
        } else {
            throw new MatchError((Object)option2);
        }
        Seq<T> impls = seq;
        this.addToRegistry(ifaceName, (Seq<String>)((Seq)impls.map((Function1 & Serializable)x$1 -> x$1.getClass().getName())));
        return impls;
    }

    public <T> Seq<T> apply(ClassTag<T> evidence$1) {
        Class iface = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        return this.apply(iface);
    }

    private <T> Seq<T> loadImpls(Class<T> iface, String ifaceName) {
        ClassLoader loader = iface.getClassLoader();
        Set denied = (Set)loadServiceDenied$.MODULE$.apply();
        LoadServiceClassPath cp = new LoadServiceClassPath();
        Function<ClassLoader, Seq<ClassPath.LoadServiceInfo>> whenAbsent = new Function<ClassLoader, Seq<ClassPath.LoadServiceInfo>>(cp){
            private final LoadServiceClassPath cp$1;

            public <V> Function<V, Seq<ClassPath.LoadServiceInfo>> compose(Function<? super V, ? extends ClassLoader> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<ClassLoader, V> andThen(Function<? super Seq<ClassPath.LoadServiceInfo>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Seq<ClassPath.LoadServiceInfo> apply(ClassLoader loader) {
                return this.cp$1.browse(loader).toSeq();
            }
            {
                this.cp$1 = cp$1;
            }
        };
        Seq classNames = (Seq)((IterableOps)cache.computeIfAbsent(loader, whenAbsent)).withFilter((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)LoadService$.$anonfun$loadImpls$1(ifaceName, info))).flatMap((Function1 & Serializable)info -> (Seq)info.lines().map((Function1 & Serializable)className -> className));
        Iterator classNamesFromResources = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(loader.getResources(new StringBuilder(18).append("META-INF/services/").append(ifaceName).toString())).asScala()).flatMap((Function1 & Serializable)rsc -> (Seq)cp.readLines((Source)Source$.MODULE$.fromURL(rsc, "UTF-8")).map((Function1 & Serializable)line -> line));
        return (Seq)((IterableOps)((IterableOps)((SeqOps)classNames.$plus$plus((IterableOnce)classNamesFromResources)).distinct()).filterNot((Function1 & Serializable)className -> BoxesRunTime.boxToBoolean((boolean)LoadService$.$anonfun$loadImpls$6(denied, className)))).flatMap((Function1 & Serializable)className -> {
            Some some;
            Class<?> cls = Class.forName(className);
            if (!iface.isAssignableFrom(cls)) {
                throw new ServiceConfigurationError(new StringBuilder(19).append((String)className).append(" not a subclass of ").append(ifaceName).toString());
            }
            log.log(Level.FINE, new StringBuilder(61).append("LoadService: loaded instance of class ").append((String)className).append(" for requested service ").append(ifaceName).toString());
            try {
                Object instance = cls.newInstance();
                some = new Some(instance);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable ex = (Throwable)option.get();
                log.log(Level.SEVERE, new StringBuilder(0).append(new StringBuilder(56).append("LoadService: failed to instantiate '").append((String)className).append("' for the requested ").toString()).append(new StringBuilder(10).append("service '").append(ifaceName).append("'").toString()).toString(), ex);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        });
    }

    public static final /* synthetic */ void $anonfun$bind$1(LoadService.Binding binding$1, Seq ps) {
        bindDupes.put(binding$1.iface(), BoxedUnit.UNIT);
        log.warning(new StringBuilder(0).append(new StringBuilder(45).append("Replaced existing `LoadService.bind` for `").append(binding$1.iface().getName()).append("`, ").toString()).append(new StringBuilder(14).append("old='").append(ps).append("', new='").append(binding$1.implementations()).append("'").toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$loadImpls$1(String ifaceName$1, ClassPath.LoadServiceInfo info) {
        String string = info.iface();
        String string2 = ifaceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$loadImpls$6(Set denied$1, String className) {
        void var2_2;
        block0: {
            boolean isDenied = denied$1.contains((Object)className);
            if (!isDenied) break block0;
            log.info(new StringBuilder(43).append("LoadService: skipped ").append(className).append(" due to deny list flag").toString());
        }
        return (boolean)var2_2;
    }

    private LoadService$() {
    }
}

