/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.twittertext;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Range
implements Comparable<Range> {
    public static final Range EMPTY = new Range(-1, -1);
    public final int start;
    public final int end;

    public Range(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Range && ((Range)obj).start == this.start && ((Range)obj).end == this.end;
    }

    public int hashCode() {
        return 31 * this.start + 31 * this.end;
    }

    @Override
    public int compareTo(@Nonnull Range other) {
        if (this.start < other.start) {
            return -1;
        }
        if (this.start == other.start) {
            if (this.end < other.end) {
                return -1;
            }
            return this.end == other.end ? 0 : 1;
        }
        return 1;
    }

    public boolean isInRange(int val) {
        return val >= this.start && val <= this.end;
    }
}

