/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.app.App;
import com.twitter.finagle.Service;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Method$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Status$;
import com.twitter.finagle.http.Uri$;
import com.twitter.finagle.http.Version;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.server.util.HttpUtils$;
import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import com.twitter.util.Future;
import com.twitter.util.logging.Logger;
import com.twitter.util.logging.Logger$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001E3AAB\u0004\u0001!!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003'\u0001\u0011\u0005q\u0005\u0003\u0004,\u0001\u0001\u0006I\u0001\f\u0005\u0006i\u0001!\t\"\u000e\u0005\u0006\u0013\u0002!\tA\u0013\u0002\u0010'\",H\u000fZ8x]\"\u000bg\u000e\u001a7fe*\u0011\u0001\"C\u0001\bQ\u0006tG\r\\3s\u0015\tQ1\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u00195\tq\u0001^<jiR,'OC\u0001\u000f\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0003\u0013+]iR\"A\n\u000b\u0005QY\u0011a\u00024j]\u0006<G.Z\u0005\u0003-M\u0011qaU3sm&\u001cW\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b'\u0005!\u0001\u000e\u001e;q\u0013\ta\u0012DA\u0004SKF,Xm\u001d;\u0011\u0005aq\u0012BA\u0010\u001a\u0005!\u0011Vm\u001d9p]N,\u0017aA1qaB\u0011!\u0005J\u0007\u0002G)\u0011\u0001eC\u0005\u0003K\r\u00121!\u00119q\u0003\u0019a\u0014N\\5u}Q\u0011\u0001F\u000b\t\u0003S\u0001i\u0011a\u0002\u0005\u0006A\t\u0001\r!I\u0001\u0004Y><\u0007CA\u00173\u001b\u0005q#BA\u00181\u0003\u001dawnZ4j]\u001eT!!M\u0006\u0002\tU$\u0018\u000e\\\u0005\u0003g9\u0012a\u0001T8hO\u0016\u0014\u0018!D4fi\u001e\u0013\u0018mY3QCJ\fW\u000e\u0006\u00027\u000fB\u0019qG\u000f\u001f\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012aa\u00149uS>t\u0007CA\u001fE\u001d\tq$\t\u0005\u0002@q5\t\u0001I\u0003\u0002B\u001f\u00051AH]8pizJ!a\u0011\u001d\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007bBQ\u0001\u0013\u0003A\u0002]\tqA]3rk\u0016\u001cH/A\u0003baBd\u0017\u0010\u0006\u0002L\u001fB\u0019A*T\u000f\u000e\u0003AJ!A\u0014\u0019\u0003\r\u0019+H/\u001e:f\u0011\u0015\u0001V\u00011\u0001\u0018\u0003\r\u0011X-\u001d")
public class ShutdownHandler
extends Service<Request, Response> {
    private final App app;
    private final Logger log;

    public Option<String> getGraceParam(Request request) {
        return Uri$.MODULE$.fromRequest(request).params().get((Object)"grace");
    }

    public Future<Response> apply(Request req) {
        Future<Response> future;
        Object object = new Object();
        try {
            Method method = req.method();
            Method method2 = Method$.MODULE$.Post();
            if (!(method != null ? !method.equals(method2) : method2 != null)) {
                Option specifiedGracePeriod = this.getGraceParam(req).map((Function1 & Serializable & scala.Serializable)d -> {
                    Duration duration;
                    try {
                        duration = Duration$.MODULE$.parse(d);
                    }
                    catch (NumberFormatException e) {
                        String msg = new StringBuilder(59).append("could not parse 'grace' parameter: ").append((String)d).append(" is not a valid duration").toString();
                        $this.log.info(new StringBuilder(58).append("[").append(req.uri()).append("] from ").append(req.remoteAddress().getHostAddress()).append(" ").append("failed to quit due to invalid grace period format").toString(), (Throwable)e);
                        Status x$1 = Status$.MODULE$.BadRequest();
                        String x$2 = "text/plain;charset=UTF-8";
                        Buf x$3 = Buf.Utf8$.MODULE$.apply(msg);
                        Version x$4 = HttpUtils$.MODULE$.newResponse$default$1();
                        Iterable<Tuple2<String, Object>> x$5 = HttpUtils$.MODULE$.newResponse$default$3();
                        throw new NonLocalReturnControl(object, HttpUtils$.MODULE$.newResponse(x$4, x$1, x$5, x$2, x$3));
                    }
                    return duration;
                });
                Duration grace = (Duration)specifiedGracePeriod.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.app.defaultCloseGracePeriod());
                this.log.info(new StringBuilder(9).append("[").append(req.uri()).append("] from ").append(req.remoteAddress().getHostAddress()).append(" ").append(new StringBuilder(27).append("quitting with grace period ").append(grace).toString()).toString());
                this.app.close(grace);
                future = HttpUtils$.MODULE$.newOk("quitting\n", HttpUtils$.MODULE$.newOk$default$2());
            } else {
                this.log.info(new StringBuilder(47).append("ignoring [").append(req.uri()).append("] from ").append(req.remoteAddress().getHostAddress()).append(", because it is a ").append(req.method()).append(", not a POST").toString());
                Status x$6 = Status$.MODULE$.MethodNotAllowed();
                Seq x$7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Allow", (Object)"POST")}));
                String x$8 = "text/plain;charset=UTF-8";
                Buf x$9 = Buf$.MODULE$.Empty();
                Version x$10 = HttpUtils$.MODULE$.newResponse$default$1();
                future = HttpUtils$.MODULE$.newResponse(x$10, x$6, (Iterable<Tuple2<String, Object>>)x$7, x$8, x$9);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                future = (Future<Response>)ex.value();
            }
            throw ex;
        }
        return future;
    }

    public ShutdownHandler(App app) {
        this.app = app;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ShutdownHandler.class));
    }
}

