/*
Copyright 2020 Twitter, Inc.
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
https://openapi-generator.tech
Do not edit the class manually.
*/


package com.twitter.clientlib.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.model.EntityIndicesInclusiveInclusive;
import com.twitter.clientlib.model.FullTextEntitiesAnnotationsAllOf;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.twitter.clientlib.JSON;

/**
 * Annotation for entities based on the Tweet text.
 */
@ApiModel(description = "Annotation for entities based on the Tweet text.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class FullTextEntitiesAnnotations {
  public static final String SERIALIZED_NAME_END = "end";
  @SerializedName(SERIALIZED_NAME_END)
  private Integer end;

  public static final String SERIALIZED_NAME_START = "start";
  @SerializedName(SERIALIZED_NAME_START)
  private Integer start;

  public static final String SERIALIZED_NAME_NORMALIZED_TEXT = "normalized_text";
  @SerializedName(SERIALIZED_NAME_NORMALIZED_TEXT)
  private String normalizedText;

  public static final String SERIALIZED_NAME_PROBABILITY = "probability";
  @SerializedName(SERIALIZED_NAME_PROBABILITY)
  private Double probability;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public FullTextEntitiesAnnotations() { 
  }

  public FullTextEntitiesAnnotations end(Integer end) {
    
    this.end = end;
    return this;
  }

   /**
   * Index (zero-based) at which position this entity ends.  The index is inclusive.
   * minimum: 0
   * @return end
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "61", required = true, value = "Index (zero-based) at which position this entity ends.  The index is inclusive.")

  public Integer getEnd() {
    return end;
  }


  public void setEnd(Integer end) {
    this.end = end;
  }


  public FullTextEntitiesAnnotations start(Integer start) {
    
    this.start = start;
    return this;
  }

   /**
   * Index (zero-based) at which position this entity starts.  The index is inclusive.
   * minimum: 0
   * @return start
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "50", required = true, value = "Index (zero-based) at which position this entity starts.  The index is inclusive.")

  public Integer getStart() {
    return start;
  }


  public void setStart(Integer start) {
    this.start = start;
  }


  public FullTextEntitiesAnnotations normalizedText(String normalizedText) {
    
    this.normalizedText = normalizedText;
    return this;
  }

   /**
   * Text used to determine annotation.
   * @return normalizedText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Barack Obama", value = "Text used to determine annotation.")

  public String getNormalizedText() {
    return normalizedText;
  }


  public void setNormalizedText(String normalizedText) {
    this.normalizedText = normalizedText;
  }


  public FullTextEntitiesAnnotations probability(Double probability) {
    
    this.probability = probability;
    return this;
  }

   /**
   * Confidence factor for annotation type.
   * minimum: 0
   * maximum: 1
   * @return probability
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Confidence factor for annotation type.")

  public Double getProbability() {
    return probability;
  }


  public void setProbability(Double probability) {
    this.probability = probability;
  }


  public FullTextEntitiesAnnotations type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Annotation type.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Person", value = "Annotation type.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FullTextEntitiesAnnotations fullTextEntitiesAnnotations = (FullTextEntitiesAnnotations) o;
    return Objects.equals(this.end, fullTextEntitiesAnnotations.end) &&
        Objects.equals(this.start, fullTextEntitiesAnnotations.start) &&
        Objects.equals(this.normalizedText, fullTextEntitiesAnnotations.normalizedText) &&
        Objects.equals(this.probability, fullTextEntitiesAnnotations.probability) &&
        Objects.equals(this.type, fullTextEntitiesAnnotations.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(end, start, normalizedText, probability, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FullTextEntitiesAnnotations {\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    normalizedText: ").append(toIndentedString(normalizedText)).append("\n");
    sb.append("    probability: ").append(toIndentedString(probability)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("end");
    openapiFields.add("start");
    openapiFields.add("normalized_text");
    openapiFields.add("probability");
    openapiFields.add("type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("end");
    openapiRequiredFields.add("start");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to FullTextEntitiesAnnotations
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
     // if (jsonObj == null) {
     //   if (FullTextEntitiesAnnotations.openapiRequiredFields.isEmpty()) {
     //     return;
     //   } else { // has required fields
     //     throw new IllegalArgumentException(String.format("The required field(s) %s in FullTextEntitiesAnnotations is not found in the empty JSON string", FullTextEntitiesAnnotations.openapiRequiredFields.toString()));
     //   }
     // }


      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : FullTextEntitiesAnnotations.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("normalized_text") != null && !jsonObj.get("normalized_text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `normalized_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("normalized_text").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FullTextEntitiesAnnotations.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FullTextEntitiesAnnotations' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FullTextEntitiesAnnotations> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FullTextEntitiesAnnotations.class));

       return (TypeAdapter<T>) new TypeAdapter<FullTextEntitiesAnnotations>() {
           @Override
           public void write(JsonWriter out, FullTextEntitiesAnnotations value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FullTextEntitiesAnnotations read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FullTextEntitiesAnnotations given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FullTextEntitiesAnnotations
  * @throws IOException if the JSON string is invalid with respect to FullTextEntitiesAnnotations
  */
  public static FullTextEntitiesAnnotations fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FullTextEntitiesAnnotations.class);
  }

 /**
  * Convert an instance of FullTextEntitiesAnnotations to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

