/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.mopub;

import android.graphics.Color;

final class ColorUtils {
    private static final int RGB_TOTAL_COLORS = 256;
    private static final float DEFAULT_LIGHTNESS_THRESHOLD = 0.6f;
    private static final float ON_TAP_LIGHTNESS_THRESHOLD = 0.3f;
    private static final float CTA_ON_TAP_DARKNESS_FACTOR = 0.1f;
    private static final float CTA_ON_TAP_LIGHTNESS_FACTOR = 0.2f;
    private static final float CTA_TEXT_LIGHTNESS_FACTOR = 0.6f;
    private static final int OPAQUE_ALPHA = Math.round(255.0f);
    private static final int TRANSPARENT_ALPHA = Math.round(229.5f);
    private static final int COLOR_FULLY_WHITE = Math.round(255.0f);
    private static final int COLOR_PARTIALLY_BLACK = Math.round(102.0f);

    private ColorUtils() {
    }

    public static int calculateCtaTextColor(int ctaBackgroundColor) {
        if (ColorUtils.isLightColor(ctaBackgroundColor)) {
            return ColorUtils.calculateDarkerColor(ctaBackgroundColor, 0.6f);
        }
        return -1;
    }

    public static int calculateCtaOnTapColor(int ctaBackgroundColor) {
        if (ColorUtils.isLightColor(ctaBackgroundColor, 0.3f)) {
            return ColorUtils.calculateDarkerColor(ctaBackgroundColor, 0.1f);
        }
        return ColorUtils.calculateLighterColor(ctaBackgroundColor, 0.2f);
    }

    public static boolean isLightColor(int color2) {
        return ColorUtils.isLightColor(color2, 0.6f);
    }

    public static int calculateDarkerColor(int color2, float factor) {
        int a = Color.alpha((int)color2);
        int r = Color.red((int)color2);
        int g = Color.green((int)color2);
        int b = Color.blue((int)color2);
        int lightnessLevel = Math.round(256.0f * factor);
        return Color.argb((int)a, (int)Math.max(r - lightnessLevel, 0), (int)Math.max(g - lightnessLevel, 0), (int)Math.max(b - lightnessLevel, 0));
    }

    public static int calculateLighterColor(int color2, float factor) {
        int a = Color.alpha((int)color2);
        int r = Color.red((int)color2);
        int g = Color.green((int)color2);
        int b = Color.blue((int)color2);
        int lightnessLevel = Math.round(256.0f * factor);
        return Color.argb((int)a, (int)Math.min(r + lightnessLevel, 255), (int)Math.min(g + lightnessLevel, 255), (int)Math.min(b + lightnessLevel, 255));
    }

    public static int calculateContrastingColor(int color2) {
        boolean isLightColor = ColorUtils.isLightColor(color2);
        int alpha = isLightColor ? OPAQUE_ALPHA : TRANSPARENT_ALPHA;
        int rgbColor = isLightColor ? COLOR_PARTIALLY_BLACK : COLOR_FULLY_WHITE;
        return Color.argb((int)alpha, (int)rgbColor, (int)rgbColor, (int)rgbColor);
    }

    public static boolean isLightColor(int color2, float factor) {
        int b;
        int g;
        int r = Color.red((int)color2);
        double threshold = 0.21 * (double)r + 0.72 * (double)(g = Color.green((int)color2)) + 0.07 * (double)(b = Color.blue((int)color2));
        return threshold > (double)(256.0f * factor);
    }
}

