/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.mopub;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.twitter.sdk.android.mopub.ColorUtils;
import com.twitter.sdk.android.mopub.R;
import com.twitter.sdk.android.mopub.internal.RoundedImageView;

public class TwitterStaticNativeAd
extends FrameLayout {
    LinearLayout containerLayout;
    RoundedImageView mainImageView;
    RelativeLayout cardLayout;
    ImageView adIconView;
    TextView adTitleView;
    TextView adTextView;
    TextView callToActionView;
    ImageView privacyInfoView;
    int containerBackgroundColor;
    int cardBackgroundColor;
    int primaryTextColor;
    int ctaBackgroundColor;
    int cardBorderColor;
    private static final int DEFAULT_AD_STYLE = R.style.tw__ad_LightStyle;

    public TwitterStaticNativeAd(Context context) {
        this(context, null);
    }

    public TwitterStaticNativeAd(Context context, AttributeSet attrs) {
        this(context, attrs, DEFAULT_AD_STYLE);
    }

    public TwitterStaticNativeAd(Context context, AttributeSet attrs, int styleResId) {
        super(context, attrs);
        this.findSubviews();
        this.initAttributes(styleResId);
        this.setStyleAttributes();
    }

    private void findSubviews() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tw__native_ad, (ViewGroup)this, true);
        this.containerLayout = (LinearLayout)this.findViewById(R.id.tw__ad_mopub_layout);
        this.mainImageView = (RoundedImageView)this.findViewById(R.id.native_ad_main_image);
        this.cardLayout = (RelativeLayout)this.findViewById(R.id.native_ad_card);
        this.adIconView = (ImageView)this.findViewById(R.id.native_ad_icon_image);
        this.adTitleView = (TextView)this.findViewById(R.id.native_ad_title);
        this.adTextView = (TextView)this.findViewById(R.id.native_ad_text);
        this.callToActionView = (TextView)this.findViewById(R.id.native_ad_cta);
        this.privacyInfoView = (ImageView)this.findViewById(R.id.native_ad_privacy_info_icon_image);
    }

    private void initAttributes(int styleResId) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(styleResId, R.styleable.tw__native_ad);
        try {
            this.readStyleAttributes(a);
        }
        finally {
            a.recycle();
        }
    }

    private void readStyleAttributes(TypedArray typedArray) {
        this.containerBackgroundColor = typedArray.getColor(R.styleable.tw__native_ad_tw__ad_container_bg_color, this.getResources().getColor(R.color.tw__ad_light_container_bg_color));
        this.cardBackgroundColor = typedArray.getColor(R.styleable.tw__native_ad_tw__ad_card_bg_color, this.getResources().getColor(R.color.tw__ad_light_card_bg_color));
        this.primaryTextColor = typedArray.getColor(R.styleable.tw__native_ad_tw__ad_text_primary_color, this.getResources().getColor(R.color.tw__ad_light_text_primary_color));
        this.ctaBackgroundColor = typedArray.getColor(R.styleable.tw__native_ad_tw__ad_cta_button_color, this.getResources().getColor(R.color.tw__ad_cta_default));
    }

    private void setStyleAttributes() {
        this.containerLayout.setBackgroundColor(this.containerBackgroundColor);
        this.adTitleView.setTextColor(this.primaryTextColor);
        this.adTextView.setTextColor(this.primaryTextColor);
        int adViewRadius = (int)this.getResources().getDimension(R.dimen.tw__ad_view_radius);
        this.mainImageView.setCornerRadii(adViewRadius, adViewRadius, 0, 0);
        TextView privacyTextView = (TextView)this.findViewById(R.id.native_ad_privacy_text);
        privacyTextView.setTextColor(ColorUtils.calculateContrastingColor(this.containerBackgroundColor));
        this.setCardStyling();
        this.setCallToActionStyling();
    }

    private void setCardStyling() {
        boolean isLightBg = ColorUtils.isLightColor(this.containerBackgroundColor);
        this.cardBorderColor = isLightBg ? this.getResources().getColor(R.color.tw__ad_light_card_border_color) : this.getResources().getColor(R.color.tw__ad_dark_card_border_color);
        ShapeDrawable bgDrawable = new ShapeDrawable((Shape)new RectShape());
        bgDrawable.getPaint().setColor(this.cardBackgroundColor);
        ShapeDrawable borderDrawable = new ShapeDrawable((Shape)new RectShape());
        borderDrawable.getPaint().setColor(this.cardBorderColor);
        Drawable[] layers = new Drawable[]{borderDrawable, bgDrawable};
        LayerDrawable layerDrawable = new LayerDrawable(layers);
        layerDrawable.setLayerInset(0, 0, 0, 0, 0);
        layerDrawable.setLayerInset(1, 1, 0, 1, 0);
        if (Build.VERSION.SDK_INT >= 16) {
            this.cardLayout.setBackground((Drawable)layerDrawable);
        } else {
            this.cardLayout.setBackgroundDrawable((Drawable)layerDrawable);
        }
    }

    private void setCallToActionStyling() {
        int calculatedCTATextColor = ColorUtils.calculateCtaTextColor(this.ctaBackgroundColor);
        this.callToActionView.setTextColor(calculatedCTATextColor);
        StateListDrawable stateListDrawable = new StateListDrawable();
        int adViewRadius = (int)this.getResources().getDimension(R.dimen.tw__ad_view_radius);
        float[] ctaViewRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, adViewRadius, adViewRadius, adViewRadius, adViewRadius};
        GradientDrawable selectedItem = new GradientDrawable();
        selectedItem.setCornerRadii(ctaViewRadii);
        int ctaPressedBgColor = ColorUtils.calculateCtaOnTapColor(this.ctaBackgroundColor);
        selectedItem.setColor(ctaPressedBgColor);
        stateListDrawable.addState(new int[]{16842919}, (Drawable)selectedItem);
        GradientDrawable unselectedItem = new GradientDrawable();
        unselectedItem.setCornerRadii(ctaViewRadii);
        unselectedItem.setColor(this.ctaBackgroundColor);
        stateListDrawable.addState(new int[0], (Drawable)unselectedItem);
        if (Build.VERSION.SDK_INT >= 16) {
            this.callToActionView.setBackground((Drawable)stateListDrawable);
        } else {
            this.callToActionView.setBackgroundDrawable((Drawable)stateListDrawable);
        }
    }
}

