/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.mopub.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RoundedImageView
extends ImageView {
    private float[] roundedCornerRadii;

    public RoundedImageView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.setDefaultCornerRadii();
    }

    public RoundedImageView(Context context, AttributeSet attrs, int styleResId) {
        super(context, attrs, styleResId);
        this.setDefaultCornerRadii();
    }

    private void setDefaultCornerRadii() {
        this.setCornerRadii(0, 0, 0, 0);
    }

    public void setCornerRadii(int topLeftRadius, int topRightRadius, int bottomLeftRadius, int bottomRightRadius) {
        if (topLeftRadius < 0 || topRightRadius < 0 || bottomRightRadius < 0 || bottomLeftRadius < 0) {
            throw new IllegalStateException("Radius must not be negative");
        }
        this.roundedCornerRadii = new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomLeftRadius, bottomLeftRadius, bottomRightRadius, bottomRightRadius};
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageDrawable((Drawable)new BitmapDrawable(this.getResources(), this.transform(bitmap)));
    }

    private Bitmap transform(Bitmap source) {
        RectF rect = new RectF(0.0f, 0.0f, (float)source.getWidth(), (float)source.getHeight());
        Bitmap result = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)source.getConfig());
        BitmapShader bitmapShader = new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)bitmapShader);
        Path path = new Path();
        path.addRoundRect(rect, this.roundedCornerRadii, Path.Direction.CCW);
        Canvas canvas = new Canvas(result);
        canvas.drawPath(path, paint);
        return result;
    }
}

