/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.database.DataSetObserver;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Identifiable;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.TweetBuilder;
import com.twitter.sdk.android.tweetui.CompactTweetView;
import com.twitter.sdk.android.tweetui.FilterTimelineDelegate;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineDelegate;
import com.twitter.sdk.android.tweetui.TimelineFilter;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetUi;

public class TweetTimelineRecyclerViewAdapter
extends RecyclerView.Adapter<TweetViewHolder> {
    protected final Context context;
    protected final TimelineDelegate<Tweet> timelineDelegate;
    protected Callback<Tweet> actionCallback;
    protected final int styleResId;
    protected TweetUi tweetUi;
    private int previousCount;

    public TweetTimelineRecyclerViewAdapter(Context context, Timeline<Tweet> timeline) {
        this(context, timeline, R.style.tw__TweetLightStyle, null);
    }

    protected TweetTimelineRecyclerViewAdapter(Context context, Timeline<Tweet> timeline, int styleResId, Callback<Tweet> cb) {
        this(context, new TimelineDelegate<Tweet>(timeline), styleResId, cb, TweetUi.getInstance());
    }

    TweetTimelineRecyclerViewAdapter(Context context, TimelineDelegate<Tweet> timelineDelegate, int styleResId, Callback<Tweet> cb, TweetUi tweetUi) {
        this(context, timelineDelegate, styleResId);
        this.actionCallback = new ReplaceTweetCallback(timelineDelegate, cb);
        this.tweetUi = tweetUi;
    }

    TweetTimelineRecyclerViewAdapter(Context context, TimelineDelegate<Tweet> timelineDelegate, int styleResId) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        this.context = context;
        this.timelineDelegate = timelineDelegate;
        this.styleResId = styleResId;
        this.timelineDelegate.refresh(new Callback<TimelineResult<Tweet>>(){

            public void success(Result<TimelineResult<Tweet>> result) {
                TweetTimelineRecyclerViewAdapter.this.notifyDataSetChanged();
                TweetTimelineRecyclerViewAdapter.this.previousCount = TweetTimelineRecyclerViewAdapter.this.timelineDelegate.getCount();
            }

            public void failure(TwitterException exception) {
            }
        });
        DataSetObserver dataSetObserver = new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                if (TweetTimelineRecyclerViewAdapter.this.previousCount == 0) {
                    TweetTimelineRecyclerViewAdapter.this.notifyDataSetChanged();
                } else {
                    TweetTimelineRecyclerViewAdapter.this.notifyItemRangeInserted(TweetTimelineRecyclerViewAdapter.this.previousCount, TweetTimelineRecyclerViewAdapter.this.timelineDelegate.getCount() - TweetTimelineRecyclerViewAdapter.this.previousCount);
                }
                TweetTimelineRecyclerViewAdapter.this.previousCount = TweetTimelineRecyclerViewAdapter.this.timelineDelegate.getCount();
            }

            public void onInvalidated() {
                TweetTimelineRecyclerViewAdapter.this.notifyDataSetChanged();
                super.onInvalidated();
            }
        };
        this.timelineDelegate.registerDataSetObserver(dataSetObserver);
    }

    public void refresh(Callback<TimelineResult<Tweet>> cb) {
        this.timelineDelegate.refresh(cb);
        this.previousCount = 0;
    }

    public TweetViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Tweet tweet = new TweetBuilder().build();
        CompactTweetView compactTweetView = new CompactTweetView(this.context, tweet, this.styleResId);
        compactTweetView.setOnActionCallback(this.actionCallback);
        return new TweetViewHolder(compactTweetView);
    }

    public void onBindViewHolder(TweetViewHolder holder, int position) {
        Tweet tweet = this.timelineDelegate.getItem(position);
        CompactTweetView compactTweetView = (CompactTweetView)holder.itemView;
        compactTweetView.setTweet(tweet);
    }

    public int getItemCount() {
        return this.timelineDelegate.getCount();
    }

    public static class Builder {
        private Context context;
        private Timeline<Tweet> timeline;
        private Callback<Tweet> actionCallback;
        private TimelineFilter timelineFilter;
        private int styleResId = R.style.tw__TweetLightStyle;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setTimeline(Timeline<Tweet> timeline) {
            this.timeline = timeline;
            return this;
        }

        public Builder setViewStyle(int styleResId) {
            this.styleResId = styleResId;
            return this;
        }

        public Builder setOnActionCallback(Callback<Tweet> actionCallback) {
            this.actionCallback = actionCallback;
            return this;
        }

        public Builder setTimelineFilter(TimelineFilter timelineFilter) {
            this.timelineFilter = timelineFilter;
            return this;
        }

        public TweetTimelineRecyclerViewAdapter build() {
            if (this.timelineFilter == null) {
                return new TweetTimelineRecyclerViewAdapter(this.context, this.timeline, this.styleResId, this.actionCallback);
            }
            FilterTimelineDelegate delegate = new FilterTimelineDelegate(this.timeline, this.timelineFilter);
            return new TweetTimelineRecyclerViewAdapter(this.context, delegate, this.styleResId, this.actionCallback, TweetUi.getInstance());
        }
    }

    static class ReplaceTweetCallback
    extends Callback<Tweet> {
        TimelineDelegate<Tweet> delegate;
        Callback<Tweet> cb;

        ReplaceTweetCallback(TimelineDelegate<Tweet> delegate, Callback<Tweet> cb) {
            this.delegate = delegate;
            this.cb = cb;
        }

        public void success(Result<Tweet> result) {
            this.delegate.setItemById((Tweet)((Identifiable)result.data));
            if (this.cb != null) {
                this.cb.success(result);
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }

    public static final class TweetViewHolder
    extends RecyclerView.ViewHolder {
        public TweetViewHolder(CompactTweetView itemView) {
            super((View)itemView);
        }
    }
}

