/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.GuestSessionProvider;
import com.twitter.sdk.android.core.SessionManager;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.internal.scribe.DefaultScribeClient;
import com.twitter.sdk.android.core.internal.scribe.EventNamespace;
import com.twitter.sdk.android.core.internal.scribe.ScribeConfig;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.tweetui.TweetRepository;
import java.util.List;

public class TweetUi {
    @SuppressLint(value={"StaticFieldLeak"})
    static volatile TweetUi instance;
    static final String LOGTAG = "TweetUi";
    private static final String KIT_SCRIBE_NAME = "TweetUi";
    SessionManager<TwitterSession> sessionManager;
    GuestSessionProvider guestSessionProvider;
    DefaultScribeClient scribeClient;
    Context context;
    private TweetRepository tweetRepository;
    private Picasso imageLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TweetUi getInstance() {
        if (instance != null) return instance;
        Class<TweetUi> clazz = TweetUi.class;
        synchronized (TweetUi.class) {
            if (instance != null) return instance;
            instance = new TweetUi();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    TweetUi() {
        TwitterCore twitterCore = TwitterCore.getInstance();
        this.context = Twitter.getInstance().getContext(this.getIdentifier());
        this.sessionManager = twitterCore.getSessionManager();
        this.guestSessionProvider = twitterCore.getGuestSessionProvider();
        this.tweetRepository = new TweetRepository(new Handler(Looper.getMainLooper()), (SessionManager<TwitterSession>)twitterCore.getSessionManager());
        this.imageLoader = Picasso.with((Context)Twitter.getInstance().getContext(this.getIdentifier()));
        this.setUpScribeClient();
    }

    public String getIdentifier() {
        return "com.twitter.sdk.android:tweet-ui";
    }

    public String getVersion() {
        return "3.2.0.11";
    }

    private void setUpScribeClient() {
        ScribeConfig config = DefaultScribeClient.getScribeConfig((String)"TweetUi", (String)this.getVersion());
        this.scribeClient = new DefaultScribeClient(this.context, this.sessionManager, this.guestSessionProvider, Twitter.getInstance().getIdManager(), config);
    }

    void scribe(EventNamespace ... namespaces) {
        if (this.scribeClient == null) {
            return;
        }
        for (EventNamespace ns : namespaces) {
            this.scribeClient.scribe(new EventNamespace[]{ns});
        }
    }

    void scribe(EventNamespace ns, List<ScribeItem> items) {
        if (this.scribeClient == null) {
            return;
        }
        this.scribeClient.scribe(ns, items);
    }

    TweetRepository getTweetRepository() {
        return this.tweetRepository;
    }

    void setTweetRepository(TweetRepository tweetRepository) {
        this.tweetRepository = tweetRepository;
    }

    public Picasso getImageLoader() {
        return this.imageLoader;
    }

    void setImageLoader(Picasso imageLoader) {
        this.imageLoader = imageLoader;
    }
}

