/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Search;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.services.params.Geocode;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;

public class SearchTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    static final String FILTER_RETWEETS = " -filter:retweets";
    private static final String SCRIBE_SECTION = "search";
    private static final SimpleDateFormat QUERY_DATE = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    final TwitterCore twitterCore;
    final String query;
    final Geocode geocode;
    final String resultType;
    final String languageCode;
    final Integer maxItemsPerRequest;
    final String untilDate;

    SearchTimeline(TwitterCore twitterCore, String query, Geocode geocode, String resultType, String languageCode, Integer maxItemsPerRequest, String untilDate) {
        this.twitterCore = twitterCore;
        this.languageCode = languageCode;
        this.maxItemsPerRequest = maxItemsPerRequest;
        this.untilDate = untilDate;
        this.resultType = resultType;
        this.query = query == null ? null : query + FILTER_RETWEETS;
        this.geocode = geocode;
    }

    @Override
    public void next(Long sinceId, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createSearchRequest(sinceId, null).enqueue((Callback)new SearchCallback(cb));
    }

    @Override
    public void previous(Long maxId, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createSearchRequest(null, SearchTimeline.decrementMaxId(maxId)).enqueue((Callback)new SearchCallback(cb));
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    Call<Search> createSearchRequest(Long sinceId, Long maxId) {
        return this.twitterCore.getApiClient().getSearchService().tweets(this.query, this.geocode, this.languageCode, null, this.resultType, this.maxItemsPerRequest, this.untilDate, sinceId, maxId, Boolean.valueOf(true));
    }

    public static class Builder {
        private final TwitterCore twitterCore;
        private String query;
        private String lang;
        private String resultType;
        private Integer maxItemsPerRequest;
        private String untilDate;
        private Geocode geocode;

        public Builder() {
            this.resultType = ResultType.FILTERED.type;
            this.maxItemsPerRequest = 30;
            this.twitterCore = TwitterCore.getInstance();
        }

        Builder(TwitterCore twitterCore) {
            this.resultType = ResultType.FILTERED.type;
            this.maxItemsPerRequest = 30;
            this.twitterCore = twitterCore;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder geocode(Geocode geocode) {
            this.geocode = geocode;
            return this;
        }

        public Builder resultType(ResultType resultType) {
            this.resultType = resultType.type;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.lang = languageCode;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public Builder untilDate(Date date) {
            this.untilDate = QUERY_DATE.format(date);
            return this;
        }

        public SearchTimeline build() {
            if (this.query == null) {
                throw new IllegalStateException("query must not be null");
            }
            return new SearchTimeline(this.twitterCore, this.query, this.geocode, this.resultType, this.lang, this.maxItemsPerRequest, this.untilDate);
        }
    }

    public static enum ResultType {
        RECENT("recent"),
        POPULAR("popular"),
        MIXED("mixed"),
        FILTERED("filtered");

        final String type;

        private ResultType(String type) {
            this.type = type;
        }
    }

    class SearchCallback
    extends com.twitter.sdk.android.core.Callback<Search> {
        final com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb;

        SearchCallback(com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
            this.cb = cb;
        }

        public void success(Result<Search> result) {
            List tweets = ((Search)result.data).tweets;
            TimelineResult timelineResult = new TimelineResult(new TimelineCursor(tweets), tweets);
            if (this.cb != null) {
                this.cb.success(new Result(timelineResult, result.response));
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

