/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.view.View;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiException;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.TweetBuilder;
import com.twitter.sdk.android.tweetui.BaseTweetAction;
import com.twitter.sdk.android.tweetui.ToggleImageButton;
import com.twitter.sdk.android.tweetui.TweetRepository;
import com.twitter.sdk.android.tweetui.TweetScribeClient;
import com.twitter.sdk.android.tweetui.TweetScribeClientImpl;
import com.twitter.sdk.android.tweetui.TweetUi;

class LikeTweetAction
extends BaseTweetAction
implements View.OnClickListener {
    final Tweet tweet;
    final TweetRepository tweetRepository;
    final TweetUi tweetUi;
    final TweetScribeClient tweetScribeClient;

    LikeTweetAction(Tweet tweet, TweetUi tweetUi, Callback<Tweet> cb) {
        this(tweet, tweetUi, cb, new TweetScribeClientImpl(tweetUi));
    }

    LikeTweetAction(Tweet tweet, TweetUi tweetUi, Callback<Tweet> cb, TweetScribeClient tweetScribeClient) {
        super(cb);
        this.tweet = tweet;
        this.tweetUi = tweetUi;
        this.tweetScribeClient = tweetScribeClient;
        this.tweetRepository = tweetUi.getTweetRepository();
    }

    public void onClick(View view) {
        if (view instanceof ToggleImageButton) {
            ToggleImageButton toggleImageButton = (ToggleImageButton)view;
            if (this.tweet.favorited) {
                this.scribeUnFavoriteAction();
                this.tweetRepository.unfavorite(this.tweet.id, new LikeCallback(toggleImageButton, this.tweet, this.getActionCallback()));
            } else {
                this.scribeFavoriteAction();
                this.tweetRepository.favorite(this.tweet.id, new LikeCallback(toggleImageButton, this.tweet, this.getActionCallback()));
            }
        }
    }

    void scribeFavoriteAction() {
        this.tweetScribeClient.favorite(this.tweet);
    }

    void scribeUnFavoriteAction() {
        this.tweetScribeClient.unfavorite(this.tweet);
    }

    static class LikeCallback
    extends Callback<Tweet> {
        final ToggleImageButton button;
        final Tweet tweet;
        final Callback<Tweet> cb;

        LikeCallback(ToggleImageButton button, Tweet tweet, Callback<Tweet> cb) {
            this.button = button;
            this.tweet = tweet;
            this.cb = cb;
        }

        public void success(Result<Tweet> result) {
            this.cb.success(result);
        }

        public void failure(TwitterException exception) {
            if (exception instanceof TwitterApiException) {
                TwitterApiException apiException = (TwitterApiException)exception;
                int errorCode = apiException.getErrorCode();
                switch (errorCode) {
                    case 139: {
                        Tweet favorited = new TweetBuilder().copy(this.tweet).setFavorited(true).build();
                        this.cb.success(new Result((Object)favorited, null));
                        return;
                    }
                    case 144: {
                        Tweet unfavorited = new TweetBuilder().copy(this.tweet).setFavorited(false).build();
                        this.cb.success(new Result((Object)unfavorited, null));
                        return;
                    }
                }
                this.button.setToggledOn(this.tweet.favorited);
                this.cb.failure(exception);
                return;
            }
            this.button.setToggledOn(this.tweet.favorited);
            this.cb.failure(exception);
        }
    }
}

