/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class OverlayImageView
extends ImageView {
    Overlay overlay = new Overlay(null);

    public OverlayImageView(Context context) {
        super(context);
    }

    public OverlayImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.overlay.draw(canvas);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.overlay.setDrawableState(this.getDrawableState());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.overlay.setDrawableBounds(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.overlay.setDrawableBounds(width, height);
    }

    public void invalidateDrawable(Drawable drawable2) {
        if (drawable2 == this.overlay.drawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(drawable2);
        }
    }

    public void setOverlayDrawable(Drawable drawable2) {
        if (drawable2 != this.overlay.drawable) {
            this.overlay.cleanupDrawable(this);
            if (drawable2 != null) {
                drawable2.setCallback((Drawable.Callback)this);
            }
            this.overlay = new Overlay(drawable2);
            this.overlay.setDrawableState(this.getDrawableState());
            this.requestLayout();
        }
    }

    protected static class Overlay {
        final Drawable drawable;

        Overlay(Drawable drawable2) {
            this.drawable = drawable2;
        }

        protected void cleanupDrawable(ImageView imageView) {
            if (this.drawable != null) {
                this.drawable.setCallback(null);
                imageView.unscheduleDrawable(this.drawable);
            }
        }

        protected void setDrawableBounds(int width, int height) {
            if (this.drawable != null) {
                this.drawable.setBounds(0, 0, width, height);
            }
        }

        protected void setDrawableState(int[] state) {
            if (this.drawable != null && this.drawable.isStateful()) {
                this.drawable.setState(state);
            }
        }

        protected void draw(Canvas canvas) {
            if (this.drawable != null) {
                this.drawable.draw(canvas);
            }
        }
    }
}

