/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.models.Tweet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class Utils {
    private Utils() {
    }

    static Long numberOrDefault(String candidate, long defaultLong) {
        try {
            return Long.parseLong(candidate);
        }
        catch (NumberFormatException e) {
            return defaultLong;
        }
    }

    static String stringOrEmpty(String candidate) {
        return Utils.stringOrDefault(candidate, "");
    }

    static String stringOrDefault(String candidate, String defaultString) {
        return candidate != null ? candidate : defaultString;
    }

    static CharSequence charSeqOrEmpty(CharSequence candidate) {
        return Utils.charSeqOrDefault(candidate, "");
    }

    static CharSequence charSeqOrDefault(CharSequence candidate, CharSequence defaultSequence) {
        return candidate != null ? candidate : defaultSequence;
    }

    static List<Tweet> orderTweets(List<Long> tweetIds, List<Tweet> tweets) {
        HashMap<Long, Tweet> idToTweet = new HashMap<Long, Tweet>();
        ArrayList<Tweet> ordered = new ArrayList<Tweet>();
        for (Tweet tweet : tweets) {
            idToTweet.put(tweet.id, tweet);
        }
        for (Long id2 : tweetIds) {
            if (!idToTweet.containsKey(id2)) continue;
            ordered.add((Tweet)idToTweet.get(id2));
        }
        return ordered;
    }
}

