/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.util.AttributeSet;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.AbstractTweetView;
import com.twitter.sdk.android.tweetui.BaseTweetView;
import com.twitter.sdk.android.tweetui.R;

public class TweetView
extends BaseTweetView {
    private static final String VIEW_TYPE_NAME = "default";
    private static final double SQUARE_ASPECT_RATIO = 1.0;
    private static final double DEFAULT_ASPECT_RATIO_MEDIA_CONTAINER = 1.5;

    public TweetView(Context context, Tweet tweet) {
        super(context, tweet);
    }

    public TweetView(Context context, Tweet tweet, int styleResId) {
        super(context, tweet, styleResId);
    }

    TweetView(Context context, Tweet tweet, int styleResId, AbstractTweetView.DependencyProvider dependencyProvider) {
        super(context, tweet, styleResId, dependencyProvider);
    }

    public TweetView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TweetView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected int getLayout() {
        return R.layout.tw__tweet;
    }

    @Override
    void render() {
        super.render();
        this.setVerifiedCheck(this.tweet);
    }

    @Override
    protected double getAspectRatioForPhotoEntity(int photoCount) {
        if (photoCount == 4) {
            return 1.0;
        }
        return 1.5;
    }

    private void setVerifiedCheck(Tweet tweet) {
        if (tweet != null && tweet.user != null && tweet.user.verified) {
            this.fullNameView.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.tw__ic_tweet_verified, 0);
        } else {
            this.fullNameView.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        }
    }

    @Override
    String getViewTypeName() {
        return VIEW_TYPE_NAME;
    }
}

