/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.os.Handler;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.SessionManager;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterAuthException;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.FormattedTweetText;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.TweetTextUtils;
import com.twitter.sdk.android.tweetui.Utils;
import java.util.List;
import retrofit2.Callback;

class TweetRepository {
    private static final int DEFAULT_CACHE_SIZE = 20;
    private final TwitterCore twitterCore;
    private final Handler mainHandler;
    private final SessionManager<TwitterSession> userSessionManagers;
    final LruCache<Long, Tweet> tweetCache;
    final LruCache<Long, FormattedTweetText> formatCache;

    TweetRepository(Handler mainHandler, SessionManager<TwitterSession> userSessionManagers) {
        this(mainHandler, userSessionManagers, TwitterCore.getInstance());
    }

    TweetRepository(Handler mainHandler, SessionManager<TwitterSession> userSessionManagers, TwitterCore twitterCore) {
        this.twitterCore = twitterCore;
        this.mainHandler = mainHandler;
        this.userSessionManagers = userSessionManagers;
        this.tweetCache = new LruCache(20);
        this.formatCache = new LruCache(20);
    }

    FormattedTweetText formatTweetText(Tweet tweet) {
        if (tweet == null) {
            return null;
        }
        FormattedTweetText cached = (FormattedTweetText)this.formatCache.get((Object)tweet.id);
        if (cached != null) {
            return cached;
        }
        FormattedTweetText formattedTweetText = TweetTextUtils.formatTweetText(tweet);
        if (formattedTweetText != null && !TextUtils.isEmpty((CharSequence)formattedTweetText.text)) {
            this.formatCache.put((Object)tweet.id, (Object)formattedTweetText);
        }
        return formattedTweetText;
    }

    void updateCache(Tweet tweet) {
        this.tweetCache.put((Object)tweet.id, (Object)tweet);
    }

    private void deliverTweet(final Tweet tweet, final com.twitter.sdk.android.core.Callback<Tweet> cb) {
        if (cb == null) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                cb.success(new Result((Object)tweet, null));
            }
        });
    }

    void favorite(final long tweetId, final com.twitter.sdk.android.core.Callback<Tweet> cb) {
        this.getUserSession((com.twitter.sdk.android.core.Callback<TwitterSession>)new LoggingCallback<TwitterSession>(cb, Twitter.getLogger()){

            public void success(Result<TwitterSession> result) {
                TweetRepository.this.twitterCore.getApiClient((TwitterSession)result.data).getFavoriteService().create(Long.valueOf(tweetId), Boolean.valueOf(false)).enqueue((Callback)cb);
            }
        });
    }

    void unfavorite(final long tweetId, final com.twitter.sdk.android.core.Callback<Tweet> cb) {
        this.getUserSession((com.twitter.sdk.android.core.Callback<TwitterSession>)new LoggingCallback<TwitterSession>(cb, Twitter.getLogger()){

            public void success(Result<TwitterSession> result) {
                TweetRepository.this.twitterCore.getApiClient((TwitterSession)result.data).getFavoriteService().destroy(Long.valueOf(tweetId), Boolean.valueOf(false)).enqueue((Callback)cb);
            }
        });
    }

    void retweet(final long tweetId, final com.twitter.sdk.android.core.Callback<Tweet> cb) {
        this.getUserSession((com.twitter.sdk.android.core.Callback<TwitterSession>)new LoggingCallback<TwitterSession>(cb, Twitter.getLogger()){

            public void success(Result<TwitterSession> result) {
                TweetRepository.this.twitterCore.getApiClient((TwitterSession)result.data).getStatusesService().retweet(Long.valueOf(tweetId), Boolean.valueOf(false)).enqueue((Callback)cb);
            }
        });
    }

    void unretweet(final long tweetId, final com.twitter.sdk.android.core.Callback<Tweet> cb) {
        this.getUserSession((com.twitter.sdk.android.core.Callback<TwitterSession>)new LoggingCallback<TwitterSession>(cb, Twitter.getLogger()){

            public void success(Result<TwitterSession> result) {
                TweetRepository.this.twitterCore.getApiClient((TwitterSession)result.data).getStatusesService().unretweet(Long.valueOf(tweetId), Boolean.valueOf(false)).enqueue((Callback)cb);
            }
        });
    }

    void getUserSession(com.twitter.sdk.android.core.Callback<TwitterSession> cb) {
        TwitterSession session = (TwitterSession)this.userSessionManagers.getActiveSession();
        if (session == null) {
            cb.failure((TwitterException)new TwitterAuthException("User authorization required"));
        } else {
            cb.success(new Result((Object)session, null));
        }
    }

    void loadTweet(long tweetId, com.twitter.sdk.android.core.Callback<Tweet> cb) {
        Tweet cachedTweet = (Tweet)this.tweetCache.get((Object)tweetId);
        if (cachedTweet != null) {
            this.deliverTweet(cachedTweet, cb);
            return;
        }
        this.twitterCore.getApiClient().getStatusesService().show(Long.valueOf(tweetId), null, null, null).enqueue((Callback)new SingleTweetCallback(cb));
    }

    void loadTweets(List<Long> tweetIds, com.twitter.sdk.android.core.Callback<List<Tweet>> cb) {
        String commaSepIds = TextUtils.join((CharSequence)",", tweetIds);
        this.twitterCore.getApiClient().getStatusesService().lookup(commaSepIds, null, null, null).enqueue((Callback)new MultiTweetsCallback(tweetIds, cb));
    }

    class MultiTweetsCallback
    extends com.twitter.sdk.android.core.Callback<List<Tweet>> {
        final com.twitter.sdk.android.core.Callback<List<Tweet>> cb;
        final List<Long> tweetIds;

        MultiTweetsCallback(List<Long> tweetIds, com.twitter.sdk.android.core.Callback<List<Tweet>> cb) {
            this.cb = cb;
            this.tweetIds = tweetIds;
        }

        public void success(Result<List<Tweet>> result) {
            if (this.cb != null) {
                List<Tweet> sorted = Utils.orderTweets(this.tweetIds, (List)result.data);
                this.cb.success(new Result(sorted, result.response));
            }
        }

        public void failure(TwitterException exception) {
            this.cb.failure(exception);
        }
    }

    class SingleTweetCallback
    extends com.twitter.sdk.android.core.Callback<Tweet> {
        final com.twitter.sdk.android.core.Callback<Tweet> cb;

        SingleTweetCallback(com.twitter.sdk.android.core.Callback<Tweet> cb) {
            this.cb = cb;
        }

        public void success(Result<Tweet> result) {
            Tweet tweet = (Tweet)result.data;
            TweetRepository.this.updateCache(tweet);
            if (this.cb != null) {
                this.cb.success(new Result((Object)tweet, result.response));
            }
        }

        public void failure(TwitterException exception) {
            this.cb.failure(exception);
        }
    }
}

