/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.twitter.sdk.android.core.IntentUtils;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.tweetui.PlayerActivity;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.internal.SwipeToDismissTouchListener;
import com.twitter.sdk.android.tweetui.internal.VideoControlView;
import com.twitter.sdk.android.tweetui.internal.VideoView;

class PlayerController {
    private static final String TAG = "PlayerController";
    final VideoView videoView;
    final VideoControlView videoControlView;
    final ProgressBar videoProgressView;
    final TextView callToActionView;
    final View rootView;
    int seekPosition;
    boolean isPlaying = true;
    final SwipeToDismissTouchListener.Callback callback;

    PlayerController(View rootView, SwipeToDismissTouchListener.Callback callback) {
        this.rootView = rootView;
        this.videoView = (VideoView)rootView.findViewById(R.id.video_view);
        this.videoControlView = (VideoControlView)rootView.findViewById(R.id.video_control_view);
        this.videoProgressView = (ProgressBar)rootView.findViewById(R.id.video_progress_view);
        this.callToActionView = (TextView)rootView.findViewById(R.id.call_to_action_view);
        this.callback = callback;
    }

    PlayerController(View rootView, VideoView videoView, VideoControlView videoControlView, ProgressBar videoProgressView, TextView callToActionView, SwipeToDismissTouchListener.Callback callback) {
        this.rootView = rootView;
        this.videoView = videoView;
        this.videoControlView = videoControlView;
        this.videoProgressView = videoProgressView;
        this.callToActionView = callToActionView;
        this.callback = callback;
    }

    void prepare(PlayerActivity.PlayerItem item) {
        try {
            this.setUpCallToAction(item);
            this.setUpMediaControl(item.looping, item.showVideoControls);
            SwipeToDismissTouchListener listener = SwipeToDismissTouchListener.createFromView((View)this.videoView, this.callback);
            this.videoView.setOnTouchListener(listener);
            this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    PlayerController.this.videoProgressView.setVisibility(8);
                }
            });
            this.videoView.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                public boolean onInfo(MediaPlayer mediaPlayer, int what, int extra) {
                    if (what == 702) {
                        PlayerController.this.videoProgressView.setVisibility(8);
                        return true;
                    }
                    if (what == 701) {
                        PlayerController.this.videoProgressView.setVisibility(0);
                        return true;
                    }
                    return false;
                }
            });
            Uri uri = Uri.parse((String)item.url);
            this.videoView.setVideoURI(uri, item.looping);
            this.videoView.requestFocus();
        }
        catch (Exception e) {
            Twitter.getLogger().e(TAG, "Error occurred during video playback", (Throwable)e);
        }
    }

    void onResume() {
        if (this.seekPosition != 0) {
            this.videoView.seekTo(this.seekPosition);
        }
        if (this.isPlaying) {
            this.videoView.start();
            this.videoControlView.update();
        }
    }

    void onPause() {
        this.isPlaying = this.videoView.isPlaying();
        this.seekPosition = this.videoView.getCurrentPosition();
        this.videoView.pause();
    }

    void onDestroy() {
        this.videoView.stopPlayback();
    }

    void setUpMediaControl(boolean looping, boolean showVideoControls) {
        if (looping && !showVideoControls) {
            this.setUpLoopControl();
        } else {
            this.setUpMediaControl();
        }
    }

    void setUpLoopControl() {
        this.videoControlView.setVisibility(4);
        this.videoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PlayerController.this.videoView.isPlaying()) {
                    PlayerController.this.videoView.pause();
                } else {
                    PlayerController.this.videoView.start();
                }
            }
        });
    }

    void setUpMediaControl() {
        this.videoView.setMediaController(this.videoControlView);
    }

    void setUpCallToAction(PlayerActivity.PlayerItem item) {
        if (item.callToActionText != null && item.callToActionUrl != null) {
            this.callToActionView.setVisibility(0);
            this.callToActionView.setText((CharSequence)item.callToActionText);
            this.setUpCallToActionListener(item.callToActionUrl);
            this.setUpRootViewOnClickListener();
        }
    }

    void setUpCallToActionListener(final String callToActionUrl) {
        this.callToActionView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Uri uri = Uri.parse((String)callToActionUrl);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                IntentUtils.safeStartActivity((Context)PlayerController.this.callToActionView.getContext(), (Intent)intent);
            }
        });
    }

    void setUpRootViewOnClickListener() {
        this.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayerController.this.callToActionView.getVisibility() == 0) {
                    PlayerController.this.callToActionView.setVisibility(8);
                } else {
                    PlayerController.this.callToActionView.setVisibility(0);
                }
            }
        });
    }
}

