/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.models.HashtagEntity;
import com.twitter.sdk.android.core.models.MentionEntity;
import com.twitter.sdk.android.core.models.SymbolEntity;
import com.twitter.sdk.android.core.models.UrlEntity;
import com.twitter.sdk.android.tweetui.TweetUtils;

class FormattedUrlEntity {
    int start;
    int end;
    final String displayUrl;
    final String url;
    final String expandedUrl;

    FormattedUrlEntity(int start, int end, String displayUrl, String url, String expandedUrl) {
        this.start = start;
        this.end = end;
        this.displayUrl = displayUrl;
        this.url = url;
        this.expandedUrl = expandedUrl;
    }

    static FormattedUrlEntity createFormattedUrlEntity(UrlEntity entity) {
        return new FormattedUrlEntity(entity.getStart(), entity.getEnd(), entity.displayUrl, entity.url, entity.expandedUrl);
    }

    static FormattedUrlEntity createFormattedUrlEntity(HashtagEntity hashtagEntity) {
        String url = TweetUtils.getHashtagPermalink(hashtagEntity.text);
        return new FormattedUrlEntity(hashtagEntity.getStart(), hashtagEntity.getEnd(), "#" + hashtagEntity.text, url, url);
    }

    static FormattedUrlEntity createFormattedUrlEntity(MentionEntity mentionEntity) {
        String url = TweetUtils.getProfilePermalink(mentionEntity.screenName);
        return new FormattedUrlEntity(mentionEntity.getStart(), mentionEntity.getEnd(), "@" + mentionEntity.screenName, url, url);
    }

    static FormattedUrlEntity createFormattedUrlEntity(SymbolEntity symbolEntity) {
        String url = TweetUtils.getSymbolPermalink(symbolEntity.text);
        return new FormattedUrlEntity(symbolEntity.getStart(), symbolEntity.getEnd(), "$" + symbolEntity.text, url, url);
    }
}

