/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.twitter.sdk.android.core.internal.VineCardUtils;
import com.twitter.sdk.android.core.models.Card;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.internal.MediaTimeUtils;

public class MediaBadgeView
extends FrameLayout {
    TextView videoDuration;
    ImageView badge;

    public MediaBadgeView(Context context) {
        this(context, null);
    }

    public MediaBadgeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaBadgeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initSubViews(context);
    }

    void initSubViews(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.tw__media_badge, (ViewGroup)this, true);
        this.videoDuration = (TextView)view.findViewById(R.id.tw__video_duration);
        this.badge = (ImageView)view.findViewById(R.id.tw__gif_badge);
    }

    public void setMediaEntity(MediaEntity entity) {
        if ("animated_gif".equals(entity.type)) {
            this.setBadge(this.getResources().getDrawable(R.drawable.tw__gif_badge));
        } else if ("video".equals(entity.type)) {
            long duration = entity.videoInfo == null ? 0L : entity.videoInfo.durationMillis;
            this.setText(duration);
        } else {
            this.setEmpty();
        }
    }

    public void setCard(Card card) {
        if (VineCardUtils.isVine((Card)card)) {
            this.setBadge(this.getResources().getDrawable(R.drawable.tw__vine_badge));
        } else {
            this.setEmpty();
        }
    }

    void setText(long duration) {
        this.videoDuration.setVisibility(0);
        this.badge.setVisibility(8);
        this.videoDuration.setText((CharSequence)MediaTimeUtils.getPlaybackTime(duration));
    }

    void setBadge(Drawable drawable2) {
        this.badge.setVisibility(0);
        this.videoDuration.setVisibility(8);
        this.badge.setImageDrawable(drawable2);
    }

    void setEmpty() {
        this.videoDuration.setVisibility(8);
        this.badge.setVisibility(8);
    }
}

