/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import com.twitter.sdk.android.core.models.ModelUtils;
import com.twitter.sdk.android.tweetui.FormattedMediaEntity;
import com.twitter.sdk.android.tweetui.FormattedTweetText;
import com.twitter.sdk.android.tweetui.FormattedUrlEntity;
import com.twitter.sdk.android.tweetui.LinkClickListener;
import com.twitter.sdk.android.tweetui.internal.ClickableLinkSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

final class TweetTextLinkifier {
    static final Pattern QUOTED_STATUS_URL = Pattern.compile("^https?://twitter\\.com(/#!)?/\\w+/status/\\d+$");
    static final Pattern VINE_URL = Pattern.compile("^https?://vine\\.co(/#!)?/v/\\w+$");

    private TweetTextLinkifier() {
    }

    static CharSequence linkifyUrls(FormattedTweetText tweetText, LinkClickListener linkListener, int linkColor, int linkHighlightColor, boolean stripQuoteTweet, boolean stripVineCard) {
        if (tweetText == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)tweetText.text)) {
            return tweetText.text;
        }
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)tweetText.text);
        List urls = ModelUtils.getSafeList(tweetText.urlEntities);
        List media = ModelUtils.getSafeList(tweetText.mediaEntities);
        List hashtags = ModelUtils.getSafeList(tweetText.hashtagEntities);
        List mentions = ModelUtils.getSafeList(tweetText.mentionEntities);
        List symbols = ModelUtils.getSafeList(tweetText.symbolEntities);
        List<FormattedUrlEntity> combined = TweetTextLinkifier.mergeAndSortEntities(urls, media, hashtags, mentions, symbols);
        FormattedUrlEntity strippedEntity = TweetTextLinkifier.getEntityToStrip(tweetText.text, combined, stripQuoteTweet, stripVineCard);
        TweetTextLinkifier.addUrlEntities(spannable, combined, strippedEntity, linkListener, linkColor, linkHighlightColor);
        return TweetTextLinkifier.trimEnd((CharSequence)spannable);
    }

    static CharSequence trimEnd(CharSequence charSequence) {
        int length;
        for (length = charSequence.length(); length > 0 && charSequence.charAt(length - 1) <= ' '; --length) {
        }
        return length < charSequence.length() ? charSequence.subSequence(0, length) : charSequence;
    }

    static List<FormattedUrlEntity> mergeAndSortEntities(List<FormattedUrlEntity> urls, List<FormattedMediaEntity> media, List<FormattedUrlEntity> hashtags, List<FormattedUrlEntity> mentions, List<FormattedUrlEntity> symbols) {
        ArrayList<FormattedUrlEntity> combined = new ArrayList<FormattedUrlEntity>(urls);
        combined.addAll(media);
        combined.addAll(hashtags);
        combined.addAll(mentions);
        combined.addAll(symbols);
        Collections.sort(combined, new Comparator<FormattedUrlEntity>(){

            @Override
            public int compare(FormattedUrlEntity lhs, FormattedUrlEntity rhs) {
                if (lhs == null && rhs != null) {
                    return -1;
                }
                if (lhs != null && rhs == null) {
                    return 1;
                }
                if (lhs == null && rhs == null) {
                    return 0;
                }
                if (lhs.start < rhs.start) {
                    return -1;
                }
                if (lhs.start > rhs.start) {
                    return 1;
                }
                return 0;
            }
        });
        return combined;
    }

    private static void addUrlEntities(SpannableStringBuilder spannable, List<FormattedUrlEntity> entities, FormattedUrlEntity strippedEntity, final LinkClickListener linkListener, int linkColor, int linkHighlightColor) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        int offset = 0;
        for (final FormattedUrlEntity url : entities) {
            int len;
            int start = url.start - offset;
            int end = url.end - offset;
            if (start < 0 || end > spannable.length()) continue;
            if (strippedEntity != null && strippedEntity.start == url.start) {
                spannable.replace(start, end, (CharSequence)"");
                len = end - start;
                offset += len;
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)url.displayUrl)) continue;
            spannable.replace(start, end, (CharSequence)url.displayUrl);
            len = end - (start + url.displayUrl.length());
            offset += len;
            ClickableLinkSpan span = new ClickableLinkSpan(linkHighlightColor, linkColor, false){

                @Override
                public void onClick(View widget) {
                    if (linkListener == null) {
                        return;
                    }
                    linkListener.onUrlClicked(url.url);
                }
            };
            spannable.setSpan((Object)span, start, end -= len, 33);
        }
    }

    static FormattedUrlEntity getEntityToStrip(String tweetText, List<FormattedUrlEntity> combined, boolean stripQuoteTweet, boolean stripVineCard) {
        if (combined.isEmpty()) {
            return null;
        }
        FormattedUrlEntity urlEntity = combined.get(combined.size() - 1);
        if (TweetTextLinkifier.stripLtrMarker(tweetText).endsWith(urlEntity.url) && (TweetTextLinkifier.isPhotoEntity(urlEntity) || stripQuoteTweet && TweetTextLinkifier.isQuotedStatus(urlEntity) || stripVineCard && TweetTextLinkifier.isVineCard(urlEntity))) {
            return urlEntity;
        }
        return null;
    }

    static String stripLtrMarker(String tweetText) {
        if (tweetText.endsWith(Character.toString('\u200e'))) {
            return tweetText.substring(0, tweetText.length() - 1);
        }
        return tweetText;
    }

    static boolean isPhotoEntity(FormattedUrlEntity urlEntity) {
        return urlEntity instanceof FormattedMediaEntity && "photo".equals(((FormattedMediaEntity)urlEntity).type);
    }

    static boolean isQuotedStatus(FormattedUrlEntity urlEntity) {
        return QUOTED_STATUS_URL.matcher(urlEntity.expandedUrl).find();
    }

    static boolean isVineCard(FormattedUrlEntity urlEntity) {
        return VINE_URL.matcher(urlEntity.expandedUrl).find();
    }
}

