/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ImageButton;
import com.twitter.sdk.android.tweetui.R;

public class ToggleImageButton
extends ImageButton {
    private static final int[] STATE_TOGGLED_ON = new int[]{R.attr.state_toggled_on};
    boolean isToggledOn;
    String contentDescriptionOn;
    String contentDescriptionOff;
    final boolean toggleOnClick;

    public ToggleImageButton(Context context) {
        this(context, null);
    }

    public ToggleImageButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToggleImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ToggleImageButton, defStyle, 0);
            String contentDescriptionOn = a.getString(R.styleable.ToggleImageButton_contentDescriptionOn);
            String contentDescriptionOff = a.getString(R.styleable.ToggleImageButton_contentDescriptionOff);
            this.contentDescriptionOn = contentDescriptionOn == null ? (String)this.getContentDescription() : contentDescriptionOn;
            this.contentDescriptionOff = contentDescriptionOff == null ? (String)this.getContentDescription() : contentDescriptionOff;
            this.toggleOnClick = a.getBoolean(R.styleable.ToggleImageButton_toggleOnClick, true);
            this.setToggledOn(false);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 2);
        if (this.isToggledOn) {
            ToggleImageButton.mergeDrawableStates((int[])drawableState, (int[])STATE_TOGGLED_ON);
        }
        return drawableState;
    }

    public boolean performClick() {
        if (this.toggleOnClick) {
            this.toggle();
        }
        return super.performClick();
    }

    public void setToggledOn(boolean isToggledOn) {
        this.isToggledOn = isToggledOn;
        this.setContentDescription(isToggledOn ? this.contentDescriptionOn : this.contentDescriptionOff);
        this.refreshDrawableState();
    }

    public void toggle() {
        this.setToggledOn(!this.isToggledOn);
    }

    public boolean isToggledOn() {
        return this.isToggledOn;
    }
}

