/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.internal.scribe.EventNamespace;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.tweetui.GalleryScribeClient;
import com.twitter.sdk.android.tweetui.TweetUi;
import java.util.ArrayList;

public class GalleryScribeClientImpl
implements GalleryScribeClient {
    static final String TFW_CLIENT_EVENT_PAGE = "android";
    static final String TFW_CLIENT_EVENT_SECTION = "gallery";
    static final String SCRIBE_SHOW_ACTION = "show";
    static final String SCRIBE_IMPRESSION_ACTION = "impression";
    static final String SCRIBE_NAVIGATE_ACTION = "navigate";
    static final String SCRIBE_DISMISS_ACTION = "dismiss";
    final TweetUi tweetUi;

    public GalleryScribeClientImpl(TweetUi tweetUi) {
        this.tweetUi = tweetUi;
    }

    @Override
    public void show() {
        this.tweetUi.scribe(GalleryScribeClientImpl.getTfwShowNamespace());
    }

    @Override
    public void impression(ScribeItem item) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(item);
        this.tweetUi.scribe(GalleryScribeClientImpl.getTfwImpressionNamespace(), items);
    }

    @Override
    public void navigate() {
        this.tweetUi.scribe(GalleryScribeClientImpl.getTfwNavigateNamespace());
    }

    @Override
    public void dismiss() {
        this.tweetUi.scribe(GalleryScribeClientImpl.getTfwDimissNamespace());
    }

    static EventNamespace getTfwImpressionNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection(TFW_CLIENT_EVENT_SECTION).setAction(SCRIBE_IMPRESSION_ACTION).builder();
    }

    static EventNamespace getTfwShowNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection(TFW_CLIENT_EVENT_SECTION).setAction(SCRIBE_SHOW_ACTION).builder();
    }

    static EventNamespace getTfwNavigateNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection(TFW_CLIENT_EVENT_SECTION).setAction(SCRIBE_NAVIGATE_ACTION).builder();
    }

    static EventNamespace getTfwDimissNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection(TFW_CLIENT_EVENT_SECTION).setAction(SCRIBE_DISMISS_ACTION).builder();
    }
}

