/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.TweetBuilder;
import com.twitter.sdk.android.core.models.TwitterCollection;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Callback;

public class CollectionTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    static final String COLLECTION_PREFIX = "custom-";
    private static final String SCRIBE_SECTION = "collection";
    final TwitterCore twitterCore;
    final String collectionIdentifier;
    final Integer maxItemsPerRequest;

    CollectionTimeline(TwitterCore twitterCore, Long collectionId, Integer maxItemsPerRequest) {
        this.collectionIdentifier = collectionId == null ? null : COLLECTION_PREFIX + Long.toString(collectionId);
        this.twitterCore = twitterCore;
        this.maxItemsPerRequest = maxItemsPerRequest;
    }

    @Override
    public void next(Long minPosition, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createCollectionRequest(minPosition, null).enqueue((Callback)new CollectionCallback(cb));
    }

    @Override
    public void previous(Long maxPosition, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createCollectionRequest(null, maxPosition).enqueue((Callback)new CollectionCallback(cb));
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    Call<TwitterCollection> createCollectionRequest(Long minPosition, Long maxPosition) {
        return this.twitterCore.getApiClient().getCollectionService().collection(this.collectionIdentifier, this.maxItemsPerRequest, maxPosition, minPosition);
    }

    static List<Tweet> getOrderedTweets(TwitterCollection collection) {
        if (collection == null || collection.contents == null || collection.contents.tweetMap == null || collection.contents.userMap == null || collection.contents.tweetMap.isEmpty() || collection.contents.userMap.isEmpty() || collection.metadata == null || collection.metadata.timelineItems == null || collection.metadata.position == null) {
            return Collections.emptyList();
        }
        ArrayList<Tweet> tweets = new ArrayList<Tweet>();
        for (TwitterCollection.TimelineItem item : collection.metadata.timelineItems) {
            Tweet trimmedTweet = (Tweet)collection.contents.tweetMap.get(item.tweetItem.id);
            Tweet tweet = CollectionTimeline.mapTweetToUsers(trimmedTweet, collection.contents.userMap);
            tweets.add(tweet);
        }
        return tweets;
    }

    static Tweet mapTweetToUsers(Tweet trimmedTweet, Map<Long, User> userMap) {
        Long userId = trimmedTweet.user.id;
        User user = userMap.get(userId);
        TweetBuilder builder = new TweetBuilder().copy(trimmedTweet).setUser(user);
        if (trimmedTweet.quotedStatus != null) {
            Tweet quoteStatus = CollectionTimeline.mapTweetToUsers(trimmedTweet.quotedStatus, userMap);
            builder.setQuotedStatus(quoteStatus);
        }
        return builder.build();
    }

    static TimelineCursor getTimelineCursor(TwitterCollection twitterCollection) {
        if (twitterCollection == null || twitterCollection.metadata == null || twitterCollection.metadata.position == null) {
            return null;
        }
        Long minPosition = twitterCollection.metadata.position.minPosition;
        Long maxPosition = twitterCollection.metadata.position.maxPosition;
        return new TimelineCursor(minPosition, maxPosition);
    }

    public static class Builder {
        private final TwitterCore twitterCore;
        private Long collectionId;
        private Integer maxItemsPerRequest = 30;

        public Builder() {
            this.twitterCore = TwitterCore.getInstance();
        }

        Builder(TwitterCore twitterCore) {
            this.twitterCore = twitterCore;
        }

        public Builder id(Long collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public CollectionTimeline build() {
            if (this.collectionId == null) {
                throw new IllegalStateException("collection id must not be null");
            }
            return new CollectionTimeline(this.twitterCore, this.collectionId, this.maxItemsPerRequest);
        }
    }

    class CollectionCallback
    extends com.twitter.sdk.android.core.Callback<TwitterCollection> {
        final com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb;

        CollectionCallback(com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
            this.cb = cb;
        }

        public void success(Result<TwitterCollection> result) {
            TimelineCursor timelineCursor = CollectionTimeline.getTimelineCursor((TwitterCollection)result.data);
            List<Tweet> tweets = CollectionTimeline.getOrderedTweets((TwitterCollection)result.data);
            TimelineResult<Object> timelineResult = timelineCursor != null ? new TimelineResult<Tweet>(timelineCursor, tweets) : new TimelineResult(null, Collections.emptyList());
            if (this.cb != null) {
                this.cb.success(new Result(timelineResult, result.response));
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

