/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import com.twitter.sdk.android.tweetui.internal.MultiTouchImageView;
import com.twitter.sdk.android.tweetui.internal.SwipeToDismissTouchListener;

public class GalleryImageView
extends FrameLayout
implements Target {
    final MultiTouchImageView imageView;
    final ProgressBar progressBar;

    public GalleryImageView(Context context) {
        this(context, new MultiTouchImageView(context), new ProgressBar(context));
    }

    GalleryImageView(Context context, MultiTouchImageView imageView, ProgressBar progressBar) {
        super(context);
        this.imageView = imageView;
        this.progressBar = progressBar;
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2, 17);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)progressBar);
        params = new FrameLayout.LayoutParams(-1, -1, 17);
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView((View)imageView);
    }

    public void setSwipeToDismissCallback(SwipeToDismissTouchListener.Callback callback) {
        SwipeToDismissTouchListener listener = SwipeToDismissTouchListener.createFromView((View)this.imageView, callback);
        this.imageView.setOnTouchListener(listener);
    }

    public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
        this.imageView.setImageBitmap(bitmap);
        this.progressBar.setVisibility(8);
    }

    public void onBitmapFailed(Drawable errorDrawable) {
    }

    public void onPrepareLoad(Drawable placeHolderDrawable) {
        this.imageView.setImageResource(17170445);
        this.progressBar.setVisibility(0);
    }
}

