/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineResult;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;

public class UserTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    private static final String SCRIBE_SECTION = "user";
    final TwitterCore twitterCore;
    final Long userId;
    final String screenName;
    final Integer maxItemsPerRequest;
    final Boolean includeReplies;
    final Boolean includeRetweets;

    UserTimeline(TwitterCore twitterCore, Long userId, String screenName, Integer maxItemsPerRequest, Boolean includeReplies, Boolean includeRetweets) {
        this.twitterCore = twitterCore;
        this.userId = userId;
        this.screenName = screenName;
        this.maxItemsPerRequest = maxItemsPerRequest;
        this.includeReplies = includeReplies == null ? false : includeReplies;
        this.includeRetweets = includeRetweets;
    }

    @Override
    public void next(Long sinceId, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createUserTimelineRequest(sinceId, null).enqueue((Callback)new BaseTimeline.TweetsCallback(cb));
    }

    @Override
    public void previous(Long maxId, com.twitter.sdk.android.core.Callback<TimelineResult<Tweet>> cb) {
        this.createUserTimelineRequest(null, UserTimeline.decrementMaxId(maxId)).enqueue((Callback)new BaseTimeline.TweetsCallback(cb));
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    Call<List<Tweet>> createUserTimelineRequest(Long sinceId, Long maxId) {
        return this.twitterCore.getApiClient().getStatusesService().userTimeline(this.userId, this.screenName, this.maxItemsPerRequest, sinceId, maxId, Boolean.valueOf(false), Boolean.valueOf(this.includeReplies == false), null, this.includeRetweets);
    }

    public static class Builder {
        private TwitterCore twitterCore;
        private Long userId;
        private String screenName;
        private Integer maxItemsPerRequest = 30;
        private Boolean includeReplies;
        private Boolean includeRetweets;

        public Builder() {
            this.twitterCore = TwitterCore.getInstance();
        }

        Builder(TwitterCore twitterCore) {
            this.twitterCore = twitterCore;
        }

        public Builder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Builder screenName(String screenName) {
            this.screenName = screenName;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public Builder includeReplies(Boolean includeReplies) {
            this.includeReplies = includeReplies;
            return this;
        }

        public Builder includeRetweets(Boolean includeRetweets) {
            this.includeRetweets = includeRetweets;
            return this;
        }

        public UserTimeline build() {
            return new UserTimeline(this.twitterCore, this.userId, this.screenName, this.maxItemsPerRequest, this.includeReplies, this.includeRetweets);
        }
    }
}

