/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;

public class FilterValues {
    @SerializedName(value="keywords")
    public final List<String> keywords;
    @SerializedName(value="hashtags")
    public final List<String> hashtags;
    @SerializedName(value="handles")
    public final List<String> handles;
    @SerializedName(value="urls")
    public final List<String> urls;

    public FilterValues(List<String> keywords, List<String> hashtags, List<String> handles, List<String> urls) {
        this.keywords = this.getSafeList(keywords);
        this.hashtags = this.getSafeList(hashtags);
        this.handles = this.getSafeList(handles);
        this.urls = this.getSafeList(urls);
    }

    private <T> List<T> getSafeList(List<T> filters) {
        if (filters == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(filters);
    }
}

