/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.twitter.Regex;
import com.twitter.sdk.android.core.TwitterAuthToken;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.tweetcomposer.ComposerController;
import com.twitter.sdk.android.tweetcomposer.ComposerView;
import com.twitter.sdk.android.tweetcomposer.R;

public class ComposerActivity
extends Activity {
    static final String EXTRA_USER_TOKEN = "EXTRA_USER_TOKEN";
    static final String EXTRA_IMAGE_URI = "EXTRA_IMAGE_URI";
    static final String EXTRA_THEME = "EXTRA_THEME";
    static final String EXTRA_TEXT = "EXTRA_TEXT";
    static final String EXTRA_HASHTAGS = "EXTRA_HASHTAGS";
    private static final int PLACEHOLDER_ID = -1;
    private static final String PLACEHOLDER_SCREEN_NAME = "";
    private ComposerController composerController;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        TwitterAuthToken token = (TwitterAuthToken)intent.getParcelableExtra(EXTRA_USER_TOKEN);
        TwitterSession session = new TwitterSession(token, -1L, PLACEHOLDER_SCREEN_NAME);
        Uri imageUri = (Uri)intent.getParcelableExtra(EXTRA_IMAGE_URI);
        String text = intent.getStringExtra(EXTRA_TEXT);
        String hashtags = intent.getStringExtra(EXTRA_HASHTAGS);
        int themeResId = intent.getIntExtra(EXTRA_THEME, R.style.ComposerLight);
        this.setTheme(themeResId);
        this.setContentView(R.layout.tw__activity_composer);
        ComposerView composerView = (ComposerView)this.findViewById(R.id.tw__composer_view);
        this.composerController = new ComposerController(composerView, session, imageUri, text, hashtags, new FinisherImpl());
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.composerController.onClose();
    }

    public static class Builder {
        private final Context context;
        private TwitterAuthToken token;
        private int themeResId = R.style.ComposerLight;
        private Uri imageUri;
        private String text;
        private String hashtags;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            this.context = context;
        }

        public Builder session(TwitterSession session) {
            if (session == null) {
                throw new IllegalArgumentException("TwitterSession must not be null");
            }
            TwitterAuthToken token = (TwitterAuthToken)session.getAuthToken();
            if (token == null) {
                throw new IllegalArgumentException("TwitterSession token must not be null");
            }
            this.token = token;
            return this;
        }

        public Builder image(Uri imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder hashtags(String ... hashtags) {
            if (hashtags == null) {
                return this;
            }
            StringBuilder sb = new StringBuilder();
            for (String hashtag : hashtags) {
                if (!Regex.VALID_HASHTAG.matcher(hashtag).find()) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(hashtag);
            }
            this.hashtags = sb.length() == 0 ? null : sb.toString();
            return this;
        }

        public Builder darkTheme() {
            this.themeResId = R.style.ComposerDark;
            return this;
        }

        public Intent createIntent() {
            if (this.token == null) {
                throw new IllegalStateException("Must set a TwitterSession");
            }
            Intent intent = new Intent(this.context, ComposerActivity.class);
            intent.putExtra(ComposerActivity.EXTRA_USER_TOKEN, (Parcelable)this.token);
            intent.putExtra(ComposerActivity.EXTRA_IMAGE_URI, (Parcelable)this.imageUri);
            intent.putExtra(ComposerActivity.EXTRA_THEME, this.themeResId);
            intent.putExtra(ComposerActivity.EXTRA_TEXT, this.text);
            intent.putExtra(ComposerActivity.EXTRA_HASHTAGS, this.hashtags);
            return intent;
        }
    }

    class FinisherImpl
    implements Finisher {
        FinisherImpl() {
        }

        @Override
        public void finish() {
            ComposerActivity.this.finish();
        }
    }

    static interface Finisher {
        public void finish();
    }
}

